/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.repositories.blobstore.testkit.RepositoryAnalyzeAction;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.xcontent.XContentBuilder;

public class RestRepositoryAnalyzeAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_snapshot/{repository}/_analyze"));
    }

    public String getName() {
        return "repository_analyze";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) {
        RepositoryAnalyzeAction.Request analyzeRepositoryRequest = new RepositoryAnalyzeAction.Request(request.param("repository"));
        analyzeRepositoryRequest.blobCount(request.paramAsInt("blob_count", analyzeRepositoryRequest.getBlobCount()));
        analyzeRepositoryRequest.concurrency(request.paramAsInt("concurrency", analyzeRepositoryRequest.getConcurrency()));
        analyzeRepositoryRequest.readNodeCount(request.paramAsInt("read_node_count", analyzeRepositoryRequest.getReadNodeCount()));
        analyzeRepositoryRequest.earlyReadNodeCount(request.paramAsInt("early_read_node_count", analyzeRepositoryRequest.getEarlyReadNodeCount()));
        analyzeRepositoryRequest.seed(request.paramAsLong("seed", analyzeRepositoryRequest.getSeed()));
        analyzeRepositoryRequest.rareActionProbability(request.paramAsDouble("rare_action_probability", analyzeRepositoryRequest.getRareActionProbability()));
        analyzeRepositoryRequest.maxBlobSize(request.paramAsSize("max_blob_size", analyzeRepositoryRequest.getMaxBlobSize()));
        analyzeRepositoryRequest.maxTotalDataSize(request.paramAsSize("max_total_data_size", analyzeRepositoryRequest.getMaxTotalDataSize()));
        analyzeRepositoryRequest.timeout(request.paramAsTime("timeout", analyzeRepositoryRequest.getTimeout()));
        analyzeRepositoryRequest.detailed(request.paramAsBoolean("detailed", analyzeRepositoryRequest.getDetailed()));
        analyzeRepositoryRequest.abortWritePermitted(request.paramAsBoolean("rarely_abort_writes", analyzeRepositoryRequest.isAbortWritePermitted()));
        RestCancellableNodeClient cancelClient = new RestCancellableNodeClient(client, request.getHttpChannel());
        return channel -> cancelClient.execute((ActionType)RepositoryAnalyzeAction.INSTANCE, (ActionRequest)analyzeRepositoryRequest, (ActionListener)new RestStatusToXContentListener<RepositoryAnalyzeAction.Response>(channel){

            public RestResponse buildResponse(RepositoryAnalyzeAction.Response response, XContentBuilder builder) throws Exception {
                builder.humanReadable(request.paramAsBoolean("human", true));
                return super.buildResponse((StatusToXContentObject)response, builder);
            }
        });
    }
}

