/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.XPackPlugin;

public class ModelAliasMetadata
implements XPackPlugin.XPackMetadataCustom {
    public static final String NAME = "trained_model_alias";
    public static final ModelAliasMetadata EMPTY = new ModelAliasMetadata(new HashMap<String, ModelAliasEntry>());
    private static final ParseField MODEL_ALIASES = new ParseField("model_aliases", new String[0]);
    private static final ParseField MODEL_ID = new ParseField("model_id", new String[0]);
    private static final ConstructingObjectParser<ModelAliasMetadata, Void> PARSER = new ConstructingObjectParser("trained_model_alias", true, args -> new ModelAliasMetadata((Map)args[0]));
    private final Map<String, ModelAliasEntry> modelAliases;

    public static ModelAliasMetadata fromState(ClusterState cs) {
        ModelAliasMetadata modelAliasMetadata = (ModelAliasMetadata)cs.metadata().custom(NAME);
        return modelAliasMetadata == null ? EMPTY : modelAliasMetadata;
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new ModelAliasMetadataDiff(in);
    }

    public static ModelAliasMetadata fromXContent(XContentParser parser) {
        return (ModelAliasMetadata)PARSER.apply(parser, null);
    }

    public ModelAliasMetadata(Map<String, ModelAliasEntry> modelAliases) {
        this.modelAliases = Collections.unmodifiableMap(modelAliases);
    }

    public ModelAliasMetadata(StreamInput in) throws IOException {
        this.modelAliases = Collections.unmodifiableMap(in.readMap(StreamInput::readString, ModelAliasEntry::new));
    }

    public Map<String, ModelAliasEntry> modelAliases() {
        return this.modelAliases;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(MODEL_ALIASES.getPreferredName());
        for (Map.Entry<String, ModelAliasEntry> modelAliasEntry : this.modelAliases.entrySet()) {
            builder.field(modelAliasEntry.getKey(), (ToXContent)modelAliasEntry.getValue());
        }
        builder.endObject();
        return builder;
    }

    public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
        return new ModelAliasMetadataDiff((ModelAliasMetadata)previousState, this);
    }

    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public String getWriteableName() {
        return NAME;
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_7_13_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.modelAliases, StreamOutput::writeString, (stream, val) -> val.writeTo(stream));
    }

    public String getModelId(String modelAlias) {
        ModelAliasEntry entry = this.modelAliases.get(modelAlias);
        if (entry == null) {
            return null;
        }
        return entry.modelId;
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            HashMap<String, ModelAliasEntry> modelAliases = new HashMap<String, ModelAliasEntry>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                String modelAlias = p.currentName();
                modelAliases.put(modelAlias, ModelAliasEntry.fromXContent(p));
            }
            return modelAliases;
        }, MODEL_ALIASES);
    }

    static class ModelAliasMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        final Diff<Map<String, ModelAliasEntry>> modelAliasesDiff;

        ModelAliasMetadataDiff(ModelAliasMetadata before, ModelAliasMetadata after) {
            this.modelAliasesDiff = DiffableUtils.diff((Map)before.modelAliases, (Map)after.modelAliases, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer());
        }

        ModelAliasMetadataDiff(StreamInput in) throws IOException {
            this.modelAliasesDiff = DiffableUtils.readJdkMapDiff((StreamInput)in, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer(), ModelAliasEntry::new, x$0 -> ModelAliasEntry.readDiffFrom(x$0));
        }

        public Metadata.Custom apply(Metadata.Custom part) {
            return new ModelAliasMetadata((Map)this.modelAliasesDiff.apply((Object)((ModelAliasMetadata)part).modelAliases));
        }

        public String getWriteableName() {
            return ModelAliasMetadata.NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.modelAliasesDiff.writeTo(out);
        }
    }

    public static class ModelAliasEntry
    extends AbstractDiffable<ModelAliasEntry>
    implements ToXContentObject {
        private static final ConstructingObjectParser<ModelAliasEntry, Void> PARSER = new ConstructingObjectParser("model_alias_metadata_alias_entry", true, args -> new ModelAliasEntry((String)args[0]));
        private final String modelId;

        private static Diff<ModelAliasEntry> readDiffFrom(StreamInput in) throws IOException {
            return ModelAliasEntry.readDiffFrom(ModelAliasEntry::new, (StreamInput)in);
        }

        private static ModelAliasEntry fromXContent(XContentParser parser) {
            return (ModelAliasEntry)((Object)PARSER.apply(parser, null));
        }

        public ModelAliasEntry(String modelId) {
            this.modelId = modelId;
        }

        ModelAliasEntry(StreamInput in) throws IOException {
            this.modelId = in.readString();
        }

        public String getModelId() {
            return this.modelId;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MODEL_ID.getPreferredName(), this.modelId);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.modelId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ModelAliasEntry modelAliasEntry = (ModelAliasEntry)((Object)o);
            return Objects.equals(this.modelId, modelAliasEntry.modelId);
        }

        public int hashCode() {
            return Objects.hash(this.modelId);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), MODEL_ID);
        }
    }
}

