/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ccr.action.FollowParameters;

public final class PutFollowAction
extends ActionType<Response> {
    public static final PutFollowAction INSTANCE = new PutFollowAction();
    public static final String NAME = "indices:admin/xpack/ccr/put_follow";

    private PutFollowAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final boolean followIndexCreated;
        private final boolean followIndexShardsAcked;
        private final boolean indexFollowingStarted;

        public Response(boolean followIndexCreated, boolean followIndexShardsAcked, boolean indexFollowingStarted) {
            this.followIndexCreated = followIndexCreated;
            this.followIndexShardsAcked = followIndexShardsAcked;
            this.indexFollowingStarted = indexFollowingStarted;
        }

        public boolean isFollowIndexCreated() {
            return this.followIndexCreated;
        }

        public boolean isFollowIndexShardsAcked() {
            return this.followIndexShardsAcked;
        }

        public boolean isIndexFollowingStarted() {
            return this.indexFollowingStarted;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.followIndexCreated = in.readBoolean();
            this.followIndexShardsAcked = in.readBoolean();
            this.indexFollowingStarted = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.followIndexCreated);
            out.writeBoolean(this.followIndexShardsAcked);
            out.writeBoolean(this.indexFollowingStarted);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("follow_index_created", this.followIndexCreated);
            builder.field("follow_index_shards_acked", this.followIndexShardsAcked);
            builder.field("index_following_started", this.indexFollowingStarted);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.followIndexCreated == response.followIndexCreated && this.followIndexShardsAcked == response.followIndexShardsAcked && this.indexFollowingStarted == response.indexFollowingStarted;
        }

        public int hashCode() {
            return Objects.hash(this.followIndexCreated, this.followIndexShardsAcked, this.indexFollowingStarted);
        }

        public String toString() {
            return "PutFollowAction.Response{followIndexCreated=" + this.followIndexCreated + ", followIndexShardsAcked=" + this.followIndexShardsAcked + ", indexFollowingStarted=" + this.indexFollowingStarted + '}';
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest,
    ToXContentObject {
        private static final ParseField REMOTE_CLUSTER_FIELD = new ParseField("remote_cluster", new String[0]);
        private static final ParseField LEADER_INDEX_FIELD = new ParseField("leader_index", new String[0]);
        private static final ParseField SETTINGS_FIELD = new ParseField("settings", new String[0]);
        private static final ObjectParser<PutFollowParameters, Void> PARSER = new ObjectParser("indices:admin/xpack/ccr/put_follow", () -> new PutFollowParameters());
        private String remoteCluster;
        private String leaderIndex;
        private Settings settings = Settings.EMPTY;
        private String followerIndex;
        private FollowParameters parameters = new FollowParameters();
        private ActiveShardCount waitForActiveShards = ActiveShardCount.NONE;

        public static Request fromXContent(XContentParser parser, String followerIndex, ActiveShardCount waitForActiveShards) throws IOException {
            PutFollowParameters parameters = (PutFollowParameters)PARSER.parse(parser, null);
            Request request = new Request();
            request.waitForActiveShards(waitForActiveShards);
            request.setFollowerIndex(followerIndex);
            request.setRemoteCluster(parameters.remoteCluster);
            request.setLeaderIndex(parameters.leaderIndex);
            request.setSettings(parameters.settings);
            request.setParameters(parameters);
            return request;
        }

        public Request() {
        }

        public String getFollowerIndex() {
            return this.followerIndex;
        }

        public void setFollowerIndex(String followerIndex) {
            this.followerIndex = followerIndex;
        }

        public String getRemoteCluster() {
            return this.remoteCluster;
        }

        public void setRemoteCluster(String remoteCluster) {
            this.remoteCluster = remoteCluster;
        }

        public String getLeaderIndex() {
            return this.leaderIndex;
        }

        public void setLeaderIndex(String leaderIndex) {
            this.leaderIndex = leaderIndex;
        }

        public Settings getSettings() {
            return this.settings;
        }

        public void setSettings(Settings settings) {
            this.settings = Objects.requireNonNull(settings);
        }

        public FollowParameters getParameters() {
            return this.parameters;
        }

        public void setParameters(FollowParameters parameters) {
            this.parameters = parameters;
        }

        public ActiveShardCount waitForActiveShards() {
            return this.waitForActiveShards;
        }

        public void waitForActiveShards(ActiveShardCount waitForActiveShards) {
            this.waitForActiveShards = waitForActiveShards.equals((Object)ActiveShardCount.DEFAULT) ? ActiveShardCount.NONE : waitForActiveShards;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException e = this.parameters.validate();
            if (this.remoteCluster == null) {
                e = ValidateActions.addValidationError((String)(REMOTE_CLUSTER_FIELD.getPreferredName() + " is missing"), (ActionRequestValidationException)e);
            }
            if (this.leaderIndex == null) {
                e = ValidateActions.addValidationError((String)(LEADER_INDEX_FIELD.getPreferredName() + " is missing"), (ActionRequestValidationException)e);
            }
            if (this.followerIndex == null) {
                e = ValidateActions.addValidationError((String)"follower_index is missing", (ActionRequestValidationException)e);
            }
            return e;
        }

        public String[] indices() {
            return new String[]{this.followerIndex};
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.remoteCluster = in.readString();
            this.leaderIndex = in.readString();
            this.followerIndex = in.readString();
            if (in.getVersion().onOrAfter(Version.V_7_9_0)) {
                this.settings = Settings.readSettingsFromStream((StreamInput)in);
            }
            this.parameters = new FollowParameters(in);
            if (in.getVersion().onOrAfter(Version.V_6_7_0)) {
                this.waitForActiveShards(ActiveShardCount.readFrom((StreamInput)in));
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.remoteCluster);
            out.writeString(this.leaderIndex);
            out.writeString(this.followerIndex);
            if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
                Settings.writeSettingsToStream((Settings)this.settings, (StreamOutput)out);
            }
            this.parameters.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
                this.waitForActiveShards.writeTo(out);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(REMOTE_CLUSTER_FIELD.getPreferredName(), this.remoteCluster);
            builder.field(LEADER_INDEX_FIELD.getPreferredName(), this.leaderIndex);
            if (!this.settings.isEmpty()) {
                builder.startObject(SETTINGS_FIELD.getPreferredName());
                this.settings.toXContent(builder, params);
                builder.endObject();
            }
            this.parameters.toXContentFragment(builder);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.remoteCluster, request.remoteCluster) && Objects.equals(this.leaderIndex, request.leaderIndex) && Objects.equals(this.followerIndex, request.followerIndex) && Objects.equals(this.parameters, request.parameters) && Objects.equals(this.waitForActiveShards, request.waitForActiveShards);
        }

        public int hashCode() {
            return Objects.hash(this.remoteCluster, this.leaderIndex, this.followerIndex, this.parameters, this.waitForActiveShards);
        }

        static {
            PARSER.declareString((putFollowParameters, value) -> ((PutFollowParameters)putFollowParameters).remoteCluster = value, REMOTE_CLUSTER_FIELD);
            PARSER.declareString((putFollowParameters, value) -> ((PutFollowParameters)putFollowParameters).leaderIndex = value, LEADER_INDEX_FIELD);
            PARSER.declareObject((putFollowParameters, value) -> ((PutFollowParameters)putFollowParameters).settings = value, (p, c) -> Settings.fromXContent((XContentParser)p), SETTINGS_FIELD);
            FollowParameters.initParser(PARSER);
        }

        private static class PutFollowParameters
        extends FollowParameters {
            private String remoteCluster;
            private String leaderIndex;
            private Settings settings = Settings.EMPTY;

            private PutFollowParameters() {
            }
        }
    }
}

