/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.autoscaling;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.PriorityQueue;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.XContentElasticsearchExtension;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCapacity;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderContext;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderResult;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderService;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.autoscaling.MlScalingReason;
import org.elasticsearch.xpack.ml.autoscaling.NativeMemoryCapacity;
import org.elasticsearch.xpack.ml.job.JobNodeSelector;
import org.elasticsearch.xpack.ml.job.NodeLoad;
import org.elasticsearch.xpack.ml.job.NodeLoadDetector;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;
import org.elasticsearch.xpack.ml.utils.NativeMemoryCalculator;

public class MlAutoscalingDeciderService
implements AutoscalingDeciderService,
LocalNodeMasterListener {
    private static final Logger logger = LogManager.getLogger(MlAutoscalingDeciderService.class);
    private static final Duration DEFAULT_MEMORY_REFRESH_RATE = Duration.ofMinutes(15L);
    private static final String MEMORY_STALE = "unable to make scaling decision as job memory requirements are stale";
    private static final long NO_SCALE_DOWN_POSSIBLE = -1L;
    private static final long ACCEPTABLE_DIFFERENCE = ByteSizeValue.ofMb((long)1L).getBytes();
    public static final String NAME = "ml";
    public static final Setting<Integer> NUM_ANOMALY_JOBS_IN_QUEUE = Setting.intSetting((String)"num_anomaly_jobs_in_queue", (int)0, (int)0, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<Integer> NUM_ANALYTICS_JOBS_IN_QUEUE = Setting.intSetting((String)"num_analytics_jobs_in_queue", (int)0, (int)0, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<TimeValue> DOWN_SCALE_DELAY = Setting.timeSetting((String)"down_scale_delay", (TimeValue)TimeValue.timeValueHours((long)1L), (Setting.Property[])new Setting.Property[0]);
    private final NodeLoadDetector nodeLoadDetector;
    private final MlMemoryTracker mlMemoryTracker;
    private final LongSupplier timeSupplier;
    private volatile boolean isMaster;
    private volatile boolean running;
    private volatile int maxMachineMemoryPercent;
    private volatile int maxOpenJobs;
    private volatile boolean useAuto;
    private volatile long lastTimeToScale;
    private volatile long scaleDownDetected;

    public MlAutoscalingDeciderService(MlMemoryTracker memoryTracker, Settings settings, ClusterService clusterService) {
        this(new NodeLoadDetector(memoryTracker), settings, clusterService, System::currentTimeMillis);
    }

    MlAutoscalingDeciderService(NodeLoadDetector nodeLoadDetector, Settings settings, ClusterService clusterService, LongSupplier timeSupplier) {
        this.nodeLoadDetector = nodeLoadDetector;
        this.mlMemoryTracker = nodeLoadDetector.getMlMemoryTracker();
        this.maxMachineMemoryPercent = (Integer)MachineLearning.MAX_MACHINE_MEMORY_PERCENT.get(settings);
        this.maxOpenJobs = (Integer)MachineLearning.MAX_OPEN_JOBS_PER_NODE.get(settings);
        this.useAuto = (Boolean)MachineLearning.USE_AUTO_MACHINE_MEMORY_PERCENT.get(settings);
        this.timeSupplier = timeSupplier;
        this.scaleDownDetected = -1L;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_MACHINE_MEMORY_PERCENT, this::setMaxMachineMemoryPercent);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_OPEN_JOBS_PER_NODE, this::setMaxOpenJobs);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.USE_AUTO_MACHINE_MEMORY_PERCENT, this::setUseAuto);
        clusterService.addLocalNodeMasterListener((LocalNodeMasterListener)this);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void afterStart() {
                MlAutoscalingDeciderService.this.running = true;
            }

            public void beforeStop() {
                MlAutoscalingDeciderService.this.running = false;
            }
        });
    }

    static OptionalLong getNodeJvmSize(DiscoveryNode node) {
        Map nodeAttributes = node.getAttributes();
        OptionalLong value = OptionalLong.empty();
        String valueStr = (String)nodeAttributes.get("ml.max_jvm_size");
        try {
            value = OptionalLong.of(Long.parseLong(valueStr));
        }
        catch (NumberFormatException e) {
            logger.debug(() -> new ParameterizedMessage("could not parse stored string value [{}] in node attribute [{}]", (Object)valueStr, (Object)"ml.max_jvm_size"));
        }
        return value;
    }

    static List<DiscoveryNode> getNodes(ClusterState clusterState) {
        return clusterState.nodes().mastersFirstStream().filter(MachineLearning::isMlNode).collect(Collectors.toList());
    }

    static Optional<NativeMemoryCapacity> requiredCapacityForUnassignedJobs(List<String> unassignedJobs, Function<String, Long> sizeFunction, int maxNumInQueue) {
        if (unassignedJobs.isEmpty()) {
            return Optional.empty();
        }
        List jobSizes = unassignedJobs.stream().map(sizeFunction).map(l -> l == null ? 0L : l).sorted(Comparator.comparingLong(Long::longValue).reversed()).collect(Collectors.toList());
        long tierMemory = 0L;
        long nodeMemory = (Long)jobSizes.get(0) + MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes();
        Iterator iter = jobSizes.iterator();
        while (jobSizes.size() > maxNumInQueue && iter.hasNext()) {
            tierMemory += ((Long)iter.next()).longValue();
            iter.remove();
        }
        return Optional.of(new NativeMemoryCapacity(tierMemory, nodeMemory));
    }

    static Optional<Tuple<NativeMemoryCapacity, List<NodeLoad>>> determineUnassignableJobs(List<String> unassignedJobs, Function<String, Long> sizeFunction, int maxNumInQueue, List<NodeLoad> nodeLoads) {
        if (unassignedJobs.isEmpty()) {
            return Optional.empty();
        }
        if (unassignedJobs.size() < maxNumInQueue) {
            return Optional.empty();
        }
        PriorityQueue<NodeLoad.Builder> mostFreeMemoryFirst = new PriorityQueue<NodeLoad.Builder>(nodeLoads.size(), Comparator.comparingLong(v -> v.remainingJobs() == 0 ? 0L : v.getFreeMemory()).reversed());
        for (NodeLoad load : nodeLoads) {
            mostFreeMemoryFirst.add(NodeLoad.builder(load));
        }
        List jobSizes = unassignedJobs.stream().map(sizeFunction).map(l -> l == null ? 0L : l).sorted(Comparator.comparingLong(Long::longValue).reversed()).collect(Collectors.toList());
        Iterator assignmentIter = jobSizes.iterator();
        while (jobSizes.size() > maxNumInQueue && assignmentIter.hasNext()) {
            long requiredMemory = (Long)assignmentIter.next();
            NodeLoad.Builder nodeLoad = mostFreeMemoryFirst.peek();
            assert (nodeLoad != null) : "unexpected null value while calculating assignable memory";
            if (nodeLoad.getNumAssignedJobs() == 0L) {
                requiredMemory += MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes();
            }
            if (nodeLoad.getFreeMemory() < requiredMemory) continue;
            assignmentIter.remove();
            mostFreeMemoryFirst.add(mostFreeMemoryFirst.poll().incNumAssignedJobs().incAssignedJobMemory(requiredMemory));
        }
        List adjustedLoads = mostFreeMemoryFirst.stream().map(NodeLoad.Builder::build).collect(Collectors.toList());
        ArrayList<Long> unassignableMemory = new ArrayList<Long>();
        Iterator unassignableIter = jobSizes.iterator();
        while (jobSizes.size() > maxNumInQueue && unassignableIter.hasNext()) {
            unassignableMemory.add((Long)unassignableIter.next());
            unassignableIter.remove();
        }
        if (unassignableMemory.isEmpty()) {
            return Optional.of(Tuple.tuple((Object)NativeMemoryCapacity.ZERO, adjustedLoads));
        }
        return Optional.of(Tuple.tuple((Object)new NativeMemoryCapacity(unassignableMemory.stream().mapToLong(Long::longValue).sum(), (Long)unassignableMemory.get(0) + MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes()), adjustedLoads));
    }

    private static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> anomalyDetectionTasks(PersistentTasksCustomMetadata tasksCustomMetadata) {
        if (tasksCustomMetadata == null) {
            return Collections.emptyList();
        }
        return tasksCustomMetadata.findTasks("xpack/ml/job", t -> MlAutoscalingDeciderService.taskStateFilter(MlTasks.getJobStateModifiedForReassignments((PersistentTasksCustomMetadata.PersistentTask)t)));
    }

    private static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> dataframeAnalyticsTasks(PersistentTasksCustomMetadata tasksCustomMetadata) {
        if (tasksCustomMetadata == null) {
            return Collections.emptyList();
        }
        return tasksCustomMetadata.findTasks("xpack/ml/data_frame/analytics", t -> MlAutoscalingDeciderService.taskStateFilter(MlTasks.getDataFrameAnalyticsState((PersistentTasksCustomMetadata.PersistentTask)t)));
    }

    private static Collection<PersistentTasksCustomMetadata.PersistentTask<StartDatafeedAction.DatafeedParams>> datafeedTasks(PersistentTasksCustomMetadata tasksCustomMetadata) {
        if (tasksCustomMetadata == null) {
            return Collections.emptyList();
        }
        return tasksCustomMetadata.findTasks("xpack/ml/datafeed", t -> true).stream().map(p -> p).collect(Collectors.toList());
    }

    void setMaxMachineMemoryPercent(int maxMachineMemoryPercent) {
        this.maxMachineMemoryPercent = maxMachineMemoryPercent;
    }

    void setMaxOpenJobs(int maxOpenJobs) {
        this.maxOpenJobs = maxOpenJobs;
    }

    void setUseAuto(boolean useAuto) {
        this.useAuto = useAuto;
    }

    public void onMaster() {
        this.isMaster = true;
    }

    private void resetScaleDownCoolDown() {
        this.scaleDownDetected = -1L;
    }

    private boolean newScaleDownCheck() {
        return this.scaleDownDetected == -1L;
    }

    public static NativeMemoryCapacity currentScale(List<DiscoveryNode> machineLearningNodes, int maxMachineMemoryPercent, boolean useAuto) {
        long[] mlMemory = machineLearningNodes.stream().mapToLong(node -> NativeMemoryCalculator.allowedBytesForMl(node, maxMachineMemoryPercent, useAuto).orElse(0L)).toArray();
        return new NativeMemoryCapacity(Arrays.stream(mlMemory).sum(), Arrays.stream(mlMemory).max().orElse(0L), machineLearningNodes.stream().map(MlAutoscalingDeciderService::getNodeJvmSize).mapToLong(l -> l.orElse(0L)).boxed().max(Long::compare).orElse(null));
    }

    NativeMemoryCapacity currentScale(List<DiscoveryNode> machineLearningNodes) {
        return MlAutoscalingDeciderService.currentScale(machineLearningNodes, this.maxMachineMemoryPercent, this.useAuto);
    }

    public void offMaster() {
        this.isMaster = false;
    }

    public AutoscalingDeciderResult scale(Settings configuration, AutoscalingDeciderContext context) {
        if (!this.isMaster) {
            throw new IllegalArgumentException("request for scaling information is only allowed on the master node");
        }
        long previousTimeStamp = this.lastTimeToScale;
        this.lastTimeToScale = this.timeSupplier.getAsLong();
        Duration memoryTrackingStale = previousTimeStamp == 0L ? DEFAULT_MEMORY_REFRESH_RATE : Duration.ofMillis(TimeValue.timeValueMinutes((long)1L).millis() + this.lastTimeToScale - previousTimeStamp);
        ClusterState clusterState = context.state();
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)clusterState.getMetadata().custom("persistent_tasks");
        Collection<PersistentTasksCustomMetadata.PersistentTask<?>> anomalyDetectionTasks = MlAutoscalingDeciderService.anomalyDetectionTasks(tasks);
        Collection<PersistentTasksCustomMetadata.PersistentTask<?>> dataframeAnalyticsTasks = MlAutoscalingDeciderService.dataframeAnalyticsTasks(tasks);
        List<String> waitingAnomalyJobs = anomalyDetectionTasks.stream().filter(t -> JobNodeSelector.AWAITING_LAZY_ASSIGNMENT.equals((Object)t.getAssignment())).map(t -> MlTasks.jobId((String)t.getId())).collect(Collectors.toList());
        List<String> waitingAnalyticsJobs = dataframeAnalyticsTasks.stream().filter(t -> JobNodeSelector.AWAITING_LAZY_ASSIGNMENT.equals((Object)t.getAssignment())).map(t -> MlTasks.dataFrameAnalyticsId((String)t.getId())).collect(Collectors.toList());
        int numAnalyticsJobsInQueue = (Integer)NUM_ANALYTICS_JOBS_IN_QUEUE.get(configuration);
        int numAnomalyJobsInQueue = (Integer)NUM_ANOMALY_JOBS_IN_QUEUE.get(configuration);
        List<DiscoveryNode> nodes = MlAutoscalingDeciderService.getNodes(clusterState);
        NativeMemoryCapacity currentScale = this.currentScale(nodes);
        MlScalingReason.Builder reasonBuilder = MlScalingReason.builder().setWaitingAnomalyJobs(waitingAnomalyJobs).setWaitingAnalyticsJobs(waitingAnalyticsJobs).setCurrentMlCapacity(currentScale.autoscalingCapacity(this.maxMachineMemoryPercent, this.useAuto)).setPassedConfiguration(configuration);
        if (!(!nodes.isEmpty() || waitingAnomalyJobs.isEmpty() && waitingAnalyticsJobs.isEmpty())) {
            return this.scaleUpFromZero(waitingAnomalyJobs, waitingAnalyticsJobs, reasonBuilder);
        }
        if (anomalyDetectionTasks.isEmpty() && dataframeAnalyticsTasks.isEmpty()) {
            long msLeftToScale = this.msLeftToDownScale(configuration);
            if (msLeftToScale > 0L) {
                return new AutoscalingDeciderResult(context.currentCapacity(), (AutoscalingDeciderResult.Reason)reasonBuilder.setSimpleReason(String.format(Locale.ROOT, "Passing currently perceived capacity as down scale delay has not been satisfied; configured delay [%s]last detected scale down event [%s]. Will request scale down in approximately [%s]", ((TimeValue)DOWN_SCALE_DELAY.get(configuration)).getStringRep(), XContentElasticsearchExtension.DEFAULT_DATE_PRINTER.print(this.scaleDownDetected), TimeValue.timeValueMillis((long)msLeftToScale).getStringRep())).build());
            }
            return new AutoscalingDeciderResult(AutoscalingCapacity.ZERO, (AutoscalingDeciderResult.Reason)reasonBuilder.setRequiredCapacity(AutoscalingCapacity.ZERO).setSimpleReason("Requesting scale down as tier and/or node size could be smaller").build());
        }
        if (!this.mlMemoryTracker.isRecentlyRefreshed(memoryTrackingStale)) {
            logger.debug(() -> new ParameterizedMessage("view of job memory is stale given duration [{}]. Not attempting to make scaling decision", (Object)memoryTrackingStale));
            return this.buildDecisionAndRequestRefresh(reasonBuilder);
        }
        ArrayList<NodeLoad> nodeLoads = new ArrayList<NodeLoad>(nodes.size());
        boolean nodeIsMemoryAccurate = true;
        for (DiscoveryNode node : nodes) {
            NodeLoad nodeLoad = this.nodeLoadDetector.detectNodeLoad(clusterState, true, node, this.maxOpenJobs, this.maxMachineMemoryPercent, this.useAuto);
            if (nodeLoad.getError() != null) {
                logger.warn("[{}] failed to gather node load limits, failure [{}]. Returning no scale", (Object)node.getId(), (Object)nodeLoad.getError());
                return this.noScaleResultOrRefresh(reasonBuilder, true, new AutoscalingDeciderResult(context.currentCapacity(), (AutoscalingDeciderResult.Reason)reasonBuilder.setSimpleReason("Passing currently perceived capacity as there was a failure gathering node limits [" + nodeLoad.getError() + "]").build()));
            }
            nodeLoads.add(nodeLoad);
            nodeIsMemoryAccurate = nodeIsMemoryAccurate && nodeLoad.isUseMemory();
        }
        if (!nodeIsMemoryAccurate) {
            return this.noScaleResultOrRefresh(reasonBuilder, true, new AutoscalingDeciderResult(context.currentCapacity(), (AutoscalingDeciderResult.Reason)reasonBuilder.setSimpleReason("Passing currently perceived capacity as nodes were unable to provide an accurate view of their memory usage").build()));
        }
        Optional<NativeMemoryCapacity> futureFreedCapacity = this.calculateFutureAvailableCapacity(tasks, memoryTrackingStale, nodes, clusterState);
        Optional<AutoscalingDeciderResult> scaleUpDecision = this.checkForScaleUp(numAnomalyJobsInQueue, numAnalyticsJobsInQueue, nodeLoads, waitingAnomalyJobs, waitingAnalyticsJobs, futureFreedCapacity.orElse(null), currentScale, reasonBuilder);
        if (scaleUpDecision.isPresent()) {
            this.resetScaleDownCoolDown();
            return scaleUpDecision.get();
        }
        if (!waitingAnalyticsJobs.isEmpty() || !waitingAnomalyJobs.isEmpty()) {
            this.resetScaleDownCoolDown();
            return this.noScaleResultOrRefresh(reasonBuilder, !this.mlMemoryTracker.isRecentlyRefreshed(memoryTrackingStale), new AutoscalingDeciderResult(context.currentCapacity(), (AutoscalingDeciderResult.Reason)reasonBuilder.setSimpleReason(String.format(Locale.ROOT, "Passing currently perceived capacity as there are [%d] analytics and [%d] anomaly jobs in the queue, but the number in the queue is less than the configured maximum allowed  or the queued jobs will eventually be assignable at the current size. ", waitingAnalyticsJobs.size(), waitingAnomalyJobs.size())).build()));
        }
        long largestJob = Math.max(anomalyDetectionTasks.stream().filter(PersistentTasksCustomMetadata.PersistentTask::isAssigned).mapToLong(t -> {
            Long mem = this.getAnomalyMemoryRequirement((PersistentTasksCustomMetadata.PersistentTask<?>)t);
            assert (mem != null) : "unexpected null for anomaly memory requirement after recent stale check";
            return mem;
        }).max().orElse(0L), dataframeAnalyticsTasks.stream().filter(PersistentTasksCustomMetadata.PersistentTask::isAssigned).mapToLong(t -> {
            Long mem = this.getAnalyticsMemoryRequirement((PersistentTasksCustomMetadata.PersistentTask<?>)t);
            assert (mem != null) : "unexpected null for analytics memory requirement after recent stale check";
            return mem;
        }).max().orElse(0L));
        if (largestJob == 0L && dataframeAnalyticsTasks.size() + anomalyDetectionTasks.size() > 0) {
            logger.warn("The calculated minimum required node size was unexpectedly [0] as there are [{}] anomaly job tasks and [{}] data frame analytics tasks", (Object)anomalyDetectionTasks.size(), (Object)dataframeAnalyticsTasks.size());
            return this.noScaleResultOrRefresh(reasonBuilder, true, new AutoscalingDeciderResult(context.currentCapacity(), (AutoscalingDeciderResult.Reason)reasonBuilder.setSimpleReason("Passing currently perceived capacity as there are running analytics and anomaly jobs, but their memory usage estimates are inaccurate.").build()));
        }
        Optional<AutoscalingDeciderResult> maybeScaleDown = this.checkForScaleDown(nodeLoads, largestJob, currentScale, reasonBuilder).map(result -> {
            AutoscalingCapacity capacity = MlAutoscalingDeciderService.ensureScaleDown(result.requiredCapacity(), context.currentCapacity());
            if (capacity == null) {
                return null;
            }
            return new AutoscalingDeciderResult(capacity, result.reason());
        });
        if (maybeScaleDown.isPresent()) {
            long maxOpenJobs;
            long totalAssignedJobs;
            AutoscalingDeciderResult scaleDownDecisionResult = maybeScaleDown.get();
            if (nodeLoads.size() > 1 && (totalAssignedJobs = nodeLoads.stream().mapToLong(NodeLoad::getNumAssignedJobs).sum()) > (maxOpenJobs = (long)this.maxOpenJobs)) {
                String msg = String.format(Locale.ROOT, "not scaling down as the total number of jobs [%d] exceeds the setting [%s (%d)].  To allow a scale down [%s] must be increased.", totalAssignedJobs, MachineLearning.MAX_OPEN_JOBS_PER_NODE.getKey(), maxOpenJobs, MachineLearning.MAX_OPEN_JOBS_PER_NODE.getKey());
                logger.info(() -> new ParameterizedMessage("{} Calculated potential scaled down capacity [{}] ", (Object)msg, (Object)scaleDownDecisionResult.requiredCapacity()));
                return new AutoscalingDeciderResult(context.currentCapacity(), (AutoscalingDeciderResult.Reason)reasonBuilder.setSimpleReason(msg).build());
            }
            long msLeftToScale = this.msLeftToDownScale(configuration);
            if (msLeftToScale <= 0L) {
                return scaleDownDecisionResult;
            }
            TimeValue downScaleDelay = (TimeValue)DOWN_SCALE_DELAY.get(configuration);
            logger.debug(() -> new ParameterizedMessage("not scaling down as the current scale down delay [{}] is not satisfied. The last time scale down was detected [{}]. Calculated scaled down capacity [{}] ", new Object[]{downScaleDelay.getStringRep(), XContentElasticsearchExtension.DEFAULT_DATE_PRINTER.print(this.scaleDownDetected), scaleDownDecisionResult.requiredCapacity()}));
            return new AutoscalingDeciderResult(context.currentCapacity(), (AutoscalingDeciderResult.Reason)reasonBuilder.setSimpleReason(String.format(Locale.ROOT, "Passing currently perceived capacity as down scale delay has not been satisfied; configured delay [%s]last detected scale down event [%s]. Will request scale down in approximately [%s]", downScaleDelay.getStringRep(), XContentElasticsearchExtension.DEFAULT_DATE_PRINTER.print(this.scaleDownDetected), TimeValue.timeValueMillis((long)msLeftToScale).getStringRep())).build());
        }
        return this.noScaleResultOrRefresh(reasonBuilder, !this.mlMemoryTracker.isRecentlyRefreshed(memoryTrackingStale), new AutoscalingDeciderResult(context.currentCapacity(), (AutoscalingDeciderResult.Reason)reasonBuilder.setSimpleReason("Passing currently perceived capacity as no scaling changes were detected to be possible").build()));
    }

    static AutoscalingCapacity ensureScaleDown(AutoscalingCapacity scaleDownResult, AutoscalingCapacity currentCapacity) {
        if (currentCapacity == null || scaleDownResult == null) {
            return null;
        }
        AutoscalingCapacity newCapacity = new AutoscalingCapacity(new AutoscalingCapacity.AutoscalingResources(currentCapacity.total().storage(), ByteSizeValue.ofBytes((long)Math.min(scaleDownResult.total().memory().getBytes(), currentCapacity.total().memory().getBytes()))), new AutoscalingCapacity.AutoscalingResources(currentCapacity.node().storage(), ByteSizeValue.ofBytes((long)Math.min(scaleDownResult.node().memory().getBytes(), currentCapacity.node().memory().getBytes()))));
        if (scaleDownResult.node().memory().getBytes() - newCapacity.node().memory().getBytes() > ACCEPTABLE_DIFFERENCE || scaleDownResult.total().memory().getBytes() - newCapacity.total().memory().getBytes() > ACCEPTABLE_DIFFERENCE) {
            logger.warn("scale down accidentally requested a scale up, auto-corrected; initial scaling [{}], corrected [{}]", (Object)scaleDownResult, (Object)newCapacity);
        }
        return newCapacity;
    }

    AutoscalingDeciderResult noScaleResultOrRefresh(MlScalingReason.Builder reasonBuilder, boolean memoryTrackingStale, AutoscalingDeciderResult potentialResult) {
        if (memoryTrackingStale) {
            logger.debug("current view of job memory is stale given. Returning a no scale event");
            return this.buildDecisionAndRequestRefresh(reasonBuilder);
        }
        return potentialResult;
    }

    AutoscalingDeciderResult scaleUpFromZero(List<String> waitingAnomalyJobs, List<String> waitingAnalyticsJobs, MlScalingReason.Builder reasonBuilder) {
        Optional<NativeMemoryCapacity> analyticsCapacity = MlAutoscalingDeciderService.requiredCapacityForUnassignedJobs(waitingAnalyticsJobs, this::getAnalyticsMemoryRequirement, 0);
        Optional<NativeMemoryCapacity> anomalyCapacity = MlAutoscalingDeciderService.requiredCapacityForUnassignedJobs(waitingAnomalyJobs, this::getAnomalyMemoryRequirement, 0);
        NativeMemoryCapacity updatedCapacity = NativeMemoryCapacity.ZERO.merge(anomalyCapacity.orElse(NativeMemoryCapacity.ZERO)).merge(analyticsCapacity.orElse(NativeMemoryCapacity.ZERO));
        if (updatedCapacity.getNode() == 0L) {
            updatedCapacity.merge(new NativeMemoryCapacity(ByteSizeValue.ofMb((long)1024L).getBytes(), ByteSizeValue.ofMb((long)1024L).getBytes()));
        }
        updatedCapacity.merge(new NativeMemoryCapacity(MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes(), MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes()));
        AutoscalingCapacity requiredCapacity = updatedCapacity.autoscalingCapacity(this.maxMachineMemoryPercent, this.useAuto);
        return new AutoscalingDeciderResult(requiredCapacity, (AutoscalingDeciderResult.Reason)reasonBuilder.setRequiredCapacity(requiredCapacity).setSimpleReason("requesting scale up as number of jobs in queues exceeded configured limit and there are no machine learning nodes").build());
    }

    Optional<AutoscalingDeciderResult> checkForScaleUp(int numAnomalyJobsInQueue, int numAnalyticsJobsInQueue, List<NodeLoad> nodeLoads, List<String> waitingAnomalyJobs, List<String> waitingAnalyticsJobs, @Nullable NativeMemoryCapacity futureFreedCapacity, NativeMemoryCapacity currentScale, MlScalingReason.Builder reasonBuilder) {
        if (waitingAnalyticsJobs.size() > numAnalyticsJobsInQueue || waitingAnomalyJobs.size() > numAnomalyJobsInQueue) {
            Tuple<NativeMemoryCapacity, List<NodeLoad>> anomalyCapacityAndNewLoad = MlAutoscalingDeciderService.determineUnassignableJobs(waitingAnomalyJobs, this::getAnomalyMemoryRequirement, numAnomalyJobsInQueue, nodeLoads).orElse((Tuple<NativeMemoryCapacity, List<NodeLoad>>)Tuple.tuple((Object)NativeMemoryCapacity.ZERO, nodeLoads));
            Tuple<NativeMemoryCapacity, List<NodeLoad>> analyticsCapacityAndNewLoad = MlAutoscalingDeciderService.determineUnassignableJobs(waitingAnalyticsJobs, this::getAnalyticsMemoryRequirement, numAnalyticsJobsInQueue, (List)anomalyCapacityAndNewLoad.v2()).orElse((Tuple<NativeMemoryCapacity, List<NodeLoad>>)Tuple.tuple((Object)NativeMemoryCapacity.ZERO, (Object)((List)anomalyCapacityAndNewLoad.v2())));
            if (((NativeMemoryCapacity)analyticsCapacityAndNewLoad.v1()).equals(NativeMemoryCapacity.ZERO) && ((NativeMemoryCapacity)anomalyCapacityAndNewLoad.v1()).equals(NativeMemoryCapacity.ZERO)) {
                logger.debug("no_scale event as current capacity, even though there are waiting jobs, is adequate to run the queued jobs");
                return Optional.empty();
            }
            NativeMemoryCapacity updatedCapacity = NativeMemoryCapacity.from(currentScale).merge((NativeMemoryCapacity)analyticsCapacityAndNewLoad.v1()).merge((NativeMemoryCapacity)anomalyCapacityAndNewLoad.v1()).merge(new NativeMemoryCapacity(MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes(), 0L));
            AutoscalingCapacity requiredCapacity = updatedCapacity.autoscalingCapacity(this.maxMachineMemoryPercent, this.useAuto);
            return Optional.of(new AutoscalingDeciderResult(requiredCapacity, (AutoscalingDeciderResult.Reason)reasonBuilder.setRequiredCapacity(requiredCapacity).setSimpleReason("requesting scale up as number of jobs in queues exceeded configured limit and current capacity is not large enough for waiting jobs").build()));
        }
        if (!waitingAnalyticsJobs.isEmpty() || !waitingAnomalyJobs.isEmpty()) {
            Long requiredMemory;
            if (futureFreedCapacity == null) {
                Optional<Long> maxSize = Stream.concat(waitingAnalyticsJobs.stream().map(this.mlMemoryTracker::getDataFrameAnalyticsJobMemoryRequirement), waitingAnomalyJobs.stream().map(this.mlMemoryTracker::getAnomalyDetectorJobMemoryRequirement)).filter(Objects::nonNull).max(Long::compareTo);
                if (maxSize.isPresent() && maxSize.get() > currentScale.getNode()) {
                    AutoscalingCapacity requiredCapacity = new NativeMemoryCapacity(Math.max(currentScale.getTier(), maxSize.get()), maxSize.get()).autoscalingCapacity(this.maxMachineMemoryPercent, this.useAuto);
                    return Optional.of(new AutoscalingDeciderResult(requiredCapacity, (AutoscalingDeciderResult.Reason)reasonBuilder.setSimpleReason("requesting scale up as there is no node large enough to handle queued jobs").setRequiredCapacity(requiredCapacity).build()));
                }
                return Optional.empty();
            }
            long newTierNeeded = 0L;
            long newNodeMax = currentScale.getNode();
            for (String analyticsJob : waitingAnalyticsJobs) {
                requiredMemory = this.mlMemoryTracker.getDataFrameAnalyticsJobMemoryRequirement(analyticsJob);
                if (requiredMemory == null) continue;
                if (futureFreedCapacity.getNode() < requiredMemory) {
                    newTierNeeded = Math.max(requiredMemory, newTierNeeded);
                }
                newNodeMax = Math.max(newNodeMax, requiredMemory);
            }
            for (String anomalyJob : waitingAnomalyJobs) {
                requiredMemory = this.mlMemoryTracker.getAnomalyDetectorJobMemoryRequirement(anomalyJob);
                if (requiredMemory == null) continue;
                if (futureFreedCapacity.getNode() < requiredMemory) {
                    newTierNeeded = Math.max(requiredMemory, newTierNeeded);
                }
                newNodeMax = Math.max(newNodeMax, requiredMemory);
            }
            if (newNodeMax > currentScale.getNode() || newTierNeeded > 0L) {
                NativeMemoryCapacity newCapacity = new NativeMemoryCapacity(newTierNeeded, newNodeMax);
                AutoscalingCapacity requiredCapacity = NativeMemoryCapacity.from(currentScale).merge(newCapacity).autoscalingCapacity(this.maxMachineMemoryPercent, this.useAuto);
                return Optional.of(new AutoscalingDeciderResult(requiredCapacity, (AutoscalingDeciderResult.Reason)reasonBuilder.setSimpleReason("scaling up as adequate space would not automatically become available when running jobs finish").setRequiredCapacity(requiredCapacity).build()));
            }
        }
        return Optional.empty();
    }

    Optional<NativeMemoryCapacity> calculateFutureAvailableCapacity(PersistentTasksCustomMetadata tasks, Duration jobMemoryExpiry, List<DiscoveryNode> mlNodes, ClusterState clusterState) {
        Long jobSize;
        if (!this.mlMemoryTracker.isRecentlyRefreshed(jobMemoryExpiry)) {
            return Optional.empty();
        }
        List jobsWithLookbackDatafeeds = MlAutoscalingDeciderService.datafeedTasks(tasks).stream().filter(t -> ((StartDatafeedAction.DatafeedParams)t.getParams()).getEndTime() != null && t.getExecutorNode() != null).collect(Collectors.toList());
        List assignedAnalyticsJobs = MlAutoscalingDeciderService.dataframeAnalyticsTasks(tasks).stream().filter(t -> t.getExecutorNode() != null).collect(Collectors.toList());
        HashMap<String, Long> freeMemoryByNodeId = new HashMap<String, Long>();
        for (DiscoveryNode node : mlNodes) {
            NodeLoad nodeLoad = this.nodeLoadDetector.detectNodeLoad(clusterState, true, node, this.maxOpenJobs, this.maxMachineMemoryPercent, this.useAuto);
            if (nodeLoad.getError() != null || !nodeLoad.isUseMemory()) {
                return Optional.empty();
            }
            freeMemoryByNodeId.put(node.getId(), nodeLoad.getFreeMemory());
        }
        for (PersistentTasksCustomMetadata.PersistentTask lookbackOnlyDf : jobsWithLookbackDatafeeds) {
            jobSize = this.mlMemoryTracker.getAnomalyDetectorJobMemoryRequirement(((StartDatafeedAction.DatafeedParams)lookbackOnlyDf.getParams()).getJobId());
            if (jobSize == null) {
                return Optional.empty();
            }
            freeMemoryByNodeId.compute(lookbackOnlyDf.getExecutorNode(), (_k, v) -> v == null ? jobSize : jobSize + v);
        }
        for (PersistentTasksCustomMetadata.PersistentTask task : assignedAnalyticsJobs) {
            jobSize = this.mlMemoryTracker.getDataFrameAnalyticsJobMemoryRequirement(MlTasks.dataFrameAnalyticsId((String)task.getId()));
            if (jobSize == null) {
                return Optional.empty();
            }
            freeMemoryByNodeId.compute(task.getExecutorNode(), (_k, v) -> v == null ? jobSize : jobSize + v);
        }
        return Optional.of(new NativeMemoryCapacity(freeMemoryByNodeId.values().stream().mapToLong(Long::longValue).sum(), freeMemoryByNodeId.values().stream().mapToLong(Long::longValue).max().orElse(0L)));
    }

    private AutoscalingDeciderResult buildDecisionAndRequestRefresh(MlScalingReason.Builder reasonBuilder) {
        this.mlMemoryTracker.asyncRefresh();
        return new AutoscalingDeciderResult(null, (AutoscalingDeciderResult.Reason)reasonBuilder.setSimpleReason(MEMORY_STALE).build());
    }

    private Long getAnalyticsMemoryRequirement(String analyticsId) {
        return this.mlMemoryTracker.getDataFrameAnalyticsJobMemoryRequirement(analyticsId);
    }

    private Long getAnalyticsMemoryRequirement(PersistentTasksCustomMetadata.PersistentTask<?> task) {
        return this.getAnalyticsMemoryRequirement(MlTasks.dataFrameAnalyticsId((String)task.getId()));
    }

    private Long getAnomalyMemoryRequirement(String anomalyId) {
        return this.mlMemoryTracker.getAnomalyDetectorJobMemoryRequirement(anomalyId);
    }

    private Long getAnomalyMemoryRequirement(PersistentTasksCustomMetadata.PersistentTask<?> task) {
        return this.getAnomalyMemoryRequirement(MlTasks.jobId((String)task.getId()));
    }

    Optional<AutoscalingDeciderResult> checkForScaleDown(List<NodeLoad> nodeLoads, long largestJob, NativeMemoryCapacity currentCapacity, MlScalingReason.Builder reasonBuilder) {
        long currentlyNecessaryNode;
        long currentlyNecessaryTier = nodeLoads.stream().mapToLong(NodeLoad::getAssignedJobMemory).sum();
        long l = currentlyNecessaryNode = largestJob == 0L ? 0L : largestJob + MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes();
        if (currentlyNecessaryNode > 0L && this.useAuto) {
            currentlyNecessaryNode = Math.max(currentlyNecessaryNode, NativeMemoryCalculator.allowedBytesForMl(NativeMemoryCalculator.MINIMUM_AUTOMATIC_NODE_SIZE, this.maxMachineMemoryPercent, this.useAuto));
        }
        if (currentlyNecessaryTier < currentCapacity.getTier() || currentlyNecessaryNode < currentCapacity.getNode()) {
            NativeMemoryCapacity nativeMemoryCapacity = new NativeMemoryCapacity(Math.min(currentlyNecessaryTier, currentCapacity.getTier()), Math.min(currentlyNecessaryNode, currentCapacity.getNode()), currentlyNecessaryNode == currentCapacity.getNode() ? currentCapacity.getJvmSize() : null);
            AutoscalingCapacity requiredCapacity = nativeMemoryCapacity.autoscalingCapacity(this.maxMachineMemoryPercent, this.useAuto);
            return Optional.of(new AutoscalingDeciderResult(requiredCapacity, (AutoscalingDeciderResult.Reason)reasonBuilder.setRequiredCapacity(requiredCapacity).setSimpleReason("Requesting scale down as tier and/or node size could be smaller").build()));
        }
        return Optional.empty();
    }

    private long msLeftToDownScale(Settings configuration) {
        long now = this.timeSupplier.getAsLong();
        if (this.newScaleDownCheck()) {
            this.scaleDownDetected = now;
        }
        TimeValue downScaleDelay = (TimeValue)DOWN_SCALE_DELAY.get(configuration);
        return downScaleDelay.millis() - (now - this.scaleDownDetected);
    }

    public String name() {
        return NAME;
    }

    public List<Setting<?>> deciderSettings() {
        return org.elasticsearch.core.List.of((Object[])new Setting[]{NUM_ANALYTICS_JOBS_IN_QUEUE, NUM_ANOMALY_JOBS_IN_QUEUE, DOWN_SCALE_DELAY});
    }

    public List<DiscoveryNodeRole> roles() {
        return org.elasticsearch.core.List.of((Object)MachineLearning.ML_ROLE);
    }

    private static boolean taskStateFilter(JobState jobState) {
        return jobState == null || jobState.isNoneOf(new JobState[]{JobState.CLOSED, JobState.FAILED});
    }

    private static boolean taskStateFilter(DataFrameAnalyticsState dataFrameAnalyticsState) {
        return dataFrameAnalyticsState == null || dataFrameAnalyticsState.isNoneOf(new DataFrameAnalyticsState[]{DataFrameAnalyticsState.STOPPED, DataFrameAnalyticsState.FAILED});
    }
}

