/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetaIndex;
import org.elasticsearch.xpack.core.ml.action.PutCalendarAction;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class TransportPutCalendarAction
extends HandledTransportAction<PutCalendarAction.Request, PutCalendarAction.Response> {
    private final Client client;

    @Inject
    public TransportPutCalendarAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/xpack/ml/calendars/put", transportService, actionFilters, PutCalendarAction.Request::new);
        this.client = client;
    }

    protected void doExecute(Task task, PutCalendarAction.Request request, final ActionListener<PutCalendarAction.Response> listener) {
        final Calendar calendar = request.getCalendar();
        IndexRequest indexRequest = new IndexRequest(MlMetaIndex.indexName()).id(calendar.documentId());
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            indexRequest.source(calendar.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("for_internal_storage", "true"))));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialise calendar with id [" + calendar.getId() + "]", e);
        }
        indexRequest.opType(DocWriteRequest.OpType.CREATE);
        indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
                listener.onResponse((Object)new PutCalendarAction.Response(calendar));
            }

            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException) {
                    listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)("Cannot create calendar with id [" + calendar.getId() + "] as it already exists"), (Object[])new Object[0]));
                } else {
                    listener.onFailure((Exception)ExceptionsHelper.serverError((String)("Error putting calendar with id [" + calendar.getId() + "]"), (Throwable)e));
                }
            }
        });
    }
}

