/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.cluster.action.MigrateToDataTiersRequest;
import org.elasticsearch.xpack.cluster.action.MigrateToDataTiersResponse;
import org.elasticsearch.xpack.cluster.metadata.MetadataMigrateToDataTiersRoutingService;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.OperationMode;

public class TransportMigrateToDataTiersAction
extends TransportMasterNodeAction<MigrateToDataTiersRequest, MigrateToDataTiersResponse> {
    private final NamedXContentRegistry xContentRegistry;
    private final Client client;
    private final XPackLicenseState licenseState;

    @Inject
    public TransportMigrateToDataTiersAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry xContentRegistry, Client client, XPackLicenseState licenseState) {
        super("cluster:admin/migrate_to_data_tiers", transportService, clusterService, threadPool, actionFilters, MigrateToDataTiersRequest::new, indexNameExpressionResolver, MigrateToDataTiersResponse::new, "same");
        this.xContentRegistry = xContentRegistry;
        this.client = client;
        this.licenseState = licenseState;
    }

    protected void masterOperation(final MigrateToDataTiersRequest request, final ClusterState state, final ActionListener<MigrateToDataTiersResponse> listener) throws Exception {
        IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)state.metadata().custom("index_lifecycle");
        if (currentMetadata != null && currentMetadata.getOperationMode() != OperationMode.STOPPED) {
            listener.onFailure((Exception)new IllegalStateException("stop ILM before migrating to data tiers, current state is [" + currentMetadata.getOperationMode() + "]"));
            return;
        }
        if (request.isDryRun()) {
            MetadataMigrateToDataTiersRoutingService.MigratedEntities entities = (MetadataMigrateToDataTiersRoutingService.MigratedEntities)MetadataMigrateToDataTiersRoutingService.migrateToDataTiersRouting(state, request.getNodeAttributeName(), request.getLegacyTemplateToDelete(), this.xContentRegistry, this.client, this.licenseState).v2();
            listener.onResponse((Object)new MigrateToDataTiersResponse(entities.removedIndexTemplateName, entities.migratedPolicies, entities.migratedIndices, true));
            return;
        }
        final SetOnce migratedEntities = new SetOnce();
        this.clusterService.submitStateUpdateTask("migrate-to-data-tiers []", (ClusterStateTaskConfig)new ClusterStateUpdateTask(Priority.HIGH){

            public ClusterState execute(ClusterState currentState) throws Exception {
                Tuple<ClusterState, MetadataMigrateToDataTiersRoutingService.MigratedEntities> migratedEntitiesTuple = MetadataMigrateToDataTiersRoutingService.migrateToDataTiersRouting(state, request.getNodeAttributeName(), request.getLegacyTemplateToDelete(), TransportMigrateToDataTiersAction.this.xContentRegistry, TransportMigrateToDataTiersAction.this.client, TransportMigrateToDataTiersAction.this.licenseState);
                migratedEntities.set((Object)((MetadataMigrateToDataTiersRoutingService.MigratedEntities)migratedEntitiesTuple.v2()));
                return (ClusterState)migratedEntitiesTuple.v1();
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                super.clusterStateProcessed(source, oldState, newState);
                MetadataMigrateToDataTiersRoutingService.MigratedEntities entities = (MetadataMigrateToDataTiersRoutingService.MigratedEntities)migratedEntities.get();
                listener.onResponse((Object)new MigrateToDataTiersResponse(entities.removedIndexTemplateName, entities.migratedPolicies, entities.migratedIndices, false));
            }
        });
    }

    protected ClusterBlockException checkBlock(MigrateToDataTiersRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

