/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ccr.CcrAutoFollowInfoFetcher;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.DeprecationChecker;

public class CcrAutoFollowedSystemIndicesChecker
implements DeprecationChecker {
    @Override
    public boolean enabled(Settings settings) {
        return (Boolean)XPackSettings.CCR_ENABLED_SETTING.get(settings);
    }

    @Override
    public void check(DeprecationChecker.Components components, ActionListener<DeprecationChecker.CheckResult> deprecationIssueListener) {
        CcrAutoFollowInfoFetcher.getAutoFollowedSystemIndices((Client)components.client(), (ClusterState)components.clusterState(), (ActionListener)deprecationIssueListener.map(autoFollowedSystemIndices -> {
            List<DeprecationIssue> deprecationIssues = autoFollowedSystemIndices.stream().map(this::createDeprecationIssue).collect(Collectors.toList());
            return new DeprecationChecker.CheckResult(this.getName(), deprecationIssues);
        }));
    }

    private DeprecationIssue createDeprecationIssue(String localIndexName) {
        return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Automatically following system indices is deprecated", "https://ela.st/es-deprecation-7-auto-follow-system-index", "Index [" + localIndexName + "] follows a remote system index. In 8.0.0, follower indices will not be created for remote system indices that match an auto-follow pattern.", false, null);
    }

    @Override
    public String getName() {
        return "ccr_auto_followed_system_indices";
    }
}

