/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.cache.blob;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.search.ClosePointInTimeAction;
import org.elasticsearch.action.search.ClosePointInTimeRequest;
import org.elasticsearch.action.search.ClosePointInTimeResponse;
import org.elasticsearch.action.search.OpenPointInTimeAction;
import org.elasticsearch.action.search.OpenPointInTimeRequest;
import org.elasticsearch.action.search.OpenPointInTimeResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.snapshots.SearchableSnapshotsSettings;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;

public class BlobStoreCacheMaintenanceService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(BlobStoreCacheMaintenanceService.class);
    public static final Setting<TimeValue> SNAPSHOT_SNAPSHOT_CLEANUP_INTERVAL_SETTING = Setting.timeSetting((String)"searchable_snapshots.blob_cache.periodic_cleanup.interval", (TimeValue)TimeValue.timeValueHours((long)1L), (TimeValue)TimeValue.ZERO, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> SNAPSHOT_SNAPSHOT_CLEANUP_KEEP_ALIVE_SETTING = Setting.timeSetting((String)"searchable_snapshots.blob_cache.periodic_cleanup.pit_keep_alive", (TimeValue)TimeValue.timeValueMinutes((long)10L), (TimeValue)TimeValue.timeValueSeconds((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> SNAPSHOT_SNAPSHOT_CLEANUP_BATCH_SIZE_SETTING = Setting.intSetting((String)"searchable_snapshots.blob_cache.periodic_cleanup.batch_size", (int)100, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> SNAPSHOT_SNAPSHOT_CLEANUP_RETENTION_PERIOD = Setting.timeSetting((String)"searchable_snapshots.blob_cache.periodic_cleanup.retention_period", (TimeValue)TimeValue.timeValueHours((long)1L), (TimeValue)TimeValue.ZERO, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final ClusterService clusterService;
    private final Client clientWithOrigin;
    private final String systemIndexName;
    private final ThreadPool threadPool;
    private volatile Scheduler.Cancellable periodicTask;
    private volatile TimeValue periodicTaskInterval;
    private volatile TimeValue periodicTaskKeepAlive;
    private volatile TimeValue periodicTaskRetention;
    private volatile int periodicTaskBatchSize;
    private volatile boolean schedulePeriodic;

    public BlobStoreCacheMaintenanceService(Settings settings, ClusterService clusterService, ThreadPool threadPool, Client client, String systemIndexName) {
        this.clientWithOrigin = new OriginSettingClient(Objects.requireNonNull(client), "searchable_snapshots");
        this.systemIndexName = Objects.requireNonNull(systemIndexName);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.periodicTaskInterval = (TimeValue)SNAPSHOT_SNAPSHOT_CLEANUP_INTERVAL_SETTING.get(settings);
        this.periodicTaskKeepAlive = (TimeValue)SNAPSHOT_SNAPSHOT_CLEANUP_KEEP_ALIVE_SETTING.get(settings);
        this.periodicTaskBatchSize = (Integer)SNAPSHOT_SNAPSHOT_CLEANUP_BATCH_SIZE_SETTING.get(settings);
        this.periodicTaskRetention = (TimeValue)SNAPSHOT_SNAPSHOT_CLEANUP_RETENTION_PERIOD.get(settings);
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(SNAPSHOT_SNAPSHOT_CLEANUP_INTERVAL_SETTING, this::setPeriodicTaskInterval);
        clusterSettings.addSettingsUpdateConsumer(SNAPSHOT_SNAPSHOT_CLEANUP_KEEP_ALIVE_SETTING, this::setPeriodicTaskKeepAlive);
        clusterSettings.addSettingsUpdateConsumer(SNAPSHOT_SNAPSHOT_CLEANUP_BATCH_SIZE_SETTING, this::setPeriodicTaskBatchSize);
        clusterSettings.addSettingsUpdateConsumer(SNAPSHOT_SNAPSHOT_CLEANUP_RETENTION_PERIOD, this::setPeriodicTaskRetention);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.getBlocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        ShardRouting primary = this.systemIndexPrimaryShard(state);
        if (primary == null || !primary.active() || !Objects.equals(state.nodes().getLocalNodeId(), primary.currentNodeId())) {
            this.stopPeriodicTask();
            return;
        }
        if (!event.indicesDeleted().isEmpty()) {
            this.threadPool.generic().execute((Runnable)((Object)new DeletedIndicesMaintenanceTask(event)));
        }
        if (this.periodicTask == null || this.periodicTask.isCancelled()) {
            this.schedulePeriodic = true;
            this.startPeriodicTask();
        }
    }

    private synchronized void setPeriodicTaskInterval(TimeValue interval) {
        this.periodicTaskInterval = interval;
    }

    private void setPeriodicTaskKeepAlive(TimeValue keepAlive) {
        this.periodicTaskKeepAlive = keepAlive;
    }

    public void setPeriodicTaskRetention(TimeValue retention) {
        this.periodicTaskRetention = retention;
    }

    public void setPeriodicTaskBatchSize(int batchSize) {
        this.periodicTaskBatchSize = batchSize;
    }

    private synchronized void startPeriodicTask() {
        if (this.schedulePeriodic) {
            try {
                TimeValue delay = this.periodicTaskInterval;
                if (delay.getMillis() > 0L) {
                    PeriodicMaintenanceTask task = new PeriodicMaintenanceTask(this.periodicTaskKeepAlive, this.periodicTaskBatchSize);
                    this.periodicTask = this.threadPool.schedule((Runnable)task, delay, "generic");
                } else {
                    this.periodicTask = null;
                }
            }
            catch (EsRejectedExecutionException e) {
                if (e.isExecutorShutdown()) {
                    logger.debug("failed to schedule next periodic maintenance task for blob store cache, node is shutting down", (Throwable)e);
                }
                throw e;
            }
        }
    }

    private synchronized void stopPeriodicTask() {
        this.schedulePeriodic = false;
        if (this.periodicTask != null && !this.periodicTask.isCancelled()) {
            this.periodicTask.cancel();
            this.periodicTask = null;
        }
    }

    @Nullable
    private ShardRouting systemIndexPrimaryShard(ClusterState state) {
        IndexRoutingTable indexRoutingTable;
        IndexMetadata indexMetadata = state.metadata().index(this.systemIndexName);
        if (indexMetadata != null && (indexRoutingTable = state.routingTable().index(indexMetadata.getIndex())) != null) {
            return indexRoutingTable.shard(0).primaryShard();
        }
        return null;
    }

    private static boolean hasSearchableSnapshotWith(ClusterState state, String snapshotId, String indexId) {
        for (IndexMetadata indexMetadata : state.metadata()) {
            Settings indexSettings = indexMetadata.getSettings();
            if (!SearchableSnapshotsSettings.isSearchableSnapshotStore((Settings)indexSettings) || !Objects.equals(snapshotId, SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSettings)) || !Objects.equals(indexId, SearchableSnapshots.SNAPSHOT_INDEX_ID_SETTING.get(indexSettings))) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Set<String>> listSearchableSnapshots(ClusterState state) {
        HashMap<String, Set> snapshots = null;
        for (IndexMetadata indexMetadata : state.metadata()) {
            Settings indexSettings = indexMetadata.getSettings();
            if (!SearchableSnapshotsSettings.isSearchableSnapshotStore((Settings)indexSettings)) continue;
            if (snapshots == null) {
                snapshots = new HashMap<String, Set>();
            }
            snapshots.computeIfAbsent((String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSettings), s -> new HashSet()).add((String)SearchableSnapshots.SNAPSHOT_INDEX_ID_SETTING.get(indexSettings));
        }
        return snapshots != null ? Collections.unmodifiableMap(snapshots) : Collections.emptyMap();
    }

    static QueryBuilder buildDeleteByQuery(int numberOfShards, String snapshotUuid, String indexUuid) {
        Set paths = IntStream.range(0, numberOfShards).mapToObj(shard -> String.join((CharSequence)"/", snapshotUuid, indexUuid, String.valueOf(shard))).collect(Collectors.toSet());
        assert (!paths.isEmpty());
        return QueryBuilders.termsQuery((String)"blob.path", paths);
    }

    private void executeNext(PeriodicMaintenanceTask maintenanceTask) {
        this.threadPool.generic().execute(maintenanceTask);
    }

    private static boolean assertGenericThread() {
        String threadName = Thread.currentThread().getName();
        assert (threadName.contains("generic")) : threadName;
        return true;
    }

    private static Instant getCreationTime(SearchHit searchHit) {
        DocumentField creationTimeField = searchHit.field("creation_time");
        assert (creationTimeField != null);
        Object creationTimeValue = creationTimeField.getValue();
        assert (creationTimeValue != null);
        assert (creationTimeValue instanceof String) : "expect a java.lang.String but got " + creationTimeValue.getClass();
        return Instant.ofEpochMilli(Long.parseLong((String)creationTimeField.getValue()));
    }

    private class PeriodicMaintenanceTask
    implements Runnable,
    Releasable {
        private final TimeValue keepAlive;
        private final int batchSize;
        private final AtomicReference<Exception> error = new AtomicReference();
        private final AtomicBoolean closed = new AtomicBoolean();
        private final AtomicLong deletes = new AtomicLong();
        private final AtomicLong total = new AtomicLong();
        private volatile Map<String, Set<String>> existingSnapshots;
        private volatile Set<String> existingRepositories;
        private volatile SearchResponse searchResponse;
        private volatile Instant expirationTime;
        private volatile String pointIntTimeId;
        private volatile Object[] searchAfter;

        PeriodicMaintenanceTask(TimeValue keepAlive, int batchSize) {
            this.keepAlive = keepAlive;
            this.batchSize = batchSize;
        }

        @Override
        public void run() {
            assert (BlobStoreCacheMaintenanceService.assertGenericThread());
            try {
                this.ensureOpen();
                if (this.pointIntTimeId == null) {
                    OpenPointInTimeRequest openRequest = new OpenPointInTimeRequest(new String[]{".snapshot-blob-cache"});
                    openRequest.keepAlive(this.keepAlive);
                    BlobStoreCacheMaintenanceService.this.clientWithOrigin.execute((ActionType)OpenPointInTimeAction.INSTANCE, (ActionRequest)openRequest, (ActionListener)new ActionListener<OpenPointInTimeResponse>(){

                        public void onResponse(OpenPointInTimeResponse response) {
                            logger.trace("periodic maintenance task initialized with point-in-time id [{}]", (Object)response.getPointInTimeId());
                            PeriodicMaintenanceTask.this.pointIntTimeId = response.getPointInTimeId();
                            BlobStoreCacheMaintenanceService.this.executeNext(PeriodicMaintenanceTask.this);
                        }

                        public void onFailure(Exception e) {
                            if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                                PeriodicMaintenanceTask.this.complete(null);
                            } else {
                                PeriodicMaintenanceTask.this.complete(e);
                            }
                        }
                    });
                    return;
                }
                String pitId = this.pointIntTimeId;
                assert (Strings.hasLength((String)pitId));
                if (this.searchResponse == null) {
                    SearchSourceBuilder searchSource = new SearchSourceBuilder();
                    searchSource.fetchField(new FieldAndFormat("creation_time", "epoch_millis"));
                    searchSource.fetchSource(false);
                    searchSource.trackScores(false);
                    searchSource.sort("_shard_doc");
                    searchSource.size(this.batchSize);
                    if (this.searchAfter != null) {
                        searchSource.searchAfter(this.searchAfter);
                        searchSource.trackTotalHits(false);
                    } else {
                        searchSource.trackTotalHits(true);
                    }
                    PointInTimeBuilder pointInTime = new PointInTimeBuilder(pitId);
                    pointInTime.setKeepAlive(this.keepAlive);
                    searchSource.pointInTimeBuilder(pointInTime);
                    SearchRequest searchRequest = new SearchRequest();
                    searchRequest.source(searchSource);
                    BlobStoreCacheMaintenanceService.this.clientWithOrigin.execute((ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                        public void onResponse(SearchResponse response) {
                            if (PeriodicMaintenanceTask.this.searchAfter == null) {
                                assert (PeriodicMaintenanceTask.this.total.get() == 0L);
                                PeriodicMaintenanceTask.this.total.set(response.getHits().getTotalHits().value);
                            }
                            PeriodicMaintenanceTask.this.searchResponse = response;
                            PeriodicMaintenanceTask.access$902(PeriodicMaintenanceTask.this, null);
                            BlobStoreCacheMaintenanceService.this.executeNext(PeriodicMaintenanceTask.this);
                        }

                        public void onFailure(Exception e) {
                            PeriodicMaintenanceTask.this.complete(e);
                        }
                    });
                    return;
                }
                SearchHit[] searchHits = this.searchResponse.getHits().getHits();
                if (searchHits != null && searchHits.length > 0) {
                    if (this.expirationTime == null) {
                        TimeValue retention = BlobStoreCacheMaintenanceService.this.periodicTaskRetention;
                        this.expirationTime = Instant.ofEpochMilli(BlobStoreCacheMaintenanceService.this.threadPool.absoluteTimeInMillis()).minus(retention.millis(), ChronoUnit.MILLIS);
                        ClusterState state = BlobStoreCacheMaintenanceService.this.clusterService.state();
                        this.existingSnapshots = BlobStoreCacheMaintenanceService.listSearchableSnapshots(state);
                        this.existingRepositories = ((RepositoriesMetadata)state.metadata().custom("repositories", (Metadata.Custom)RepositoriesMetadata.EMPTY)).repositories().stream().map(RepositoryMetadata::name).collect(Collectors.toSet());
                    }
                    BulkRequest bulkRequest = new BulkRequest();
                    Map<String, Set<String>> knownSnapshots = this.existingSnapshots;
                    assert (knownSnapshots != null);
                    Set<String> knownRepositories = this.existingRepositories;
                    assert (knownRepositories != null);
                    Instant expirationTime = this.expirationTime;
                    assert (expirationTime != null);
                    Object[] lastSortValues = null;
                    for (SearchHit searchHit : searchHits) {
                        lastSortValues = searchHit.getSortValues();
                        assert (searchHit.getId() != null);
                        try {
                            boolean delete = false;
                            Object[] parts = Objects.requireNonNull(searchHit.getId()).split("/");
                            assert (parts.length == 6) : Arrays.toString(parts) + " vs " + searchHit.getId();
                            String repositoryName = parts[0];
                            if (!knownRepositories.contains(repositoryName)) {
                                logger.trace("deleting blob store cache entry with id [{}]: repository does not exist", (Object)searchHit.getId());
                                delete = true;
                            } else {
                                Set<String> knownIndexIds = knownSnapshots.get(parts[1]);
                                if (knownIndexIds == null || !knownIndexIds.contains(parts[2])) {
                                    logger.trace("deleting blob store cache entry with id [{}]: not used", (Object)searchHit.getId());
                                    delete = true;
                                }
                            }
                            if (!delete) continue;
                            Instant creationTime = BlobStoreCacheMaintenanceService.getCreationTime(searchHit);
                            if (creationTime.isAfter(expirationTime)) {
                                logger.trace("blob store cache entry with id [{}] was created recently, skipping deletion", (Object)searchHit.getId());
                                continue;
                            }
                            bulkRequest.add(((DeleteRequest)new DeleteRequest().index(searchHit.getIndex())).id(searchHit.getId()));
                        }
                        catch (Exception e) {
                            logger.warn(() -> new ParameterizedMessage("exception when parsing blob store cache entry with id [{}], skipping", (Object)searchHit.getId()), (Throwable)e);
                        }
                    }
                    assert (lastSortValues != null);
                    if (bulkRequest.numberOfActions() == 0) {
                        this.searchResponse = null;
                        this.searchAfter = lastSortValues;
                        BlobStoreCacheMaintenanceService.this.executeNext(this);
                        return;
                    }
                    final Object[] finalSearchAfter = lastSortValues;
                    BlobStoreCacheMaintenanceService.this.clientWithOrigin.execute((ActionType)BulkAction.INSTANCE, (ActionRequest)bulkRequest, (ActionListener)new ActionListener<BulkResponse>(){

                        public void onResponse(BulkResponse response) {
                            for (BulkItemResponse itemResponse : response.getItems()) {
                                if (itemResponse.isFailed()) continue;
                                assert (itemResponse.getResponse() instanceof DeleteResponse);
                                PeriodicMaintenanceTask.this.deletes.incrementAndGet();
                            }
                            PeriodicMaintenanceTask.this.searchResponse = null;
                            PeriodicMaintenanceTask.access$902(PeriodicMaintenanceTask.this, finalSearchAfter);
                            BlobStoreCacheMaintenanceService.this.executeNext(PeriodicMaintenanceTask.this);
                        }

                        public void onFailure(Exception e) {
                            PeriodicMaintenanceTask.this.complete(e);
                        }
                    });
                    return;
                }
                this.complete(null);
            }
            catch (Exception e) {
                this.complete(e);
            }
        }

        public boolean isClosed() {
            return this.closed.get();
        }

        private void ensureOpen() {
            if (this.isClosed()) {
                assert (false) : "should not use periodic task after close";
                throw new IllegalStateException("Periodic maintenance task is closed");
            }
        }

        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                Exception e = this.error.get();
                if (e != null) {
                    logger.warn(() -> new ParameterizedMessage("periodic maintenance task completed with failure ({} deleted documents out of a total of {})", (Object)this.deletes.get(), (Object)this.total.get()), (Throwable)e);
                } else {
                    logger.info(() -> new ParameterizedMessage("periodic maintenance task completed ({} deleted documents out of a total of {})", (Object)this.deletes.get(), (Object)this.total.get()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete(@Nullable Exception failure) {
            assert (!this.isClosed());
            Releasable releasable = () -> {
                try {
                    Exception previous = this.error.getAndSet(failure);
                    assert (previous == null) : "periodic maintenance task already failed: " + previous;
                    this.close();
                }
                finally {
                    BlobStoreCacheMaintenanceService.this.startPeriodicTask();
                }
            };
            boolean waitForRelease = false;
            try {
                final String pitId = this.pointIntTimeId;
                if (Strings.hasLength((String)pitId)) {
                    ClosePointInTimeRequest closeRequest = new ClosePointInTimeRequest(pitId);
                    BlobStoreCacheMaintenanceService.this.clientWithOrigin.execute((ActionType)ClosePointInTimeAction.INSTANCE, (ActionRequest)closeRequest, ActionListener.runAfter((ActionListener)new ActionListener<ClosePointInTimeResponse>(){

                        public void onResponse(ClosePointInTimeResponse response) {
                            if (response.isSucceeded()) {
                                logger.debug("periodic maintenance task successfully closed point-in-time id [{}]", (Object)pitId);
                            } else {
                                logger.debug("point-in-time id [{}] not found", (Object)pitId);
                            }
                        }

                        public void onFailure(Exception e) {
                            logger.warn(() -> new ParameterizedMessage("failed to close point-in-time id [{}]", (Object)pitId), (Throwable)e);
                        }
                    }, () -> Releasables.close((Releasable)releasable)));
                    waitForRelease = true;
                }
            }
            finally {
                if (!waitForRelease) {
                    Releasables.close((Releasable)releasable);
                }
            }
        }

        static /* synthetic */ Object[] access$902(PeriodicMaintenanceTask x0, Object[] x1) {
            x0.searchAfter = x1;
            return x1;
        }
    }

    private class DeletedIndicesMaintenanceTask
    extends AbstractRunnable {
        private final ClusterChangedEvent event;

        DeletedIndicesMaintenanceTask(ClusterChangedEvent event) {
            assert (!event.indicesDeleted().isEmpty());
            this.event = Objects.requireNonNull(event);
        }

        protected void doRun() {
            LinkedList<Tuple<DeleteByQueryRequest, ActionListener<BulkByScrollResponse>>> queue = new LinkedList<Tuple<DeleteByQueryRequest, ActionListener<BulkByScrollResponse>>>();
            ClusterState state = this.event.state();
            for (final Index deletedIndex : this.event.indicesDeleted()) {
                String indexId;
                Settings indexSetting;
                IndexMetadata indexMetadata = this.event.previousState().metadata().index(deletedIndex);
                assert (indexMetadata != null || state.metadata().indexGraveyard().containsIndex(deletedIndex)) : "no previous metadata found for " + deletedIndex;
                if (indexMetadata == null || !SearchableSnapshotsSettings.isSearchableSnapshotStore((Settings)(indexSetting = indexMetadata.getSettings()))) continue;
                assert (!state.metadata().hasIndex(deletedIndex));
                final String snapshotId = (String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSetting);
                if (BlobStoreCacheMaintenanceService.hasSearchableSnapshotWith(state, snapshotId, indexId = (String)SearchableSnapshots.SNAPSHOT_INDEX_ID_SETTING.get(indexSetting))) {
                    logger.debug("snapshot [{}] of index {} is in use, skipping maintenance of snapshot blob cache entries", (Object)snapshotId, (Object)indexId);
                    continue;
                }
                DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{BlobStoreCacheMaintenanceService.this.systemIndexName});
                request.setQuery(BlobStoreCacheMaintenanceService.buildDeleteByQuery(indexMetadata.getNumberOfShards(), snapshotId, indexId));
                request.setRefresh(queue.isEmpty());
                queue.add((Tuple<DeleteByQueryRequest, ActionListener<BulkByScrollResponse>>)Tuple.tuple((Object)request, (Object)new ActionListener<BulkByScrollResponse>(){

                    public void onResponse(BulkByScrollResponse response) {
                        logger.debug("blob cache maintenance task deleted [{}] entries after deletion of {} (snapshot:{}, index:{})", (Object)response.getDeleted(), (Object)deletedIndex, (Object)snapshotId, (Object)indexId);
                    }

                    public void onFailure(Exception e) {
                        logger.debug(() -> new ParameterizedMessage("exception when executing blob cache maintenance task after deletion of {} (snapshot:{}, index:{})", new Object[]{deletedIndex, snapshotId, indexId}), (Throwable)e);
                    }
                }));
            }
            if (!queue.isEmpty()) {
                this.executeNextCleanUp(queue);
            }
        }

        void executeNextCleanUp(Queue<Tuple<DeleteByQueryRequest, ActionListener<BulkByScrollResponse>>> queue) {
            assert (Thread.currentThread().getName().contains("generic"));
            Tuple<DeleteByQueryRequest, ActionListener<BulkByScrollResponse>> next = queue.poll();
            if (next != null) {
                this.cleanUp((DeleteByQueryRequest)next.v1(), (ActionListener<BulkByScrollResponse>)((ActionListener)next.v2()), queue);
            }
        }

        void cleanUp(DeleteByQueryRequest request, ActionListener<BulkByScrollResponse> listener, Queue<Tuple<DeleteByQueryRequest, ActionListener<BulkByScrollResponse>>> queue) {
            assert (Thread.currentThread().getName().contains("generic"));
            BlobStoreCacheMaintenanceService.this.clientWithOrigin.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, ActionListener.runAfter(listener, () -> {
                if (!queue.isEmpty()) {
                    BlobStoreCacheMaintenanceService.this.threadPool.generic().execute(() -> this.executeNextCleanUp(queue));
                }
            }));
        }

        public void onFailure(Exception e) {
            logger.warn(() -> new ParameterizedMessage("snapshot blob cache maintenance task failed for cluster state update [{}]", (Object)this.event.source()), (Throwable)e);
        }
    }
}

