/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.structurefinder;

import java.util.List;
import java.util.regex.Pattern;
import org.elasticsearch.xpack.core.textstructure.structurefinder.TextStructure;
import org.elasticsearch.xpack.textstructure.structurefinder.LogTextStructureFinder;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinder;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinderFactory;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureOverrides;
import org.elasticsearch.xpack.textstructure.structurefinder.TimeoutChecker;

public class LogTextStructureFinderFactory
implements TextStructureFinderFactory {
    private static final Pattern TWO_NON_BLANK_LINES_PATTERN = Pattern.compile(".\n+.");

    @Override
    public boolean canFindFormat(TextStructure.Format format) {
        return format == null || format == TextStructure.Format.SEMI_STRUCTURED_TEXT;
    }

    @Override
    public boolean canCreateFromSample(List<String> explanation, String sample, double allowedFractionOfBadLines) {
        if (sample.indexOf(10) < 0) {
            explanation.add("Not text because sample contains no newlines");
            return false;
        }
        if (!TWO_NON_BLANK_LINES_PATTERN.matcher(sample).find()) {
            explanation.add("Not text because sample contains fewer than two non-blank lines");
            return false;
        }
        explanation.add("Deciding sample is text");
        return true;
    }

    @Override
    public TextStructureFinder createFromSample(List<String> explanation, String sample, String charsetName, Boolean hasByteOrderMarker, int lineMergeSizeLimit, TextStructureOverrides overrides, TimeoutChecker timeoutChecker) {
        return LogTextStructureFinder.makeLogTextStructureFinder(explanation, sample, charsetName, hasByteOrderMarker, lineMergeSizeLimit, overrides, timeoutChecker);
    }
}

