/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.decision;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xpack.autoscaling.Autoscaling;
import org.elasticsearch.xpack.autoscaling.AutoscalingMetadata;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingCapacity;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDeciderConfiguration;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDeciderContext;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDeciderService;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDecision;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingDecisions;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicy;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicyMetadata;

public class AutoscalingDecisionService {
    private Map<String, AutoscalingDeciderService<? extends AutoscalingDeciderConfiguration>> deciderByName;

    public AutoscalingDecisionService(Set<AutoscalingDeciderService<? extends AutoscalingDeciderConfiguration>> deciders) {
        assert (deciders.size() >= 1);
        this.deciderByName = deciders.stream().collect(Collectors.toMap(AutoscalingDeciderService::name, Function.identity()));
    }

    public SortedMap<String, AutoscalingDecisions> decide(ClusterState state, ClusterInfo clusterInfo) {
        AutoscalingMetadata autoscalingMetadata = (AutoscalingMetadata)state.metadata().custom("autoscaling");
        if (autoscalingMetadata != null) {
            return new TreeMap<String, AutoscalingDecisions>(autoscalingMetadata.policies().entrySet().stream().map(e -> Tuple.tuple((Object)((String)e.getKey()), (Object)this.getDecision(((AutoscalingPolicyMetadata)((Object)((Object)e.getValue()))).policy(), state, clusterInfo))).collect(Collectors.toMap(Tuple::v1, Tuple::v2)));
        }
        return new TreeMap<String, AutoscalingDecisions>();
    }

    private AutoscalingDecisions getDecision(AutoscalingPolicy policy, ClusterState state, ClusterInfo clusterInfo) {
        DecisionAutoscalingDeciderContext context = new DecisionAutoscalingDeciderContext(policy.name(), state, clusterInfo);
        SortedMap decisions = policy.deciders().entrySet().stream().map(entry -> Tuple.tuple((Object)((String)entry.getKey()), (Object)this.getDecision((AutoscalingDeciderConfiguration)entry.getValue(), context))).collect(Collectors.toMap(Tuple::v1, Tuple::v2, (a, b) -> {
            throw new UnsupportedOperationException();
        }, TreeMap::new));
        return new AutoscalingDecisions(context.tier, context.currentCapacity, decisions);
    }

    private <T extends AutoscalingDeciderConfiguration> AutoscalingDecision getDecision(T decider, AutoscalingDeciderContext context) {
        assert (this.deciderByName.containsKey(decider.name()));
        AutoscalingDeciderService<? extends AutoscalingDeciderConfiguration> service = this.deciderByName.get(decider.name());
        return service.scale(decider, context);
    }

    static class DecisionAutoscalingDeciderContext
    implements AutoscalingDeciderContext {
        private final String tier;
        private final ClusterState state;
        private final ClusterInfo clusterInfo;
        private final AutoscalingCapacity currentCapacity;
        private final boolean currentCapacityAccurate;

        DecisionAutoscalingDeciderContext(String tier, ClusterState state, ClusterInfo clusterInfo) {
            this.tier = tier;
            Objects.requireNonNull(state);
            Objects.requireNonNull(clusterInfo);
            this.state = state;
            this.clusterInfo = clusterInfo;
            this.currentCapacity = this.calculateCurrentCapacity();
            this.currentCapacityAccurate = this.calculateCurrentCapacityAccurate();
        }

        @Override
        public ClusterState state() {
            return this.state;
        }

        @Override
        public AutoscalingCapacity currentCapacity() {
            if (this.currentCapacityAccurate) {
                return this.currentCapacity;
            }
            return null;
        }

        private boolean calculateCurrentCapacityAccurate() {
            return StreamSupport.stream(this.state.nodes().spliterator(), false).filter(this::informalTierFilter).allMatch(this::nodeHasAccurateCapacity);
        }

        private boolean nodeHasAccurateCapacity(DiscoveryNode node) {
            return this.totalStorage((ImmutableOpenMap<String, DiskUsage>)this.clusterInfo.getNodeLeastAvailableDiskUsages(), node) >= 0L && this.totalStorage((ImmutableOpenMap<String, DiskUsage>)this.clusterInfo.getNodeMostAvailableDiskUsages(), node) >= 0L;
        }

        private AutoscalingCapacity calculateCurrentCapacity() {
            return StreamSupport.stream(this.state.nodes().spliterator(), false).filter(this::informalTierFilter).map(this::resourcesFor).map(c -> new AutoscalingCapacity((AutoscalingCapacity.AutoscalingResources)c, (AutoscalingCapacity.AutoscalingResources)c)).reduce((c1, c2) -> new AutoscalingCapacity(AutoscalingCapacity.AutoscalingResources.sum(c1.tier(), c2.tier()), AutoscalingCapacity.AutoscalingResources.max(c1.node(), c2.node()))).orElse(AutoscalingCapacity.ZERO);
        }

        private AutoscalingCapacity.AutoscalingResources resourcesFor(DiscoveryNode node) {
            long storage = Math.max(this.totalStorage((ImmutableOpenMap<String, DiskUsage>)this.clusterInfo.getNodeLeastAvailableDiskUsages(), node), this.totalStorage((ImmutableOpenMap<String, DiskUsage>)this.clusterInfo.getNodeMostAvailableDiskUsages(), node));
            return new AutoscalingCapacity.AutoscalingResources(storage == -1L ? ByteSizeValue.ZERO : new ByteSizeValue(storage), ByteSizeValue.ZERO);
        }

        private long totalStorage(ImmutableOpenMap<String, DiskUsage> diskUsages, DiscoveryNode node) {
            DiskUsage diskUsage = (DiskUsage)diskUsages.get((Object)node.getId());
            return diskUsage != null ? diskUsage.getTotalBytes() : -1L;
        }

        private boolean informalTierFilter(DiscoveryNode discoveryNode) {
            return discoveryNode.getRoles().stream().map(DiscoveryNodeRole::roleName).anyMatch(this.tier::equals) || this.tier.equals(discoveryNode.getAttributes().get("data"));
        }
    }

    public static class Holder {
        private final Autoscaling autoscaling;
        private final SetOnce<AutoscalingDecisionService> servicesSetOnce = new SetOnce();

        public Holder(Autoscaling autoscaling) {
            this.autoscaling = autoscaling;
        }

        public AutoscalingDecisionService get() {
            AutoscalingDecisionService autoscalingDecisionService = (AutoscalingDecisionService)this.servicesSetOnce.get();
            if (autoscalingDecisionService == null) {
                autoscalingDecisionService = new AutoscalingDecisionService(this.autoscaling.createDeciderServices());
                this.servicesSetOnce.set((Object)autoscalingDecisionService);
            }
            return autoscalingDecisionService;
        }
    }
}

