/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.decision;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.decision.AutoscalingCapacity;

public class AutoscalingDecision
implements ToXContent,
Writeable {
    private final AutoscalingCapacity requiredCapacity;
    private final Reason reason;

    public AutoscalingDecision(AutoscalingCapacity requiredCapacity, Reason reason) {
        this.requiredCapacity = requiredCapacity;
        this.reason = reason;
    }

    public AutoscalingDecision(StreamInput in) throws IOException {
        this.requiredCapacity = (AutoscalingCapacity)in.readOptionalWriteable(AutoscalingCapacity::new);
        this.reason = (Reason)in.readOptionalNamedWriteable(Reason.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.requiredCapacity);
        out.writeOptionalNamedWriteable((NamedWriteable)this.reason);
    }

    public AutoscalingCapacity requiredCapacity() {
        return this.requiredCapacity;
    }

    public Reason reason() {
        return this.reason;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.requiredCapacity != null) {
            builder.field("required_capacity", (ToXContent)this.requiredCapacity);
        }
        if (this.reason != null) {
            builder.field("reason_summary", this.reason.summary());
            builder.field("reason_details", (ToXContent)this.reason);
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoscalingDecision that = (AutoscalingDecision)o;
        return Objects.equals(this.requiredCapacity, that.requiredCapacity) && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(this.requiredCapacity, this.reason);
    }

    public static interface Reason
    extends ToXContent,
    NamedWriteable {
        public String summary();
    }
}

