/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.decision;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class AutoscalingCapacity
implements ToXContent,
Writeable {
    private final AutoscalingResources tier;
    private final AutoscalingResources node;
    public static final AutoscalingCapacity ZERO = new AutoscalingCapacity(AutoscalingResources.ZERO, AutoscalingResources.ZERO);

    public AutoscalingCapacity(AutoscalingResources tier, AutoscalingResources node) {
        assert (tier != null) : "Cannot provide capacity without specifying tier level capacity";
        assert (node == null || node.memory == null || tier.memory != null) : "Cannot provide node memory without tier memory";
        assert (node == null || node.storage == null || tier.storage != null) : "Cannot provide node storage without tier memory";
        this.tier = tier;
        this.node = node;
    }

    public AutoscalingCapacity(StreamInput in) throws IOException {
        this.tier = new AutoscalingResources(in);
        this.node = (AutoscalingResources)in.readOptionalWriteable(AutoscalingResources::new);
    }

    public AutoscalingResources tier() {
        return this.tier;
    }

    public AutoscalingResources node() {
        return this.node;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.tier.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.node);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.node != null) {
            builder.field("node", (ToXContent)this.node);
        }
        builder.field("tier", (ToXContent)this.tier);
        builder.endObject();
        return builder;
    }

    public boolean isFragment() {
        return false;
    }

    public static AutoscalingCapacity upperBound(AutoscalingCapacity c1, AutoscalingCapacity c2) {
        return new AutoscalingCapacity(AutoscalingResources.max(c1.tier, c2.tier), AutoscalingResources.max(c1.node, c2.node));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoscalingCapacity capacity = (AutoscalingCapacity)o;
        return this.tier.equals(capacity.tier) && Objects.equals(this.node, capacity.node);
    }

    public int hashCode() {
        return Objects.hash(this.tier, this.node);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class AutoscalingResources
    implements ToXContent,
    Writeable {
        private final ByteSizeValue storage;
        private final ByteSizeValue memory;
        public static final AutoscalingResources ZERO = new AutoscalingResources(new ByteSizeValue(0L), new ByteSizeValue(0L));

        public AutoscalingResources(ByteSizeValue storage, ByteSizeValue memory) {
            assert (storage != null || memory != null);
            this.storage = storage;
            this.memory = memory;
        }

        public AutoscalingResources(StreamInput in) throws IOException {
            this.storage = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.memory = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
        }

        public ByteSizeValue storage() {
            return this.storage;
        }

        public ByteSizeValue memory() {
            return this.memory;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.storage != null) {
                builder.field("storage", this.storage.getStringRep());
            }
            if (this.memory != null) {
                builder.field("memory", this.memory.getStringRep());
            }
            builder.endObject();
            return builder;
        }

        public boolean isFragment() {
            return false;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalWriteable((Writeable)this.storage);
            out.writeOptionalWriteable((Writeable)this.memory);
        }

        public static AutoscalingResources max(AutoscalingResources sm1, AutoscalingResources sm2) {
            if (sm1 == null) {
                return sm2;
            }
            if (sm2 == null) {
                return sm1;
            }
            return new AutoscalingResources(AutoscalingResources.max(sm1.storage, sm2.storage), AutoscalingResources.max(sm1.memory, sm2.memory));
        }

        public static AutoscalingResources sum(AutoscalingResources sm1, AutoscalingResources sm2) {
            if (sm1 == null) {
                return sm2;
            }
            if (sm2 == null) {
                return sm1;
            }
            return new AutoscalingResources(AutoscalingResources.add(sm1.storage, sm2.storage), AutoscalingResources.add(sm1.memory, sm2.memory));
        }

        private static ByteSizeValue max(ByteSizeValue v1, ByteSizeValue v2) {
            if (v1 == null) {
                return v2;
            }
            if (v2 == null) {
                return v1;
            }
            return v1.compareTo(v2) < 0 ? v2 : v1;
        }

        private static ByteSizeValue add(ByteSizeValue v1, ByteSizeValue v2) {
            if (v1 == null) {
                return v2;
            }
            if (v2 == null) {
                return v1;
            }
            return new ByteSizeValue(v1.getBytes() + v2.getBytes());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AutoscalingResources that = (AutoscalingResources)o;
            return Objects.equals(this.storage, that.storage) && Objects.equals(this.memory, that.memory);
        }

        public int hashCode() {
            return Objects.hash(this.storage, this.memory);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public static class Builder {
        private AutoscalingResources tier;
        private AutoscalingResources node;

        public Builder capacity(AutoscalingCapacity capacity) {
            this.tier = capacity.tier;
            this.node = capacity.node;
            return this;
        }

        public Builder tier(Long storage, Long memory) {
            return this.tier(this.byteSizeValue(storage), this.byteSizeValue(memory));
        }

        public Builder tier(ByteSizeValue storage, ByteSizeValue memory) {
            return this.tier(new AutoscalingResources(storage, memory));
        }

        public Builder tier(AutoscalingResources tier) {
            this.tier = tier;
            return this;
        }

        public Builder node(Long storage, Long memory) {
            return this.node(this.byteSizeValue(storage), this.byteSizeValue(memory));
        }

        public Builder node(ByteSizeValue storage, ByteSizeValue memory) {
            return this.node(new AutoscalingResources(storage, memory));
        }

        public Builder node(AutoscalingResources node) {
            this.node = node;
            return this;
        }

        public AutoscalingCapacity build() {
            return new AutoscalingCapacity(this.tier, this.node);
        }

        private ByteSizeValue byteSizeValue(Long memory) {
            return memory == null ? null : new ByteSizeValue(memory.longValue());
        }
    }
}

