/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.action;

import java.io.IOException;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.autoscaling.AutoscalingMetadata;
import org.elasticsearch.xpack.autoscaling.action.PutAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicy;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicyMetadata;

public class TransportPutAutoscalingPolicyAction
extends TransportMasterNodeAction<PutAutoscalingPolicyAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportPutAutoscalingPolicyAction.class);

    @Inject
    public TransportPutAutoscalingPolicyAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/autoscaling/put_autoscaling_policy", transportService, clusterService, threadPool, actionFilters, PutAutoscalingPolicyAction.Request::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void masterOperation(final PutAutoscalingPolicyAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("put-autoscaling-policy", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)request, listener){

            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }

            public ClusterState execute(ClusterState currentState) {
                return TransportPutAutoscalingPolicyAction.putAutoscalingPolicy(currentState, request.policy(), logger);
            }
        });
    }

    protected ClusterBlockException checkBlock(PutAutoscalingPolicyAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    static ClusterState putAutoscalingPolicy(ClusterState currentState, AutoscalingPolicy policy, Logger logger) {
        ClusterState.Builder builder = ClusterState.builder((ClusterState)currentState);
        AutoscalingMetadata currentMetadata = currentState.metadata().custom("autoscaling") != null ? (AutoscalingMetadata)currentState.metadata().custom("autoscaling") : AutoscalingMetadata.EMPTY;
        TreeMap<String, AutoscalingPolicyMetadata> newPolicies = new TreeMap<String, AutoscalingPolicyMetadata>(currentMetadata.policies());
        AutoscalingPolicyMetadata newPolicyMetadata = new AutoscalingPolicyMetadata(policy);
        AutoscalingPolicyMetadata oldPolicyMetadata = newPolicies.put(policy.name(), newPolicyMetadata);
        if (oldPolicyMetadata == null) {
            logger.info("adding autoscaling policy [{}]", (Object)policy.name());
        } else {
            if (oldPolicyMetadata.equals((Object)newPolicyMetadata)) {
                logger.info("skipping updating autoscaling policy [{}] due to no change in policy", (Object)policy.name());
                return currentState;
            }
            logger.info("updating autoscaling policy [{}]", (Object)policy.name());
        }
        AutoscalingMetadata newMetadata = new AutoscalingMetadata(newPolicies);
        builder.metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom("autoscaling", (Metadata.Custom)newMetadata).build());
        return builder.build();
    }
}

