/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.time.Duration;
import org.apache.lucene.util.Constants;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.env.Environment;

public class NamedPipeHelper {
    private static final long PAUSE_TIME_MS = 20L;
    private static final String WIN_PIPE_PREFIX = "\\\\.\\pipe\\";

    public String getDefaultPipeDirectoryPrefix(Environment env) {
        if (Constants.WINDOWS) {
            return WIN_PIPE_PREFIX;
        }
        return env.tmpFile().toString() + PathUtils.getDefaultFileSystem().getSeparator();
    }

    @SuppressForbidden(reason="Environment doesn't have path for Windows named pipes")
    public InputStream openNamedPipeInputStream(String path, Duration timeout) throws IOException {
        return this.openNamedPipeInputStream(PathUtils.get((String)path, (String[])new String[0]), timeout);
    }

    public InputStream openNamedPipeInputStream(Path file, Duration timeout) throws IOException {
        long timeoutMillisRemaining = timeout.toMillis();
        if (Constants.WINDOWS && !file.toString().startsWith(WIN_PIPE_PREFIX)) {
            throw new IOException(file + " is not a named pipe");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        while (true) {
            if (!Constants.WINDOWS && Files.isRegularFile(file, new LinkOption[0])) {
                throw new IOException(file + " is not a named pipe");
            }
            try {
                PrivilegedInputPipeOpener privilegedInputPipeOpener = new PrivilegedInputPipeOpener(file);
                return AccessController.doPrivileged(privilegedInputPipeOpener);
            }
            catch (RuntimeException e) {
                if (timeoutMillisRemaining <= 0L) {
                    this.propagatePrivilegedException(e);
                }
                long thisSleep = Math.min(timeoutMillisRemaining, 20L);
                timeoutMillisRemaining -= thisSleep;
                try {
                    Thread.sleep(thisSleep);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    this.propagatePrivilegedException(e);
                    continue;
                }
            }
            break;
        }
    }

    @SuppressForbidden(reason="Environment doesn't have path for Windows named pipes")
    public OutputStream openNamedPipeOutputStream(String path, Duration timeout) throws IOException {
        return this.openNamedPipeOutputStream(PathUtils.get((String)path, (String[])new String[0]), timeout);
    }

    public OutputStream openNamedPipeOutputStream(Path file, Duration timeout) throws IOException {
        if (Constants.WINDOWS) {
            return this.openNamedPipeOutputStreamWindows(file, timeout);
        }
        return this.openNamedPipeOutputStreamUnix(file, timeout);
    }

    private OutputStream openNamedPipeOutputStreamWindows(Path file, Duration timeout) throws IOException {
        long timeoutMillisRemaining = timeout.toMillis();
        if (!file.toString().startsWith(WIN_PIPE_PREFIX)) {
            throw new IOException(file + " is not a named pipe");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        while (true) {
            try {
                PrivilegedOutputPipeOpener privilegedOutputPipeOpener = new PrivilegedOutputPipeOpener(file);
                return AccessController.doPrivileged(privilegedOutputPipeOpener);
            }
            catch (RuntimeException e) {
                if (timeoutMillisRemaining <= 0L) {
                    this.propagatePrivilegedException(e);
                }
                long thisSleep = Math.min(timeoutMillisRemaining, 20L);
                timeoutMillisRemaining -= thisSleep;
                try {
                    Thread.sleep(thisSleep);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    this.propagatePrivilegedException(e);
                    continue;
                }
            }
            break;
        }
    }

    private OutputStream openNamedPipeOutputStreamUnix(Path file, Duration timeout) throws IOException {
        long thisSleep;
        for (long timeoutMillisRemaining = timeout.toMillis(); timeoutMillisRemaining > 0L && !Files.exists(file, new LinkOption[0]); timeoutMillisRemaining -= thisSleep) {
            thisSleep = Math.min(timeoutMillisRemaining, 20L);
            try {
                Thread.sleep(thisSleep);
                continue;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (Files.isRegularFile(file, new LinkOption[0])) {
            throw new IOException(file + " is not a named pipe");
        }
        if (!Files.exists(file, new LinkOption[0])) {
            throw new FileNotFoundException("Cannot open " + file + " (No such file or directory)");
        }
        return Files.newOutputStream(file, new OpenOption[0]);
    }

    private void propagatePrivilegedException(RuntimeException e) throws IOException {
        Throwable ioe = ExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{IOException.class});
        if (ioe != null) {
            throw (IOException)ioe;
        }
        throw e;
    }

    private static class PrivilegedInputPipeOpener
    implements PrivilegedAction<InputStream> {
        private final Path file;

        PrivilegedInputPipeOpener(Path file) {
            this.file = file;
        }

        @Override
        @SuppressForbidden(reason="Files.newInputStream doesn't work with Windows named pipes")
        public InputStream run() {
            try {
                return new FileInputStream(this.file.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class PrivilegedOutputPipeOpener
    implements PrivilegedAction<OutputStream> {
        private final Path file;

        PrivilegedOutputPipeOpener(Path file) {
            this.file = file;
        }

        @Override
        @SuppressForbidden(reason="Files.newOutputStream doesn't work with Windows named pipes")
        public OutputStream run() {
            try {
                return new FileOutputStream(this.file.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

