/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.datafeeds;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;

public class RestGetDatafeedStatsAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_ml/datafeeds/{" + DatafeedConfig.ID.getPreferredName() + "}/_stats", RestRequest.Method.GET, "/_xpack/ml/datafeeds/{" + DatafeedConfig.ID.getPreferredName() + "}/_stats"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_ml/datafeeds/_stats", RestRequest.Method.GET, "/_xpack/ml/datafeeds/_stats")));
    }

    public String getName() {
        return "ml_get_datafeed_stats_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String datafeedId = restRequest.param(DatafeedConfig.ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)datafeedId)) {
            datafeedId = "_all";
        }
        GetDatafeedsStatsAction.Request request = new GetDatafeedsStatsAction.Request(datafeedId);
        if (restRequest.hasParam("allow_no_datafeeds")) {
            LoggingDeprecationHandler.INSTANCE.usedDeprecatedName(null, () -> null, "allow_no_datafeeds", "allow_no_match");
        }
        request.setAllowNoMatch(restRequest.paramAsBoolean("allow_no_match", restRequest.paramAsBoolean("allow_no_datafeeds", request.allowNoMatch())));
        return channel -> client.execute((ActionType)GetDatafeedsStatsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

