/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.params;

import java.util.Objects;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.unit.TimeValue;

public class ForecastParams {
    private final String forecastId;
    private final long createTime;
    private final long duration;
    private final long expiresIn;
    private final String tmpStorage;
    private final Long maxModelMemory;

    private ForecastParams(String forecastId, long createTime, long duration, long expiresIn, String tmpStorage, Long maxModelMemory) {
        this.forecastId = forecastId;
        this.createTime = createTime;
        this.duration = duration;
        this.expiresIn = expiresIn;
        this.tmpStorage = tmpStorage;
        this.maxModelMemory = maxModelMemory;
    }

    public String getForecastId() {
        return this.forecastId;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public String getTmpStorage() {
        return this.tmpStorage;
    }

    public Long getMaxModelMemory() {
        return this.maxModelMemory;
    }

    public int hashCode() {
        return Objects.hash(this.forecastId, this.createTime, this.duration, this.expiresIn, this.tmpStorage, this.maxModelMemory);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ForecastParams other = (ForecastParams)obj;
        return Objects.equals(this.forecastId, other.forecastId) && Objects.equals(this.createTime, other.createTime) && Objects.equals(this.duration, other.duration) && Objects.equals(this.expiresIn, other.expiresIn) && Objects.equals(this.tmpStorage, other.tmpStorage) && Objects.equals(this.maxModelMemory, other.maxModelMemory);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final String forecastId = UUIDs.base64UUID();
        private final long createTimeEpochSecs = System.currentTimeMillis() / 1000L;
        private long durationSecs = 0L;
        private long expiresInSecs = -1L;
        private Long maxModelMemory;
        private String tmpStorage;

        private Builder() {
        }

        public Builder duration(TimeValue duration) {
            this.durationSecs = duration.seconds();
            return this;
        }

        public Builder expiresIn(TimeValue expiresIn) {
            this.expiresInSecs = expiresIn.seconds();
            return this;
        }

        public Builder tmpStorage(String tmpStorage) {
            this.tmpStorage = tmpStorage;
            return this;
        }

        public Builder maxModelMemory(long maxModelMemory) {
            this.maxModelMemory = maxModelMemory;
            return this;
        }

        public ForecastParams build() {
            return new ForecastParams(this.forecastId, this.createTimeEpochSecs, this.durationSecs, this.expiresInSecs, this.tmpStorage, this.maxModelMemory);
        }
    }
}

