/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.modelsize;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.inference.InferenceDefinition;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;
import org.elasticsearch.xpack.ml.inference.modelsize.EnsembleSizeInfo;
import org.elasticsearch.xpack.ml.inference.modelsize.PreprocessorSize;
import org.elasticsearch.xpack.ml.inference.modelsize.TrainedModelSizeInfo;

public class ModelSizeInfo
implements Accountable,
ToXContentObject {
    private static final ParseField PREPROCESSORS = new ParseField("preprocessors", new String[0]);
    private static final ParseField TRAINED_MODEL_SIZE = new ParseField("trained_model_size", new String[0]);
    public static ConstructingObjectParser<ModelSizeInfo, Void> PARSER = new ConstructingObjectParser("model_size", false, a -> new ModelSizeInfo((EnsembleSizeInfo)a[0], (List)a[1]));
    private final EnsembleSizeInfo ensembleSizeInfo;
    private final List<PreprocessorSize> preprocessorSizes;

    public ModelSizeInfo(EnsembleSizeInfo ensembleSizeInfo, List<PreprocessorSize> preprocessorSizes) {
        this.ensembleSizeInfo = ensembleSizeInfo;
        this.preprocessorSizes = preprocessorSizes == null ? Collections.emptyList() : preprocessorSizes;
    }

    public int numOperations() {
        return this.preprocessorSizes.size() + this.ensembleSizeInfo.getNumOperations();
    }

    public long ramBytesUsed() {
        long size = InferenceDefinition.SHALLOW_SIZE;
        size += this.ensembleSizeInfo.ramBytesUsed();
        return RamUsageEstimator.alignObjectSize((long)(size += this.preprocessorSizes.stream().mapToLong(Accountable::ramBytesUsed).sum()));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        NamedXContentObjectHelper.writeNamedObject((XContentBuilder)builder, (ToXContent.Params)params, (String)TRAINED_MODEL_SIZE.getPreferredName(), (NamedXContentObject)this.ensembleSizeInfo);
        if (this.preprocessorSizes.size() > 0) {
            NamedXContentObjectHelper.writeNamedObjects((XContentBuilder)builder, (ToXContent.Params)params, (boolean)true, (String)PREPROCESSORS.getPreferredName(), this.preprocessorSizes);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelSizeInfo modelSizeInfo = (ModelSizeInfo)o;
        return Objects.equals(this.ensembleSizeInfo, modelSizeInfo.ensembleSizeInfo) && Objects.equals(this.preprocessorSizes, modelSizeInfo.preprocessorSizes);
    }

    public int hashCode() {
        return Objects.hash(this.ensembleSizeInfo, this.preprocessorSizes);
    }

    static {
        PARSER.declareNamedObject(ConstructingObjectParser.constructorArg(), (p, c, n) -> (TrainedModelSizeInfo)p.namedObject(TrainedModelSizeInfo.class, n, null), TRAINED_MODEL_SIZE);
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (PreprocessorSize)p.namedObject(PreprocessorSize.class, n, null), val -> {}, PREPROCESSORS);
    }
}

