/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.extractor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.RequiredField;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractor;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractorContext;
import org.elasticsearch.xpack.ml.dataframe.extractor.ExtractedFieldsDetector;
import org.elasticsearch.xpack.ml.dataframe.extractor.ExtractedFieldsDetectorFactory;
import org.elasticsearch.xpack.ml.dataframe.traintestsplit.TrainTestSplitterFactory;
import org.elasticsearch.xpack.ml.extractor.ExtractedField;
import org.elasticsearch.xpack.ml.extractor.ExtractedFields;

public class DataFrameDataExtractorFactory {
    private final Client client;
    private final String analyticsId;
    private final List<String> indices;
    private final QueryBuilder sourceQuery;
    private final ExtractedFields extractedFields;
    private final List<RequiredField> requiredFields;
    private final Map<String, String> headers;
    private final boolean supportsRowsWithMissingValues;
    private final TrainTestSplitterFactory trainTestSplitterFactory;

    private DataFrameDataExtractorFactory(Client client, String analyticsId, List<String> indices, QueryBuilder sourceQuery, ExtractedFields extractedFields, List<RequiredField> requiredFields, Map<String, String> headers, boolean supportsRowsWithMissingValues, TrainTestSplitterFactory trainTestSplitterFactory) {
        this.client = Objects.requireNonNull(client);
        this.analyticsId = Objects.requireNonNull(analyticsId);
        this.indices = Objects.requireNonNull(indices);
        this.sourceQuery = Objects.requireNonNull(sourceQuery);
        this.extractedFields = Objects.requireNonNull(extractedFields);
        this.requiredFields = Objects.requireNonNull(requiredFields);
        this.headers = headers;
        this.supportsRowsWithMissingValues = supportsRowsWithMissingValues;
        this.trainTestSplitterFactory = Objects.requireNonNull(trainTestSplitterFactory);
    }

    public DataFrameDataExtractor newExtractor(boolean includeSource) {
        DataFrameDataExtractorContext context = new DataFrameDataExtractorContext(this.analyticsId, this.extractedFields, this.indices, this.buildQuery(), 1000, this.headers, includeSource, this.supportsRowsWithMissingValues, this.trainTestSplitterFactory);
        return new DataFrameDataExtractor(this.client, context);
    }

    private QueryBuilder buildQuery() {
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter(this.sourceQuery);
        this.requiredFields.forEach(requiredField -> query.filter((QueryBuilder)QueryBuilders.existsQuery((String)requiredField.getName())));
        return query;
    }

    public ExtractedFields getExtractedFields() {
        return this.extractedFields;
    }

    public static DataFrameDataExtractorFactory createForSourceIndices(Client client, String taskId, DataFrameAnalyticsConfig config, ExtractedFields extractedFields) {
        return new DataFrameDataExtractorFactory(client, taskId, Arrays.asList(config.getSource().getIndex()), config.getSource().getParsedQuery(), extractedFields, config.getAnalysis().getRequiredFields(), config.getHeaders(), config.getAnalysis().supportsMissingValues(), DataFrameDataExtractorFactory.createTrainTestSplitterFactory(client, config, extractedFields));
    }

    private static TrainTestSplitterFactory createTrainTestSplitterFactory(Client client, DataFrameAnalyticsConfig config, ExtractedFields extractedFields) {
        return new TrainTestSplitterFactory(client, config, extractedFields.getAllFields().stream().map(ExtractedField::getName).collect(Collectors.toList()));
    }

    public static void createForDestinationIndex(Client client, DataFrameAnalyticsConfig config, ActionListener<DataFrameDataExtractorFactory> listener) {
        ExtractedFieldsDetectorFactory extractedFieldsDetectorFactory = new ExtractedFieldsDetectorFactory(client);
        extractedFieldsDetectorFactory.createFromDest(config, (ActionListener<ExtractedFieldsDetector>)ActionListener.wrap(extractedFieldsDetector -> {
            ExtractedFields extractedFields = (ExtractedFields)extractedFieldsDetector.detect().v1();
            DataFrameDataExtractorFactory extractorFactory = new DataFrameDataExtractorFactory(client, config.getId(), Collections.singletonList(config.getDest().getIndex()), config.getSource().getParsedQuery(), extractedFields, config.getAnalysis().getRequiredFields(), config.getHeaders(), config.getAnalysis().supportsMissingValues(), DataFrameDataExtractorFactory.createTrainTestSplitterFactory(client, config, extractedFields));
            listener.onResponse((Object)extractorFactory);
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

