/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.util.Objects;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;

class ProblemTracker {
    private static final int EMPTY_DATA_WARN_COUNT = 10;
    private final AnomalyDetectionAuditor auditor;
    private final String jobId;
    private volatile boolean hasProblems;
    private volatile boolean hadProblems;
    private volatile String previousProblem;
    private volatile int emptyDataCount;

    ProblemTracker(AnomalyDetectionAuditor auditor, String jobId) {
        this.auditor = Objects.requireNonNull(auditor);
        this.jobId = Objects.requireNonNull(jobId);
    }

    public void reportAnalysisProblem(String problemMessage) {
        this.reportProblem("Datafeed is encountering errors submitting data for analysis: {0}", problemMessage);
    }

    public void reportExtractionProblem(String problemMessage) {
        this.reportProblem("Datafeed is encountering errors extracting data: {0}", problemMessage);
    }

    private void reportProblem(String template, String problemMessage) {
        this.hasProblems = true;
        if (!Objects.equals(this.previousProblem, problemMessage)) {
            this.previousProblem = problemMessage;
            this.auditor.error(this.jobId, Messages.getMessage((String)template, (Object[])new Object[]{problemMessage}));
        }
    }

    public int reportEmptyDataCount() {
        if (++this.emptyDataCount == 10) {
            this.auditor.warning(this.jobId, Messages.getMessage((String)"Datafeed has been retrieving no data for a while"));
        }
        return this.emptyDataCount;
    }

    public void reportNonEmptyDataCount() {
        if (this.emptyDataCount >= 10) {
            this.auditor.info(this.jobId, Messages.getMessage((String)"Datafeed has started retrieving data again"));
        }
        this.emptyDataCount = 0;
    }

    public boolean hasProblems() {
        return this.hasProblems;
    }

    public void finishReport() {
        if (!this.hasProblems && this.hadProblems) {
            this.auditor.info(this.jobId, Messages.getMessage((String)"Datafeed has recovered data extraction and analysis"));
        }
        this.hadProblems = this.hasProblems;
        this.hasProblems = false;
    }
}

