/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ml.annotations.AnnotationIndex;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.MlAssignmentNotifier;
import org.elasticsearch.xpack.ml.MlDailyMaintenanceService;

class MlInitializationService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(MlInitializationService.class);
    private final Client client;
    private final AtomicBoolean isIndexCreationInProgress = new AtomicBoolean(false);
    private final MlDailyMaintenanceService mlDailyMaintenanceService;
    private boolean isMaster = false;

    MlInitializationService(Settings settings, ThreadPool threadPool, ClusterService clusterService, Client client, MlAssignmentNotifier mlAssignmentNotifier) {
        this(client, new MlDailyMaintenanceService(settings, Objects.requireNonNull(clusterService).getClusterName(), threadPool, client, clusterService, mlAssignmentNotifier), clusterService);
    }

    MlInitializationService(Client client, MlDailyMaintenanceService dailyMaintenanceService, final ClusterService clusterService) {
        this.client = Objects.requireNonNull(client);
        this.mlDailyMaintenanceService = dailyMaintenanceService;
        clusterService.addListener((ClusterStateListener)this);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void afterStart() {
                clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.NIGHTLY_MAINTENANCE_REQUESTS_PER_SECOND, MlInitializationService.this.mlDailyMaintenanceService::setDeleteExpiredDataRequestsPerSecond);
            }

            public void beforeStop() {
                MlInitializationService.this.offMaster();
            }
        });
    }

    public void onMaster() {
        this.mlDailyMaintenanceService.start();
    }

    public void offMaster() {
        this.mlDailyMaintenanceService.stop();
    }

    public void clusterChanged(ClusterChangedEvent event) {
        boolean prevIsMaster = this.isMaster;
        if (prevIsMaster != event.localNodeMaster()) {
            this.isMaster = event.localNodeMaster();
            if (this.isMaster) {
                this.onMaster();
            } else {
                this.offMaster();
            }
        }
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (this.isMaster && this.isIndexCreationInProgress.compareAndSet(false, true)) {
            AnnotationIndex.createAnnotationsIndexIfNecessary((Client)this.client, (ClusterState)event.state(), (ActionListener)ActionListener.wrap(r -> this.isIndexCreationInProgress.set(false), e -> {
                this.isIndexCreationInProgress.set(false);
                logger.error("Error creating ML annotations index or aliases", (Throwable)e);
            }));
        }
    }

    MlDailyMaintenanceService getDailyMaintenanceService() {
        return this.mlDailyMaintenanceService;
    }
}

