/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.breaker.BreakerSettings;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.monitor.os.OsStats;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.CircuitBreakerPlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ScalingExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlMetaIndex;
import org.elasticsearch.xpack.core.ml.action.CloseJobAction;
import org.elasticsearch.xpack.core.ml.action.DeleteCalendarAction;
import org.elasticsearch.xpack.core.ml.action.DeleteCalendarEventAction;
import org.elasticsearch.xpack.core.ml.action.DeleteDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.DeleteDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.DeleteExpiredDataAction;
import org.elasticsearch.xpack.core.ml.action.DeleteFilterAction;
import org.elasticsearch.xpack.core.ml.action.DeleteForecastAction;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.action.DeleteModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.DeleteTrainedModelAction;
import org.elasticsearch.xpack.core.ml.action.EstimateModelMemoryAction;
import org.elasticsearch.xpack.core.ml.action.EvaluateDataFrameAction;
import org.elasticsearch.xpack.core.ml.action.ExplainDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.FinalizeJobExecutionAction;
import org.elasticsearch.xpack.core.ml.action.FindFileStructureAction;
import org.elasticsearch.xpack.core.ml.action.FlushJobAction;
import org.elasticsearch.xpack.core.ml.action.ForecastJobAction;
import org.elasticsearch.xpack.core.ml.action.GetBucketsAction;
import org.elasticsearch.xpack.core.ml.action.GetCalendarEventsAction;
import org.elasticsearch.xpack.core.ml.action.GetCalendarsAction;
import org.elasticsearch.xpack.core.ml.action.GetCategoriesAction;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetFiltersAction;
import org.elasticsearch.xpack.core.ml.action.GetInfluencersAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetModelSnapshotsAction;
import org.elasticsearch.xpack.core.ml.action.GetOverallBucketsAction;
import org.elasticsearch.xpack.core.ml.action.GetRecordsAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsStatsAction;
import org.elasticsearch.xpack.core.ml.action.InternalInferModelAction;
import org.elasticsearch.xpack.core.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.KillProcessAction;
import org.elasticsearch.xpack.core.ml.action.MlInfoAction;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.PersistJobAction;
import org.elasticsearch.xpack.core.ml.action.PostCalendarEventsAction;
import org.elasticsearch.xpack.core.ml.action.PostDataAction;
import org.elasticsearch.xpack.core.ml.action.PreviewDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.PutCalendarAction;
import org.elasticsearch.xpack.core.ml.action.PutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.PutFilterAction;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelAction;
import org.elasticsearch.xpack.core.ml.action.RevertModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.SetUpgradeModeAction;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.StopDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.StopDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.UpdateCalendarJobAction;
import org.elasticsearch.xpack.core.ml.action.UpdateDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.UpdateDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.UpdateFilterAction;
import org.elasticsearch.xpack.core.ml.action.UpdateJobAction;
import org.elasticsearch.xpack.core.ml.action.UpdateModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.UpdateProcessAction;
import org.elasticsearch.xpack.core.ml.action.ValidateDetectorAction;
import org.elasticsearch.xpack.core.ml.action.ValidateJobConfigAction;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.MlDataFrameAnalysisNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.inference.MlInferenceNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.template.TemplateUtils;
import org.elasticsearch.xpack.ml.InvalidLicenseEnforcer;
import org.elasticsearch.xpack.ml.MachineLearningFeatureSet;
import org.elasticsearch.xpack.ml.MlAssignmentNotifier;
import org.elasticsearch.xpack.ml.MlConfigMigrationEligibilityCheck;
import org.elasticsearch.xpack.ml.MlConfigMigrator;
import org.elasticsearch.xpack.ml.MlIndexTemplateRegistry;
import org.elasticsearch.xpack.ml.MlInitializationService;
import org.elasticsearch.xpack.ml.MlLifeCycleService;
import org.elasticsearch.xpack.ml.MlUpgradeModeActionFilter;
import org.elasticsearch.xpack.ml.action.TransportCloseJobAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteCalendarAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteCalendarEventAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteExpiredDataAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteFilterAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteForecastAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteJobAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteTrainedModelAction;
import org.elasticsearch.xpack.ml.action.TransportEstimateModelMemoryAction;
import org.elasticsearch.xpack.ml.action.TransportEvaluateDataFrameAction;
import org.elasticsearch.xpack.ml.action.TransportExplainDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportFinalizeJobExecutionAction;
import org.elasticsearch.xpack.ml.action.TransportFindFileStructureAction;
import org.elasticsearch.xpack.ml.action.TransportFlushJobAction;
import org.elasticsearch.xpack.ml.action.TransportForecastJobAction;
import org.elasticsearch.xpack.ml.action.TransportGetBucketsAction;
import org.elasticsearch.xpack.ml.action.TransportGetCalendarEventsAction;
import org.elasticsearch.xpack.ml.action.TransportGetCalendarsAction;
import org.elasticsearch.xpack.ml.action.TransportGetCategoriesAction;
import org.elasticsearch.xpack.ml.action.TransportGetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportGetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.ml.action.TransportGetDatafeedsAction;
import org.elasticsearch.xpack.ml.action.TransportGetDatafeedsStatsAction;
import org.elasticsearch.xpack.ml.action.TransportGetFiltersAction;
import org.elasticsearch.xpack.ml.action.TransportGetInfluencersAction;
import org.elasticsearch.xpack.ml.action.TransportGetJobsAction;
import org.elasticsearch.xpack.ml.action.TransportGetJobsStatsAction;
import org.elasticsearch.xpack.ml.action.TransportGetModelSnapshotsAction;
import org.elasticsearch.xpack.ml.action.TransportGetOverallBucketsAction;
import org.elasticsearch.xpack.ml.action.TransportGetRecordsAction;
import org.elasticsearch.xpack.ml.action.TransportGetTrainedModelsAction;
import org.elasticsearch.xpack.ml.action.TransportGetTrainedModelsStatsAction;
import org.elasticsearch.xpack.ml.action.TransportInternalInferModelAction;
import org.elasticsearch.xpack.ml.action.TransportIsolateDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportKillProcessAction;
import org.elasticsearch.xpack.ml.action.TransportMlInfoAction;
import org.elasticsearch.xpack.ml.action.TransportOpenJobAction;
import org.elasticsearch.xpack.ml.action.TransportPersistJobAction;
import org.elasticsearch.xpack.ml.action.TransportPostCalendarEventsAction;
import org.elasticsearch.xpack.ml.action.TransportPostDataAction;
import org.elasticsearch.xpack.ml.action.TransportPreviewDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportPutCalendarAction;
import org.elasticsearch.xpack.ml.action.TransportPutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportPutDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportPutFilterAction;
import org.elasticsearch.xpack.ml.action.TransportPutJobAction;
import org.elasticsearch.xpack.ml.action.TransportPutTrainedModelAction;
import org.elasticsearch.xpack.ml.action.TransportRevertModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.TransportSetUpgradeModeAction;
import org.elasticsearch.xpack.ml.action.TransportStartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportStartDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportStopDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportStopDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateCalendarJobAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateFilterAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateJobAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateProcessAction;
import org.elasticsearch.xpack.ml.action.TransportValidateDetectorAction;
import org.elasticsearch.xpack.ml.action.TransportValidateJobConfigAction;
import org.elasticsearch.xpack.ml.annotations.AnnotationPersister;
import org.elasticsearch.xpack.ml.datafeed.DatafeedJobBuilder;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsManager;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsConfigProvider;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessManager;
import org.elasticsearch.xpack.ml.dataframe.process.MemoryUsageEstimationProcessManager;
import org.elasticsearch.xpack.ml.dataframe.process.NativeAnalyticsProcessFactory;
import org.elasticsearch.xpack.ml.dataframe.process.NativeMemoryUsageEstimationProcessFactory;
import org.elasticsearch.xpack.ml.inference.TrainedModelStatsService;
import org.elasticsearch.xpack.ml.inference.aggs.InferencePipelineAggregationBuilder;
import org.elasticsearch.xpack.ml.inference.aggs.InternalInferenceAggregation;
import org.elasticsearch.xpack.ml.inference.ingest.InferenceProcessor;
import org.elasticsearch.xpack.ml.inference.loadingservice.ModelLoadingService;
import org.elasticsearch.xpack.ml.inference.modelsize.MlModelSizeNamedXContentProvider;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.JobManagerHolder;
import org.elasticsearch.xpack.ml.job.UpdateJobProcessNotifier;
import org.elasticsearch.xpack.ml.job.categorization.MlClassicTokenizer;
import org.elasticsearch.xpack.ml.job.categorization.MlClassicTokenizerFactory;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobDataCountsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectBuilder;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessFactory;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.job.process.autodetect.BlackHoleAutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.NativeAutodetectProcessFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.MultiplyingNormalizerProcess;
import org.elasticsearch.xpack.ml.job.process.normalizer.NativeNormalizerProcessFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerProcessFactory;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.notifications.InferenceAuditor;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.NativeControllerHolder;
import org.elasticsearch.xpack.ml.process.NativeStorageProvider;
import org.elasticsearch.xpack.ml.rest.RestDeleteExpiredDataAction;
import org.elasticsearch.xpack.ml.rest.RestFindFileStructureAction;
import org.elasticsearch.xpack.ml.rest.RestMlInfoAction;
import org.elasticsearch.xpack.ml.rest.RestSetUpgradeModeAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestDeleteCalendarAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestDeleteCalendarEventAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestDeleteCalendarJobAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestGetCalendarEventsAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestGetCalendarsAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestPostCalendarEventAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestPutCalendarAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestPutCalendarJobAction;
import org.elasticsearch.xpack.ml.rest.cat.RestCatDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.cat.RestCatDatafeedsAction;
import org.elasticsearch.xpack.ml.rest.cat.RestCatJobsAction;
import org.elasticsearch.xpack.ml.rest.cat.RestCatTrainedModelsAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestDeleteDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestGetDatafeedStatsAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestGetDatafeedsAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestPreviewDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestPutDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestStartDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestStopDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestUpdateDatafeedAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestDeleteDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestEvaluateDataFrameAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestExplainDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestGetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestGetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestPostDataFrameAnalyticsUpdateAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestPutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestStartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestStopDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.filter.RestDeleteFilterAction;
import org.elasticsearch.xpack.ml.rest.filter.RestGetFiltersAction;
import org.elasticsearch.xpack.ml.rest.filter.RestPutFilterAction;
import org.elasticsearch.xpack.ml.rest.filter.RestUpdateFilterAction;
import org.elasticsearch.xpack.ml.rest.inference.RestDeleteTrainedModelAction;
import org.elasticsearch.xpack.ml.rest.inference.RestGetTrainedModelsAction;
import org.elasticsearch.xpack.ml.rest.inference.RestGetTrainedModelsStatsAction;
import org.elasticsearch.xpack.ml.rest.inference.RestPutTrainedModelAction;
import org.elasticsearch.xpack.ml.rest.job.RestCloseJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestDeleteForecastAction;
import org.elasticsearch.xpack.ml.rest.job.RestDeleteJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestEstimateModelMemoryAction;
import org.elasticsearch.xpack.ml.rest.job.RestFlushJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestForecastJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestGetJobStatsAction;
import org.elasticsearch.xpack.ml.rest.job.RestGetJobsAction;
import org.elasticsearch.xpack.ml.rest.job.RestOpenJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestPostDataAction;
import org.elasticsearch.xpack.ml.rest.job.RestPostJobUpdateAction;
import org.elasticsearch.xpack.ml.rest.job.RestPutJobAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestDeleteModelSnapshotAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestGetModelSnapshotsAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestRevertModelSnapshotAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestUpdateModelSnapshotAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetBucketsAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetCategoriesAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetInfluencersAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetOverallBucketsAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetRecordsAction;
import org.elasticsearch.xpack.ml.rest.validate.RestValidateDetectorAction;
import org.elasticsearch.xpack.ml.rest.validate.RestValidateJobConfigAction;
import org.elasticsearch.xpack.ml.utils.persistence.ResultsPersisterService;

public class MachineLearning
extends Plugin
implements SystemIndexPlugin,
AnalysisPlugin,
CircuitBreakerPlugin,
IngestPlugin,
PersistentTaskPlugin,
SearchPlugin {
    public static final String NAME = "ml";
    public static final String BASE_PATH = "/_ml/";
    public static final String PRE_V7_BASE_PATH = "/_xpack/ml/";
    public static final String DATAFEED_THREAD_POOL_NAME = "ml_datafeed";
    public static final String JOB_COMMS_THREAD_POOL_NAME = "ml_job_comms";
    public static final String UTILITY_THREAD_POOL_NAME = "ml_utility";
    public static final String TRAINED_MODEL_CIRCUIT_BREAKER_NAME = "model_inference";
    private static final long DEFAULT_MODEL_CIRCUIT_BREAKER_LIMIT = (long)(0.5 * (double)JvmInfo.jvmInfo().getMem().getHeapMax().getBytes());
    private static final double DEFAULT_MODEL_CIRCUIT_BREAKER_OVERHEAD = 1.0;
    public static final boolean CATEGORIZATION_TOKENIZATION_IN_JAVA = true;
    private static final Setting<Boolean> ML_ENABLED = Setting.boolSetting((String)"node.ml", (Setting)XPackSettings.MACHINE_LEARNING_ENABLED, (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.NodeScope});
    public static final DiscoveryNodeRole ML_ROLE = new DiscoveryNodeRole("ml", "l"){

        public Setting<Boolean> legacySetting() {
            return ML_ENABLED;
        }
    };
    private static final String PRE_V7_ML_ENABLED_NODE_ATTR = "ml.enabled";
    public static final String MAX_OPEN_JOBS_NODE_ATTR = "ml.max_open_jobs";
    public static final String MACHINE_MEMORY_NODE_ATTR = "ml.machine_memory";
    public static final Setting<Integer> CONCURRENT_JOB_ALLOCATIONS = Setting.intSetting((String)"xpack.ml.node_concurrent_job_allocations", (int)2, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final ByteSizeValue NATIVE_EXECUTABLE_CODE_OVERHEAD = new ByteSizeValue(30L, ByteSizeUnit.MB);
    public static final Setting<Integer> MAX_MACHINE_MEMORY_PERCENT = Setting.intSetting((String)"xpack.ml.max_machine_memory_percent", (int)30, (int)5, (int)200, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Integer> MAX_LAZY_ML_NODES = Setting.intSetting((String)"xpack.ml.max_lazy_ml_nodes", (int)0, (int)0, (int)3, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final int MAX_MAX_OPEN_JOBS_PER_NODE = 512;
    public static final Setting<Integer> MAX_OPEN_JOBS_PER_NODE = Setting.intSetting((String)"xpack.ml.max_open_jobs", (int)20, (int)1, (int)512, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> PROCESS_CONNECT_TIMEOUT = Setting.timeSetting((String)"xpack.ml.process_connect_timeout", (TimeValue)TimeValue.timeValueSeconds((long)10L), (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> MIN_DISK_SPACE_OFF_HEAP = Setting.byteSizeSetting((String)"xpack.ml.min_disk_space_off_heap", (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.GB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Float> NIGHTLY_MAINTENANCE_REQUESTS_PER_SECOND = new Setting("xpack.ml.nightly_maintenance_requests_per_second", s -> Float.toString(-1.0f), s -> {
        float value = Float.parseFloat(s);
        if (value <= 0.0f && value != -1.0f) {
            throw new IllegalArgumentException("Failed to parse value [" + s + "] for setting [xpack.ml.nightly_maintenance_requests_per_second] must be > 0.0 or exactly equal to -1.0");
        }
        return Float.valueOf(value);
    }, new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(MachineLearning.class);
    private final Settings settings;
    private final boolean enabled;
    private final boolean transportClientMode;
    private final SetOnce<AutodetectProcessManager> autodetectProcessManager = new SetOnce();
    private final SetOnce<DatafeedManager> datafeedManager = new SetOnce();
    private final SetOnce<DataFrameAnalyticsManager> dataFrameAnalyticsManager = new SetOnce();
    private final SetOnce<DataFrameAnalyticsAuditor> dataFrameAnalyticsAuditor = new SetOnce();
    private final SetOnce<MlMemoryTracker> memoryTracker = new SetOnce();
    private final SetOnce<ActionFilter> mlUpgradeModeActionFilter = new SetOnce();
    private final SetOnce<CircuitBreaker> inferenceModelBreaker = new SetOnce();
    private final SetOnce<ModelLoadingService> modelLoadingService = new SetOnce();

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        if (!this.enabled) {
            return Collections.emptyMap();
        }
        InferenceProcessor.Factory inferenceFactory = new InferenceProcessor.Factory(parameters.client, parameters.ingestService.getClusterService(), this.settings);
        parameters.ingestService.addIngestClusterStateListener((Consumer)inferenceFactory);
        return Collections.singletonMap("inference", inferenceFactory);
    }

    public Set<DiscoveryNodeRole> getRoles() {
        return Collections.singleton(ML_ROLE);
    }

    public MachineLearning(Settings settings, Path configPath) {
        this.settings = settings;
        this.enabled = (Boolean)XPackSettings.MACHINE_LEARNING_ENABLED.get(settings);
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public static boolean isMlNode(DiscoveryNode node) {
        Map nodeAttributes = node.getAttributes();
        try {
            return Integer.parseInt((String)nodeAttributes.get(MAX_OPEN_JOBS_NODE_ATTR)) > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public List<Setting<?>> getSettings() {
        return Collections.unmodifiableList(Arrays.asList(MachineLearningField.AUTODETECT_PROCESS, PROCESS_CONNECT_TIMEOUT, ML_ENABLED, CONCURRENT_JOB_ALLOCATIONS, MachineLearningField.MAX_MODEL_MEMORY_LIMIT, MAX_LAZY_ML_NODES, MAX_MACHINE_MEMORY_PERCENT, AutodetectBuilder.DONT_PERSIST_MODEL_STATE_SETTING, AutodetectBuilder.MAX_ANOMALY_RECORDS_SETTING_DYNAMIC, MAX_OPEN_JOBS_PER_NODE, MIN_DISK_SPACE_OFF_HEAP, MlConfigMigrationEligibilityCheck.ENABLE_CONFIG_MIGRATION, InferenceProcessor.MAX_INFERENCE_PROCESSORS, ModelLoadingService.INFERENCE_MODEL_CACHE_SIZE, ModelLoadingService.INFERENCE_MODEL_CACHE_TTL, ResultsPersisterService.PERSIST_RESULTS_MAX_RETRIES, NIGHTLY_MAINTENANCE_REQUESTS_PER_SECOND));
    }

    public Settings additionalSettings() {
        String mlEnabledNodeAttrName = "node.attr.ml.enabled";
        String maxOpenJobsPerNodeNodeAttrName = "node.attr.ml.max_open_jobs";
        String machineMemoryAttrName = "node.attr.ml.machine_memory";
        if (!this.enabled || this.transportClientMode) {
            this.disallowMlNodeAttributes(mlEnabledNodeAttrName, maxOpenJobsPerNodeNodeAttrName, machineMemoryAttrName);
            return Settings.EMPTY;
        }
        Settings.Builder additionalSettings = Settings.builder();
        Boolean allocationEnabled = DiscoveryNode.hasRole((Settings)this.settings, (DiscoveryNodeRole)ML_ROLE);
        if (allocationEnabled != null && allocationEnabled.booleanValue()) {
            this.addMlNodeAttribute(additionalSettings, maxOpenJobsPerNodeNodeAttrName, String.valueOf(MAX_OPEN_JOBS_PER_NODE.get(this.settings)));
            this.addMlNodeAttribute(additionalSettings, machineMemoryAttrName, Long.toString(MachineLearning.machineMemoryFromStats(OsProbe.getInstance().osStats())));
            this.disallowMlNodeAttributes(mlEnabledNodeAttrName);
        } else {
            this.disallowMlNodeAttributes(mlEnabledNodeAttrName, maxOpenJobsPerNodeNodeAttrName, machineMemoryAttrName);
        }
        return additionalSettings.build();
    }

    private void addMlNodeAttribute(Settings.Builder additionalSettings, String attrName, String value) {
        String oldValue = this.settings.get(attrName);
        if (oldValue == null) {
            additionalSettings.put(attrName, value);
        } else {
            this.reportClashingNodeAttribute(attrName);
        }
    }

    private void disallowMlNodeAttributes(String ... mlNodeAttributes) {
        for (String attrName : mlNodeAttributes) {
            if (this.settings.get(attrName) == null) continue;
            this.reportClashingNodeAttribute(attrName);
        }
    }

    private void reportClashingNodeAttribute(String attrName) {
        throw new IllegalArgumentException("Directly setting [" + attrName + "] is not permitted - it is reserved for machine learning. If your intention was to customize machine learning, set the [" + attrName.replace("node.attr.", "xpack.") + "] setting instead.");
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        NativeMemoryUsageEstimationProcessFactory memoryEstimationProcessFactory;
        NativeAnalyticsProcessFactory analyticsProcessFactory;
        NormalizerProcessFactory normalizerProcessFactory;
        AutodetectProcessFactory autodetectProcessFactory;
        if (!this.enabled || this.transportClientMode) {
            return Collections.singletonList(new JobManagerHolder());
        }
        this.mlUpgradeModeActionFilter.set((Object)new MlUpgradeModeActionFilter(clusterService));
        new MlIndexTemplateRegistry(this.settings, clusterService, threadPool, client, xContentRegistry);
        AnomalyDetectionAuditor anomalyDetectionAuditor = new AnomalyDetectionAuditor(client, clusterService);
        DataFrameAnalyticsAuditor dataFrameAnalyticsAuditor = new DataFrameAnalyticsAuditor(client, clusterService);
        InferenceAuditor inferenceAuditor = new InferenceAuditor(client, clusterService);
        this.dataFrameAnalyticsAuditor.set((Object)dataFrameAnalyticsAuditor);
        OriginSettingClient originSettingClient = new OriginSettingClient(client, NAME);
        ResultsPersisterService resultsPersisterService = new ResultsPersisterService(originSettingClient, clusterService, this.settings);
        AnnotationPersister anomalyDetectionAnnotationPersister = new AnnotationPersister(resultsPersisterService, anomalyDetectionAuditor);
        JobResultsProvider jobResultsProvider = new JobResultsProvider(client, this.settings, indexNameExpressionResolver);
        JobResultsPersister jobResultsPersister = new JobResultsPersister(originSettingClient, resultsPersisterService, anomalyDetectionAuditor);
        JobDataCountsPersister jobDataCountsPersister = new JobDataCountsPersister(client, resultsPersisterService, anomalyDetectionAuditor);
        JobConfigProvider jobConfigProvider = new JobConfigProvider(client, xContentRegistry);
        DatafeedConfigProvider datafeedConfigProvider = new DatafeedConfigProvider(client, xContentRegistry);
        UpdateJobProcessNotifier notifier = new UpdateJobProcessNotifier(client, clusterService, threadPool);
        JobManager jobManager = new JobManager(environment, this.settings, jobResultsProvider, jobResultsPersister, clusterService, anomalyDetectionAuditor, threadPool, client, notifier, xContentRegistry);
        JobManagerHolder jobManagerHolder = new JobManagerHolder(jobManager);
        NativeStorageProvider nativeStorageProvider = new NativeStorageProvider(environment, (ByteSizeValue)MIN_DISK_SPACE_OFF_HEAP.get(this.settings));
        if (((Boolean)MachineLearningField.AUTODETECT_PROCESS.get(this.settings)).booleanValue() && MachineLearningFeatureSet.isRunningOnMlPlatform(true)) {
            try {
                NativeController nativeController = NativeControllerHolder.getNativeController(clusterService.getNodeName(), environment);
                if (nativeController == null) {
                    throw new ElasticsearchException("Failed to create native process controller for Machine Learning", new Object[0]);
                }
                autodetectProcessFactory = new NativeAutodetectProcessFactory(environment, this.settings, nativeController, clusterService, resultsPersisterService, anomalyDetectionAuditor);
                normalizerProcessFactory = new NativeNormalizerProcessFactory(environment, nativeController, clusterService);
                analyticsProcessFactory = new NativeAnalyticsProcessFactory(environment, nativeController, clusterService, xContentRegistry, resultsPersisterService, dataFrameAnalyticsAuditor);
                memoryEstimationProcessFactory = new NativeMemoryUsageEstimationProcessFactory(environment, nativeController, clusterService);
            }
            catch (IOException e) {
                logger.trace("Failed to connect to ML native controller", (Throwable)e);
                throw new ElasticsearchException("Failure running machine learning native code. This could be due to running on an unsupported OS or distribution, missing OS libraries, or a problem with the temp directory. To bypass this problem by running Elasticsearch without machine learning functionality set [" + XPackSettings.MACHINE_LEARNING_ENABLED.getKey() + ": false].", new Object[0]);
            }
        } else {
            autodetectProcessFactory = (job, autodetectParams, executorService, onProcessCrash) -> new BlackHoleAutodetectProcess(job.getId(), onProcessCrash);
            normalizerProcessFactory = (jobId, quantilesState, bucketSpan, executorService) -> new MultiplyingNormalizerProcess(1.0);
            analyticsProcessFactory = (jobId, analyticsProcessConfig, hasState, executorService, onProcessCrash) -> null;
            memoryEstimationProcessFactory = (jobId, analyticsProcessConfig, hasState, executorService, onProcessCrash) -> null;
        }
        NormalizerFactory normalizerFactory = new NormalizerFactory(normalizerProcessFactory, threadPool.executor(UTILITY_THREAD_POOL_NAME));
        AutodetectProcessManager autodetectProcessManager = new AutodetectProcessManager(this.settings, client, threadPool, xContentRegistry, anomalyDetectionAuditor, clusterService, jobManager, jobResultsProvider, jobResultsPersister, jobDataCountsPersister, anomalyDetectionAnnotationPersister, autodetectProcessFactory, normalizerFactory, nativeStorageProvider, indexNameExpressionResolver);
        this.autodetectProcessManager.set((Object)autodetectProcessManager);
        DatafeedJobBuilder datafeedJobBuilder = new DatafeedJobBuilder(client, xContentRegistry, anomalyDetectionAuditor, anomalyDetectionAnnotationPersister, System::currentTimeMillis, jobConfigProvider, jobResultsProvider, datafeedConfigProvider, jobResultsPersister, this.settings, clusterService.getNodeName());
        DatafeedManager datafeedManager = new DatafeedManager(threadPool, client, clusterService, datafeedJobBuilder, System::currentTimeMillis, anomalyDetectionAuditor, autodetectProcessManager);
        this.datafeedManager.set((Object)datafeedManager);
        TrainedModelStatsService trainedModelStatsService = new TrainedModelStatsService(resultsPersisterService, originSettingClient, indexNameExpressionResolver, clusterService, threadPool);
        TrainedModelProvider trainedModelProvider = new TrainedModelProvider(client, xContentRegistry);
        ModelLoadingService modelLoadingService = new ModelLoadingService(trainedModelProvider, inferenceAuditor, threadPool, clusterService, trainedModelStatsService, this.settings, clusterService.getNodeName(), (CircuitBreaker)this.inferenceModelBreaker.get());
        this.modelLoadingService.set((Object)modelLoadingService);
        AnalyticsProcessManager analyticsProcessManager = new AnalyticsProcessManager(this.settings, client, threadPool, analyticsProcessFactory, dataFrameAnalyticsAuditor, trainedModelProvider, modelLoadingService, resultsPersisterService, EsExecutors.allocatedProcessors((Settings)this.settings));
        MemoryUsageEstimationProcessManager memoryEstimationProcessManager = new MemoryUsageEstimationProcessManager(threadPool.generic(), threadPool.executor(UTILITY_THREAD_POOL_NAME), memoryEstimationProcessFactory);
        DataFrameAnalyticsConfigProvider dataFrameAnalyticsConfigProvider = new DataFrameAnalyticsConfigProvider(client, xContentRegistry, dataFrameAnalyticsAuditor);
        assert (client instanceof NodeClient);
        DataFrameAnalyticsManager dataFrameAnalyticsManager = new DataFrameAnalyticsManager((NodeClient)client, dataFrameAnalyticsConfigProvider, analyticsProcessManager, dataFrameAnalyticsAuditor, indexNameExpressionResolver);
        this.dataFrameAnalyticsManager.set((Object)dataFrameAnalyticsManager);
        MlMemoryTracker memoryTracker = new MlMemoryTracker(this.settings, clusterService, threadPool, jobManager, jobResultsProvider, dataFrameAnalyticsConfigProvider);
        this.memoryTracker.set((Object)memoryTracker);
        MlLifeCycleService mlLifeCycleService = new MlLifeCycleService(environment, clusterService, datafeedManager, autodetectProcessManager, dataFrameAnalyticsManager, memoryTracker);
        MlAssignmentNotifier mlAssignmentNotifier = new MlAssignmentNotifier(anomalyDetectionAuditor, dataFrameAnalyticsAuditor, threadPool, new MlConfigMigrator(this.settings, client, clusterService, indexNameExpressionResolver), clusterService);
        InvalidLicenseEnforcer enforcer = new InvalidLicenseEnforcer(this.getLicenseState(), threadPool, datafeedManager, autodetectProcessManager);
        enforcer.listenForLicenseStateChanges();
        nativeStorageProvider.cleanupLocalTmpStorageInCaseOfUncleanShutdown();
        return Arrays.asList(new Object[]{mlLifeCycleService, jobResultsProvider, jobResultsPersister, jobConfigProvider, datafeedConfigProvider, jobManager, jobManagerHolder, autodetectProcessManager, new MlInitializationService(this.settings, threadPool, clusterService, client, mlAssignmentNotifier), jobDataCountsPersister, datafeedManager, anomalyDetectionAuditor, dataFrameAnalyticsAuditor, inferenceAuditor, mlAssignmentNotifier, memoryTracker, analyticsProcessManager, memoryEstimationProcessManager, dataFrameAnalyticsConfigProvider, nativeStorageProvider, modelLoadingService, trainedModelProvider});
    }

    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule, IndexNameExpressionResolver expressionResolver) {
        if (!this.enabled || this.transportClientMode) {
            return Collections.emptyList();
        }
        return Arrays.asList(new PersistentTasksExecutor[]{new TransportOpenJobAction.OpenJobPersistentTasksExecutor(this.settings, clusterService, (AutodetectProcessManager)this.autodetectProcessManager.get(), (MlMemoryTracker)this.memoryTracker.get(), client, expressionResolver), new TransportStartDatafeedAction.StartDatafeedPersistentTasksExecutor((DatafeedManager)this.datafeedManager.get(), expressionResolver), new TransportStartDataFrameAnalyticsAction.TaskExecutor(this.settings, client, clusterService, (DataFrameAnalyticsManager)this.dataFrameAnalyticsManager.get(), (DataFrameAnalyticsAuditor)((Object)this.dataFrameAnalyticsAuditor.get()), (MlMemoryTracker)this.memoryTracker.get(), expressionResolver, MlIndexTemplateRegistry.INFERENCE_TEMPLATE)});
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (this.transportClientMode) {
            return modules;
        }
        modules.add(b -> XPackPlugin.bindFeatureSet((Binder)b, MachineLearningFeatureSet.class));
        return modules;
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new RestHandler[]{new RestGetJobsAction(), new RestGetJobStatsAction(), new RestMlInfoAction(), new RestPutJobAction(), new RestPostJobUpdateAction(), new RestDeleteJobAction(), new RestOpenJobAction(), new RestGetFiltersAction(), new RestPutFilterAction(), new RestUpdateFilterAction(), new RestDeleteFilterAction(), new RestGetInfluencersAction(), new RestGetRecordsAction(), new RestGetBucketsAction(), new RestGetOverallBucketsAction(), new RestPostDataAction(), new RestCloseJobAction(), new RestFlushJobAction(), new RestValidateDetectorAction(), new RestValidateJobConfigAction(), new RestEstimateModelMemoryAction(), new RestGetCategoriesAction(), new RestGetModelSnapshotsAction(), new RestRevertModelSnapshotAction(), new RestUpdateModelSnapshotAction(), new RestGetDatafeedsAction(), new RestGetDatafeedStatsAction(), new RestPutDatafeedAction(), new RestUpdateDatafeedAction(), new RestDeleteDatafeedAction(), new RestPreviewDatafeedAction(), new RestStartDatafeedAction(), new RestStopDatafeedAction(), new RestDeleteModelSnapshotAction(), new RestDeleteExpiredDataAction(), new RestForecastJobAction(), new RestDeleteForecastAction(), new RestGetCalendarsAction(), new RestPutCalendarAction(), new RestDeleteCalendarAction(), new RestDeleteCalendarEventAction(), new RestDeleteCalendarJobAction(), new RestPutCalendarJobAction(), new RestGetCalendarEventsAction(), new RestPostCalendarEventAction(), new RestFindFileStructureAction(), new RestSetUpgradeModeAction(), new RestGetDataFrameAnalyticsAction(), new RestGetDataFrameAnalyticsStatsAction(), new RestPutDataFrameAnalyticsAction(), new RestPostDataFrameAnalyticsUpdateAction(), new RestDeleteDataFrameAnalyticsAction(), new RestStartDataFrameAnalyticsAction(), new RestStopDataFrameAnalyticsAction(), new RestEvaluateDataFrameAction(), new RestExplainDataFrameAnalyticsAction(), new RestGetTrainedModelsAction(), new RestDeleteTrainedModelAction(), new RestGetTrainedModelsStatsAction(), new RestPutTrainedModelAction(), new RestCatJobsAction(), new RestCatTrainedModelsAction(), new RestCatDatafeedsAction(), new RestCatDataFrameAnalyticsAction()});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)GetJobsAction.INSTANCE, TransportGetJobsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetJobsStatsAction.INSTANCE, TransportGetJobsStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MlInfoAction.INSTANCE, TransportMlInfoAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutJobAction.INSTANCE, TransportPutJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateJobAction.INSTANCE, TransportUpdateJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteJobAction.INSTANCE, TransportDeleteJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)OpenJobAction.INSTANCE, TransportOpenJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetFiltersAction.INSTANCE, TransportGetFiltersAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutFilterAction.INSTANCE, TransportPutFilterAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateFilterAction.INSTANCE, TransportUpdateFilterAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteFilterAction.INSTANCE, TransportDeleteFilterAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)KillProcessAction.INSTANCE, TransportKillProcessAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetBucketsAction.INSTANCE, TransportGetBucketsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetInfluencersAction.INSTANCE, TransportGetInfluencersAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetOverallBucketsAction.INSTANCE, TransportGetOverallBucketsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetRecordsAction.INSTANCE, TransportGetRecordsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PostDataAction.INSTANCE, TransportPostDataAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)CloseJobAction.INSTANCE, TransportCloseJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)FinalizeJobExecutionAction.INSTANCE, TransportFinalizeJobExecutionAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)FlushJobAction.INSTANCE, TransportFlushJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ValidateDetectorAction.INSTANCE, TransportValidateDetectorAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ValidateJobConfigAction.INSTANCE, TransportValidateJobConfigAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)EstimateModelMemoryAction.INSTANCE, TransportEstimateModelMemoryAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetCategoriesAction.INSTANCE, TransportGetCategoriesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetModelSnapshotsAction.INSTANCE, TransportGetModelSnapshotsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)RevertModelSnapshotAction.INSTANCE, TransportRevertModelSnapshotAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateModelSnapshotAction.INSTANCE, TransportUpdateModelSnapshotAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetDatafeedsAction.INSTANCE, TransportGetDatafeedsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetDatafeedsStatsAction.INSTANCE, TransportGetDatafeedsStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutDatafeedAction.INSTANCE, TransportPutDatafeedAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateDatafeedAction.INSTANCE, TransportUpdateDatafeedAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteDatafeedAction.INSTANCE, TransportDeleteDatafeedAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PreviewDatafeedAction.INSTANCE, TransportPreviewDatafeedAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StartDatafeedAction.INSTANCE, TransportStartDatafeedAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StopDatafeedAction.INSTANCE, TransportStopDatafeedAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)IsolateDatafeedAction.INSTANCE, TransportIsolateDatafeedAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteModelSnapshotAction.INSTANCE, TransportDeleteModelSnapshotAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateProcessAction.INSTANCE, TransportUpdateProcessAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteExpiredDataAction.INSTANCE, TransportDeleteExpiredDataAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ForecastJobAction.INSTANCE, TransportForecastJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteForecastAction.INSTANCE, TransportDeleteForecastAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetCalendarsAction.INSTANCE, TransportGetCalendarsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutCalendarAction.INSTANCE, TransportPutCalendarAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteCalendarAction.INSTANCE, TransportDeleteCalendarAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteCalendarEventAction.INSTANCE, TransportDeleteCalendarEventAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateCalendarJobAction.INSTANCE, TransportUpdateCalendarJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetCalendarEventsAction.INSTANCE, TransportGetCalendarEventsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PostCalendarEventsAction.INSTANCE, TransportPostCalendarEventsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PersistJobAction.INSTANCE, TransportPersistJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)FindFileStructureAction.INSTANCE, TransportFindFileStructureAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SetUpgradeModeAction.INSTANCE, TransportSetUpgradeModeAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetDataFrameAnalyticsAction.INSTANCE, TransportGetDataFrameAnalyticsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetDataFrameAnalyticsStatsAction.INSTANCE, TransportGetDataFrameAnalyticsStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutDataFrameAnalyticsAction.INSTANCE, TransportPutDataFrameAnalyticsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateDataFrameAnalyticsAction.INSTANCE, TransportUpdateDataFrameAnalyticsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteDataFrameAnalyticsAction.INSTANCE, TransportDeleteDataFrameAnalyticsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StartDataFrameAnalyticsAction.INSTANCE, TransportStartDataFrameAnalyticsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StopDataFrameAnalyticsAction.INSTANCE, TransportStopDataFrameAnalyticsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)EvaluateDataFrameAction.INSTANCE, TransportEvaluateDataFrameAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ExplainDataFrameAnalyticsAction.INSTANCE, TransportExplainDataFrameAnalyticsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)InternalInferModelAction.INSTANCE, TransportInternalInferModelAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetTrainedModelsAction.INSTANCE, TransportGetTrainedModelsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteTrainedModelAction.INSTANCE, TransportDeleteTrainedModelAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetTrainedModelsStatsAction.INSTANCE, TransportGetTrainedModelsStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutTrainedModelAction.INSTANCE, TransportPutTrainedModelAction.class, new Class[0]));
    }

    public List<ActionFilter> getActionFilters() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Collections.singletonList((ActionFilter)this.mlUpgradeModeActionFilter.get());
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        if (!this.enabled || this.transportClientMode) {
            return Collections.emptyList();
        }
        ScalingExecutorBuilder jobComms = new ScalingExecutorBuilder(JOB_COMMS_THREAD_POOL_NAME, 4, 2048, TimeValue.timeValueMinutes((long)1L), "xpack.ml.job_comms_thread_pool");
        ScalingExecutorBuilder utility = new ScalingExecutorBuilder(UTILITY_THREAD_POOL_NAME, 1, 2048, TimeValue.timeValueMinutes((long)10L), "xpack.ml.utility_thread_pool");
        ScalingExecutorBuilder datafeed = new ScalingExecutorBuilder(DATAFEED_THREAD_POOL_NAME, 1, 512, TimeValue.timeValueMinutes((long)1L), "xpack.ml.datafeed_thread_pool");
        return Arrays.asList(jobComms, utility, datafeed);
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> getTokenizers() {
        return Collections.singletonMap(MlClassicTokenizer.NAME, MlClassicTokenizerFactory::new);
    }

    public List<SearchPlugin.PipelineAggregationSpec> getPipelineAggregations() {
        SearchPlugin.PipelineAggregationSpec spec = new SearchPlugin.PipelineAggregationSpec("inference", in -> new InferencePipelineAggregationBuilder(in, this.getLicenseState(), this.modelLoadingService), (parser, name) -> InferencePipelineAggregationBuilder.parse(this.modelLoadingService, this.getLicenseState(), name, parser));
        spec.addResultReader(InternalInferenceAggregation::new);
        return Collections.singletonList(spec);
    }

    public UnaryOperator<Map<String, IndexTemplateMetadata>> getIndexTemplateMetadataUpgrader() {
        return UnaryOperator.identity();
    }

    public static boolean allTemplatesInstalled(ClusterState clusterState) {
        boolean allPresent = true;
        List<String> templateNames = Arrays.asList(".ml-notifications-000001", MlMetaIndex.indexName(), ".ml-state", AnomalyDetectorsIndex.jobResultsIndexPrefix(), ".ml-inference-000003");
        for (String templateName : templateNames) {
            allPresent = allPresent && TemplateUtils.checkTemplateExistsAndVersionIsGTECurrentVersion((String)templateName, (ClusterState)clusterState);
        }
        return allPresent;
    }

    static long machineMemoryFromStats(OsStats stats) {
        BigInteger containerLimit;
        String containerLimitStr;
        long mem = stats.getMem().getTotal().getBytes();
        OsStats.Cgroup cgroup = stats.getCgroup();
        if (cgroup != null && (containerLimitStr = cgroup.getMemoryLimitInBytes()) != null && ((containerLimit = new BigInteger(containerLimitStr)).compareTo(BigInteger.valueOf(mem)) < 0 && containerLimit.compareTo(BigInteger.ZERO) > 0 || mem <= 0L && containerLimit.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) < 0)) {
            mem = containerLimit.longValue();
        }
        return mem;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        ArrayList<NamedXContentRegistry.Entry> namedXContent = new ArrayList<NamedXContentRegistry.Entry>();
        namedXContent.addAll(new MlEvaluationNamedXContentProvider().getNamedXContentParsers());
        namedXContent.addAll(new MlDataFrameAnalysisNamedXContentProvider().getNamedXContentParsers());
        namedXContent.addAll(new MlInferenceNamedXContentProvider().getNamedXContentParsers());
        namedXContent.addAll(new MlModelSizeNamedXContentProvider().getNamedXContentParsers());
        return namedXContent;
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return Collections.unmodifiableList(Arrays.asList(new SystemIndexDescriptor(MlMetaIndex.indexName(), "Contains scheduling and anomaly tracking metadata"), new SystemIndexDescriptor(MlConfigIndex.indexName(), "Contains ML configuration data"), new SystemIndexDescriptor(".ml-inference-*", "Contains ML model configuration and statistics")));
    }

    public BreakerSettings getCircuitBreaker(Settings settings) {
        return BreakerSettings.updateFromSettings((BreakerSettings)new BreakerSettings(TRAINED_MODEL_CIRCUIT_BREAKER_NAME, DEFAULT_MODEL_CIRCUIT_BREAKER_LIMIT, 1.0, CircuitBreaker.Type.MEMORY, CircuitBreaker.Durability.TRANSIENT), (Settings)settings);
    }

    public void setCircuitBreaker(CircuitBreaker circuitBreaker) {
        assert (circuitBreaker.getName().equals(TRAINED_MODEL_CIRCUIT_BREAKER_NAME));
        this.inferenceModelBreaker.set((Object)circuitBreaker);
    }
}

