/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.planner;

import java.util.Arrays;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.eql.plan.physical.FilterExec;
import org.elasticsearch.xpack.eql.plan.physical.LimitWithOffsetExec;
import org.elasticsearch.xpack.eql.plan.physical.OrderExec;
import org.elasticsearch.xpack.eql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.eql.plan.physical.ProjectExec;
import org.elasticsearch.xpack.eql.plan.physical.SequenceExec;
import org.elasticsearch.xpack.eql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.eql.planner.QueryTranslator;
import org.elasticsearch.xpack.eql.querydsl.container.QueryContainer;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.planner.ExpressionTranslators;
import org.elasticsearch.xpack.ql.querydsl.container.AttributeSort;
import org.elasticsearch.xpack.ql.querydsl.container.Sort;
import org.elasticsearch.xpack.ql.querydsl.query.Query;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.Source;

class QueryFolder
extends RuleExecutor<PhysicalPlan> {
    QueryFolder() {
    }

    PhysicalPlan fold(PhysicalPlan plan) {
        return (PhysicalPlan)this.execute((Node)plan);
    }

    protected Iterable<RuleExecutor.Batch> batches() {
        RuleExecutor.Batch fold = new RuleExecutor.Batch((RuleExecutor)this, "Fold queries", new Rule[]{new FoldProject(), new FoldFilter(), new FoldOrderBy(), new FoldLimit()});
        RuleExecutor.Batch finish = new RuleExecutor.Batch((RuleExecutor)this, "Finish query", RuleExecutor.Limiter.ONCE, new Rule[]{new PlanOutputToQueryRef()});
        return Arrays.asList(fold, finish);
    }

    private static class FoldProject
    extends QueryFoldingRule<ProjectExec> {
        private FoldProject() {
        }

        @Override
        protected PhysicalPlan rule(ProjectExec project, EsQueryExec exec) {
            return new EsQueryExec(exec.source(), project.output(), exec.queryContainer());
        }
    }

    private static class FoldFilter
    extends QueryFoldingRule<FilterExec> {
        private FoldFilter() {
        }

        @Override
        protected PhysicalPlan rule(FilterExec plan, EsQueryExec exec) {
            QueryContainer qContainer = exec.queryContainer();
            Query query = QueryTranslator.toQuery(plan.condition());
            if (qContainer.query() != null || query != null) {
                query = ExpressionTranslators.and((Source)plan.source(), (Query)qContainer.query(), (Query)query);
            }
            qContainer = qContainer.with(query);
            return exec.with(qContainer);
        }
    }

    private static class FoldOrderBy
    extends QueryFoldingRule<OrderExec> {
        private FoldOrderBy() {
        }

        @Override
        protected PhysicalPlan rule(OrderExec plan, EsQueryExec query) {
            QueryContainer qContainer = query.queryContainer();
            for (Order order : plan.order()) {
                Sort.Direction direction = Sort.Direction.from((Order.OrderDirection)order.direction());
                Sort.Missing missing = Sort.Missing.from((Order.NullsPosition)order.nullsPosition());
                Expression orderExpression = order.child();
                String lookup = Expressions.id((Expression)orderExpression);
                if (orderExpression instanceof FieldAttribute) {
                    FieldAttribute fa = (FieldAttribute)orderExpression;
                    qContainer = qContainer.addSort(lookup, (Sort)new AttributeSort((Attribute)fa, direction, missing));
                    continue;
                }
                throw new EqlIllegalArgumentException("unsupported sorting expression {}", orderExpression);
            }
            return query.with(qContainer);
        }
    }

    private static class FoldLimit
    extends FoldingRule<LimitWithOffsetExec> {
        private FoldLimit() {
        }

        @Override
        protected PhysicalPlan rule(LimitWithOffsetExec limit) {
            PhysicalPlan plan = limit;
            PhysicalPlan child = limit.child();
            if (child instanceof EsQueryExec) {
                EsQueryExec query = (EsQueryExec)child;
                plan = query.with(query.queryContainer().with(limit.limit()));
            }
            if (child instanceof SequenceExec) {
                SequenceExec exec = (SequenceExec)child;
                plan = exec.with(limit.limit());
            }
            return plan;
        }
    }

    private static class PlanOutputToQueryRef
    extends FoldingRule<EsQueryExec> {
        private PlanOutputToQueryRef() {
        }

        @Override
        protected PhysicalPlan rule(EsQueryExec exec) {
            QueryContainer qContainer = exec.queryContainer();
            for (Attribute attr : exec.output()) {
                qContainer = qContainer.addColumn(attr);
            }
            return exec.with(qContainer);
        }
    }

    static abstract class QueryFoldingRule<SubPlan extends UnaryExec>
    extends FoldingRule<SubPlan> {
        QueryFoldingRule() {
        }

        @Override
        protected final PhysicalPlan rule(SubPlan plan) {
            Object p = plan;
            if (((UnaryExec)plan).child() instanceof EsQueryExec) {
                p = this.rule(plan, (EsQueryExec)((UnaryExec)plan).child());
            }
            return p;
        }

        protected abstract PhysicalPlan rule(SubPlan var1, EsQueryExec var2);
    }

    static abstract class FoldingRule<SubPlan extends PhysicalPlan>
    extends Rule<SubPlan, PhysicalPlan> {
        FoldingRule() {
        }

        public final PhysicalPlan apply(PhysicalPlan plan) {
            return (PhysicalPlan)plan.transformUp(this::rule, this.typeToken());
        }

        protected abstract PhysicalPlan rule(SubPlan var1);
    }
}

