/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plan.logical;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.plan.logical.Join;
import org.elasticsearch.xpack.eql.plan.logical.KeyedFilter;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class Sequence
extends Join {
    private final TimeValue maxSpan;

    public Sequence(Source source, List<KeyedFilter> queries, KeyedFilter until, TimeValue maxSpan, Attribute timestamp, Attribute tiebreaker, Order.OrderDirection direction) {
        super(source, queries, until, timestamp, tiebreaker, direction);
        this.maxSpan = maxSpan;
    }

    private Sequence(Source source, List<LogicalPlan> queries, LogicalPlan until, TimeValue maxSpan, Attribute timestamp, Attribute tiebreaker, Order.OrderDirection direction) {
        super(source, Sequence.asKeyed(queries), Sequence.asKeyed(until), timestamp, tiebreaker, direction);
        this.maxSpan = maxSpan;
    }

    protected NodeInfo<Sequence> info() {
        return NodeInfo.create((Node)this, Sequence::new, this.queries(), (Object)((Object)this.until()), (Object)this.maxSpan, (Object)this.timestamp(), (Object)this.tiebreaker(), (Object)this.direction());
    }

    @Override
    public Join replaceChildren(List<LogicalPlan> newChildren) {
        if (newChildren.size() < 2) {
            throw new EqlIllegalArgumentException("expected at least [2] children but received [{}]", newChildren.size());
        }
        int lastIndex = newChildren.size() - 1;
        return new Sequence(this.source(), newChildren.subList(0, lastIndex), newChildren.get(lastIndex), this.maxSpan, this.timestamp(), this.tiebreaker(), this.direction());
    }

    public TimeValue maxSpan() {
        return this.maxSpan;
    }

    @Override
    public Join with(List<KeyedFilter> queries, KeyedFilter until, Order.OrderDirection direction) {
        return new Sequence(this.source(), queries, until, this.maxSpan, this.timestamp(), this.tiebreaker(), direction);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.maxSpan, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            Sequence other = (Sequence)((Object)obj);
            return Objects.equals(this.maxSpan, other.maxSpan);
        }
        return false;
    }

    @Override
    public List<Object> nodeProperties() {
        return Arrays.asList(this.maxSpan, this.direction());
    }
}

