/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.predicate.operator.comparison;

import java.time.ZoneId;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.eql.expression.predicate.operator.comparison.InsensitiveBinaryComparisonPipe;
import org.elasticsearch.xpack.eql.expression.predicate.operator.comparison.InsensitiveBinaryComparisonProcessor;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.ql.expression.predicate.PredicateBiFunction;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public abstract class InsensitiveBinaryComparison
extends BinaryOperator<Object, Object, Boolean, InsensitiveBinaryComparisonProcessor.InsensitiveBinaryComparisonOperation> {
    private final ZoneId zoneId;

    protected InsensitiveBinaryComparison(Source source, Expression left, Expression right, InsensitiveBinaryComparisonProcessor.InsensitiveBinaryComparisonOperation operation, ZoneId zoneId) {
        super(source, left, right, (PredicateBiFunction)operation);
        this.zoneId = zoneId;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    protected Expression.TypeResolution resolveInputType(Expression e, Expressions.ParamOrdinal paramOrdinal) {
        String op = ((InsensitiveBinaryComparisonProcessor.InsensitiveBinaryComparisonOperation)this.function()).symbol();
        Expression.TypeResolution resolution = TypeResolutions.isString((Expression)e, (String)op, (Expressions.ParamOrdinal)paramOrdinal);
        if (resolution.unresolved()) {
            String message = LoggerMessageFormat.format(null, (String)"{}; consider using [{}] instead", (Object[])new Object[]{resolution.message(), this.regularOperatorSymbol()});
            resolution = new Expression.TypeResolution(message);
        }
        return resolution;
    }

    protected abstract String regularOperatorSymbol();

    protected Expression canonicalize() {
        return this.left().hashCode() > this.right().hashCode() ? this.swapLeftAndRight() : this;
    }

    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    protected Pipe makePipe() {
        return new InsensitiveBinaryComparisonPipe(this.source(), (Expression)this, Expressions.pipe((Expression)this.left()), Expressions.pipe((Expression)this.right()), (InsensitiveBinaryComparisonProcessor.InsensitiveBinaryComparisonOperation)this.function());
    }
}

