/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.SubstringFunctionPipe;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.SubstringFunctionProcessor;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Substring
extends ScalarFunction
implements OptionalArgument {
    private final Expression input;
    private final Expression start;
    private final Expression end;

    public Substring(Source source, Expression input, Expression start, Expression end) {
        super(source, Arrays.asList(input, start, end != null ? end : new Literal(source, null, DataTypes.NULL)));
        this.input = input;
        this.start = start;
        this.end = (Expression)this.arguments().get(2);
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution sourceResolution = TypeResolutions.isStringAndExact((Expression)this.input, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.FIRST);
        if (sourceResolution.unresolved()) {
            return sourceResolution;
        }
        Expression.TypeResolution startResolution = TypeResolutions.isInteger((Expression)this.start, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.SECOND);
        if (startResolution.unresolved()) {
            return startResolution;
        }
        return TypeResolutions.isInteger((Expression)this.end, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.THIRD);
    }

    protected Pipe makePipe() {
        return new SubstringFunctionPipe(this.source(), (Expression)this, Expressions.pipe((Expression)this.input), Expressions.pipe((Expression)this.start), Expressions.pipe((Expression)this.end));
    }

    public boolean foldable() {
        return this.input.foldable() && this.start.foldable() && this.end.foldable();
    }

    public Object fold() {
        return SubstringFunctionProcessor.doProcess(this.input.fold(), this.start.fold(), this.end.fold());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Substring::new, (Object)this.input, (Object)this.start, (Object)this.end);
    }

    public ScriptTemplate asScript() {
        ScriptTemplate inputScript = this.asScript(this.input);
        ScriptTemplate startScript = this.asScript(this.start);
        ScriptTemplate endScript = this.asScript(this.end);
        return this.asScriptFrom(inputScript, startScript, endScript);
    }

    protected ScriptTemplate asScriptFrom(ScriptTemplate inputScript, ScriptTemplate startScript, ScriptTemplate endScript) {
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{eql}.%s(%s,%s,%s)"), "substring", inputScript.template(), startScript.template(), endScript.template()), ParamsBuilder.paramsBuilder().script(inputScript.params()).script(startScript.params()).script(endScript.params()).build(), this.dataType());
    }

    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable((Object)field.exactAttribute().name()).build(), this.dataType());
    }

    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 3) {
            throw new IllegalArgumentException("expected [3] children but received [" + newChildren.size() + "]");
        }
        return new Substring(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }
}

