/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.util.Locale;
import org.elasticsearch.common.Strings;

final class StringUtils {
    private StringUtils() {
    }

    static String between(String string, String left, String right, boolean greedy, boolean caseSensitive) {
        int idx;
        if (!(Strings.hasLength((String)string) && Strings.hasLength((String)left) && Strings.hasLength((String)right))) {
            return string;
        }
        String matchString = string;
        if (!caseSensitive) {
            matchString = matchString.toLowerCase(Locale.ROOT);
            left = left.toLowerCase(Locale.ROOT);
            right = right.toLowerCase(Locale.ROOT);
        }
        if ((idx = matchString.indexOf(left)) == -1) {
            return "";
        }
        int start = idx + left.length();
        idx = greedy ? matchString.lastIndexOf(right) : matchString.indexOf(right, start);
        if (idx == -1) {
            return "";
        }
        return string.substring(start, idx);
    }

    static boolean stringContains(String string, String substring, boolean isCaseSensitive) {
        if (!Strings.hasLength((String)string) || !Strings.hasLength((String)substring)) {
            return false;
        }
        if (!isCaseSensitive) {
            string = string.toLowerCase(Locale.ROOT);
            substring = substring.toLowerCase(Locale.ROOT);
        }
        return string.contains(substring);
    }

    static String substringSlice(String string, int start, int end) {
        if (!Strings.hasLength((String)string)) {
            return string;
        }
        int length = string.length();
        if (start < 0) {
            start += length;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end += length;
        }
        if (end < 0) {
            end = 0;
        } else if (end > length) {
            end = length;
        }
        if (start >= end) {
            return "";
        }
        return Strings.substring((String)string, (int)start, (int)end);
    }
}

