/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.BaseSurrogateFunction;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.predicate.regex.RLike;
import org.elasticsearch.xpack.ql.expression.predicate.regex.RLikePattern;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public class Match
extends BaseSurrogateFunction {
    private final Expression field = (Expression)this.children().get(0);
    private final List<Expression> patterns = this.children().subList(1, this.children().size());

    public Match(Source source, Expression field, List<Expression> patterns) {
        this(source, CollectionUtils.combine(Collections.singletonList(field), patterns));
    }

    private Match(Source source, List<Expression> children) {
        super(source, children);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Match::new, (Object)this.field, this.patterns);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() < 2) {
            throw new IllegalArgumentException("expected at least [2] children but received [" + newChildren.size() + "]");
        }
        return new Match(this.source(), newChildren);
    }

    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isStringAndExact((Expression)this.field, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        int index = 1;
        for (Expression regex : this.patterns) {
            resolution = TypeResolutions.isStringAndExact((Expression)regex, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.fromIndex((int)index));
            if (resolution.unresolved()) {
                return resolution;
            }
            resolution = TypeResolutions.isFoldable((Expression)regex, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.fromIndex((int)index));
            if (resolution.unresolved()) break;
            ++index;
        }
        return resolution;
    }

    public ScalarFunction makeSubstitute() {
        ArrayList<String> patternStrings = new ArrayList<String>(this.patterns.size());
        for (Expression regex : this.patterns) {
            patternStrings.add(regex.fold().toString());
        }
        return new RLike(this.source(), this.field, new RLikePattern(String.join((CharSequence)"|", patternStrings)));
    }
}

