/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.EndsWithFunctionProcessor;
import org.elasticsearch.xpack.ql.execution.search.QlSourceBuilder;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class EndsWithFunctionPipe
extends Pipe {
    private final Pipe input;
    private final Pipe pattern;
    private final boolean isCaseSensitive;

    public EndsWithFunctionPipe(Source source, Expression expression, Pipe input, Pipe pattern, boolean isCaseSensitive) {
        super(source, expression, Arrays.asList(input, pattern));
        this.input = input;
        this.pattern = pattern;
        this.isCaseSensitive = isCaseSensitive;
    }

    public final Pipe replaceChildren(List<Pipe> newChildren) {
        if (newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        return this.replaceChildren(newChildren.get(0), newChildren.get(1));
    }

    public final Pipe resolveAttributes(Pipe.AttributeResolver resolver) {
        Pipe newInput = this.input.resolveAttributes(resolver);
        Pipe newPattern = this.pattern.resolveAttributes(resolver);
        if (newInput == this.input && newPattern == this.pattern) {
            return this;
        }
        return this.replaceChildren(newInput, newPattern);
    }

    public boolean supportedByAggsOnlyQuery() {
        return this.input.supportedByAggsOnlyQuery() && this.pattern.supportedByAggsOnlyQuery();
    }

    public boolean resolved() {
        return this.input.resolved() && this.pattern.resolved();
    }

    protected EndsWithFunctionPipe replaceChildren(Pipe newInput, Pipe newPattern) {
        return new EndsWithFunctionPipe(this.source(), this.expression(), newInput, newPattern, this.isCaseSensitive);
    }

    public final void collectFields(QlSourceBuilder sourceBuilder) {
        this.input.collectFields(sourceBuilder);
        this.pattern.collectFields(sourceBuilder);
    }

    protected NodeInfo<EndsWithFunctionPipe> info() {
        return NodeInfo.create((Node)this, EndsWithFunctionPipe::new, (Object)this.expression(), (Object)this.input, (Object)this.pattern, (Object)this.isCaseSensitive);
    }

    public EndsWithFunctionProcessor asProcessor() {
        return new EndsWithFunctionProcessor(this.input.asProcessor(), this.pattern.asProcessor(), this.isCaseSensitive);
    }

    public Pipe input() {
        return this.input;
    }

    public Pipe pattern() {
        return this.pattern;
    }

    protected boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public int hashCode() {
        return Objects.hash(this.input, this.pattern, this.isCaseSensitive);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EndsWithFunctionPipe other = (EndsWithFunctionPipe)((Object)obj);
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.pattern(), other.pattern()) && Objects.equals(this.isCaseSensitive(), other.isCaseSensitive());
    }
}

