/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.CIDRUtils;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.util.Check;

public class CIDRMatchFunctionProcessor
implements Processor {
    public static final String NAME = "cdrm";
    private final Processor source;
    private final List<Processor> addresses;

    public CIDRMatchFunctionProcessor(Processor source, List<Processor> addresses) {
        this.source = source;
        this.addresses = addresses;
    }

    public CIDRMatchFunctionProcessor(StreamInput in) throws IOException {
        this.source = (Processor)in.readNamedWriteable(Processor.class);
        this.addresses = in.readNamedWriteableList(Processor.class);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.source);
        out.writeNamedWriteableList(this.addresses);
    }

    public String getWriteableName() {
        return NAME;
    }

    public Object process(Object input) {
        Object src = this.source.process(input);
        ArrayList<Object> arr = new ArrayList<Object>(this.addresses.size());
        for (Processor address : this.addresses) {
            arr.add(address.process(input));
        }
        return CIDRMatchFunctionProcessor.doProcess(src, arr);
    }

    public static Object doProcess(Object source, List<Object> addresses) {
        if (source == null) {
            return null;
        }
        Check.isString((Object)source);
        String[] arr = new String[addresses.size()];
        int i = 0;
        for (Object address : addresses) {
            Check.isString((Object)address);
            arr[i++] = (String)address;
        }
        return CIDRUtils.isInRange((String)source, arr);
    }

    protected Processor source() {
        return this.source;
    }

    public List<Processor> addresses() {
        return this.addresses;
    }

    public int hashCode() {
        return Objects.hash(this.source(), this.addresses());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CIDRMatchFunctionProcessor other = (CIDRMatchFunctionProcessor)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.addresses(), other.addresses());
    }
}

