/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.CIDRMatchFunctionPipe;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.CIDRMatchFunctionProcessor;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public class CIDRMatch
extends ScalarFunction {
    private final Expression input;
    private final List<Expression> addresses;

    public CIDRMatch(Source source, Expression input, List<Expression> addresses) {
        super(source, CollectionUtils.combine(Collections.singletonList(input), addresses == null ? Collections.emptyList() : addresses));
        this.input = input;
        this.addresses = addresses == null ? Collections.emptyList() : addresses;
    }

    public Expression input() {
        return this.input;
    }

    public List<Expression> addresses() {
        return this.addresses;
    }

    protected Expression.TypeResolution resolveType() {
        Expression addr;
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isIPAndExact((Expression)this.input, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        int index = 1;
        Iterator<Expression> iterator = this.addresses.iterator();
        while (iterator.hasNext() && !(resolution = TypeResolutions.isFoldable((Expression)(addr = iterator.next()), (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.fromIndex((int)index))).unresolved() && !(resolution = TypeResolutions.isStringAndExact((Expression)addr, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.fromIndex((int)index))).unresolved()) {
            ++index;
        }
        return resolution;
    }

    protected Pipe makePipe() {
        return new CIDRMatchFunctionPipe(this.source(), (Expression)this, Expressions.pipe((Expression)this.input), Expressions.pipe(this.addresses));
    }

    public boolean foldable() {
        return this.input.foldable() && Expressions.foldable(this.addresses);
    }

    public Object fold() {
        return CIDRMatchFunctionProcessor.doProcess(this.input.fold(), Expressions.fold(this.addresses));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, CIDRMatch::new, (Object)this.input, this.addresses);
    }

    public ScriptTemplate asScript() {
        ScriptTemplate leftScript = this.asScript(this.input);
        ArrayList values = new ArrayList(new LinkedHashSet(Expressions.fold(this.addresses)));
        return new ScriptTemplate(this.formatTemplate(LoggerMessageFormat.format((String)"{eql}.", (String)"cidrMatch({}, {})", (Object[])new Object[]{leftScript.template()})), ParamsBuilder.paramsBuilder().script(leftScript.params()).variable(values).build(), this.dataType());
    }

    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable((Object)field.exactAttribute().name()).build(), this.dataType());
    }

    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() < 2) {
            throw new IllegalArgumentException("expected at least [2] children but received [" + newChildren.size() + "]");
        }
        return new CIDRMatch(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }
}

