/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sequence;

import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.eql.execution.assembler.BoxedQueryRequest;
import org.elasticsearch.xpack.eql.execution.assembler.Criterion;
import org.elasticsearch.xpack.eql.execution.assembler.Executable;
import org.elasticsearch.xpack.eql.execution.search.HitReference;
import org.elasticsearch.xpack.eql.execution.search.Ordinal;
import org.elasticsearch.xpack.eql.execution.search.QueryClient;
import org.elasticsearch.xpack.eql.execution.search.RuntimeUtils;
import org.elasticsearch.xpack.eql.execution.sequence.KeyAndOrdinal;
import org.elasticsearch.xpack.eql.execution.sequence.Sequence;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceKey;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceMatcher;
import org.elasticsearch.xpack.eql.execution.sequence.SequencePayload;
import org.elasticsearch.xpack.eql.session.EmptyPayload;
import org.elasticsearch.xpack.eql.session.Payload;
import org.elasticsearch.xpack.eql.util.ReversedIterator;
import org.elasticsearch.xpack.ql.util.ActionListeners;

public class TumblingWindow
implements Executable {
    private final Logger log = LogManager.getLogger(TumblingWindow.class);
    private final QueryClient client;
    private final List<Criterion<BoxedQueryRequest>> criteria;
    private final Criterion<BoxedQueryRequest> until;
    private final SequenceMatcher matcher;
    private final int maxStages;
    private final int windowSize;
    private long startTime;

    public TumblingWindow(QueryClient client, List<Criterion<BoxedQueryRequest>> criteria, Criterion<BoxedQueryRequest> until, SequenceMatcher matcher) {
        this.client = client;
        this.until = until;
        this.criteria = criteria;
        this.maxStages = criteria.size();
        this.windowSize = criteria.get(0).queryRequest().searchSource().size();
        this.matcher = matcher;
    }

    @Override
    public void execute(ActionListener<Payload> listener) {
        this.log.trace("Starting sequence window w/ fetch size [{}]", (Object)this.windowSize);
        this.startTime = System.currentTimeMillis();
        this.advance(0, listener);
    }

    private void advance(int baseStage, ActionListener<Payload> listener) {
        Criterion<BoxedQueryRequest> base = this.criteria.get(baseStage);
        base.queryRequest().to(null);
        this.matcher.resetInsertPosition();
        this.log.trace("{}", (Object)this.matcher);
        this.log.trace("Querying base stage [{}] {}", (Object)base.stage(), (Object)base.queryRequest());
        this.client.query(base.queryRequest(), (ActionListener<SearchResponse>)ActionListener.wrap(p -> this.baseCriterion(baseStage, (SearchResponse)p, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void baseCriterion(int baseStage, SearchResponse r, ActionListener<Payload> listener) {
        Criterion<BoxedQueryRequest> base = this.criteria.get(baseStage);
        List<SearchHit> hits = RuntimeUtils.searchHits(r);
        this.log.trace("Found [{}] hits", (Object)hits.size());
        Ordinal begin = null;
        Ordinal end = null;
        if (!hits.isEmpty()) {
            if (!this.matcher.match(baseStage, this.wrapValues(base, hits))) {
                this.payload(listener);
                return;
            }
            begin = base.ordinal(hits.get(0));
            end = base.ordinal(hits.get(hits.size() - 1));
            this.log.trace("Found base [{}] window {}->{}", (Object)base.stage(), (Object)begin, (Object)end);
        }
        if (hits.size() < 2) {
            if (this.matcher.hasCandidates(baseStage) && baseStage + 1 < this.maxStages) {
                Runnable next = () -> this.advance(baseStage + 1, listener);
                if (this.until != null && hits.size() == 1) {
                    this.untilCriterion(new WindowInfo(baseStage, begin, end), listener, next);
                } else {
                    next.run();
                }
            } else {
                this.payload(listener);
            }
            return;
        }
        base.queryRequest().nextAfter(end);
        WindowInfo info = new WindowInfo(baseStage, begin, end);
        if (baseStage + 1 < this.maxStages) {
            Runnable next = () -> this.secondaryCriterion(info, baseStage + 1, listener);
            if (this.until != null) {
                this.untilCriterion(info, listener, next);
            } else {
                next.run();
            }
        } else {
            this.advance(baseStage, listener);
        }
    }

    private void untilCriterion(WindowInfo window, ActionListener<Payload> listener, Runnable next) {
        BoxedQueryRequest request = this.until.queryRequest();
        this.matcher.dropUntil();
        boolean reversed = this.boxQuery(window, this.until);
        this.log.trace("Querying until stage {}", (Object)request);
        this.client.query(request, (ActionListener<SearchResponse>)ActionListener.wrap(r -> {
            List<SearchHit> hits = RuntimeUtils.searchHits(r);
            this.log.trace("Found [{}] hits", (Object)hits.size());
            if (hits.isEmpty()) {
                if (reversed) {
                    request.to(window.end);
                } else {
                    request.from(window.end);
                }
            } else {
                request.nextAfter(this.until.ordinal(hits.get(hits.size() - 1)));
                this.matcher.until(this.wrapUntilValues(this.wrapValues(this.until, hits)));
            }
            if (hits.size() == this.windowSize) {
                this.untilCriterion(window, listener, next);
            } else {
                next.run();
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void secondaryCriterion(WindowInfo window, int currentStage, ActionListener<Payload> listener) {
        Criterion<BoxedQueryRequest> criterion = this.criteria.get(currentStage);
        BoxedQueryRequest request = criterion.queryRequest();
        boolean reversed = this.boxQuery(window, criterion);
        this.log.trace("Querying (secondary) stage [{}] {}", (Object)criterion.stage(), (Object)request);
        this.client.query(request, (ActionListener<SearchResponse>)ActionListener.wrap(r -> {
            Ordinal boundary = reversed ? window.begin : window.end;
            List<SearchHit> hits = RuntimeUtils.searchHits(r);
            hits = this.trim(hits, criterion, boundary, reversed);
            this.log.trace("Found [{}] hits", (Object)hits.size());
            if (hits.isEmpty()) {
                if (reversed) {
                    request.from(window.end);
                } else {
                    request.to(window.end);
                }
                if (!this.matcher.hasCandidates(criterion.stage())) {
                    this.log.trace("Advancing window...");
                    this.advance(window.baseStage, listener);
                    return;
                }
            } else {
                Ordinal next = criterion.ordinal(hits.get(hits.size() - 1));
                this.log.trace("Found range [{}] -> [{}]", (Object)criterion.ordinal(hits.get(0)), (Object)next);
                if (next.after(boundary)) {
                    next = boundary;
                }
                request.nextAfter(next);
                if (!this.matcher.match(criterion.stage(), this.wrapValues(criterion, hits))) {
                    this.payload(listener);
                    return;
                }
            }
            if (hits.size() == this.windowSize && request.after().before(boundary)) {
                this.secondaryCriterion(window, currentStage, listener);
            } else if (currentStage + 1 < this.maxStages) {
                this.secondaryCriterion(window, currentStage + 1, listener);
            } else {
                this.advance(window.baseStage, listener);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private List<SearchHit> trim(List<SearchHit> searchHits, Criterion<BoxedQueryRequest> criterion, Ordinal boundary, boolean reversed) {
        int offset = 0;
        for (int i = searchHits.size() - 1; i >= 0; --i) {
            boolean withinBoundaries;
            Ordinal ordinal = criterion.ordinal(searchHits.get(i));
            boolean bl = withinBoundaries = reversed ? ordinal.afterOrAt(boundary) : ordinal.beforeOrAt(boundary);
            if (withinBoundaries) break;
            ++offset;
        }
        return offset == 0 ? searchHits : searchHits.subList(0, searchHits.size() - offset);
    }

    private boolean boxQuery(WindowInfo window, Criterion<BoxedQueryRequest> criterion) {
        boolean reverse;
        BoxedQueryRequest request = criterion.queryRequest();
        Criterion<BoxedQueryRequest> base = this.criteria.get(window.baseStage);
        boolean bl = reverse = criterion.reverse() != base.reverse();
        if (reverse) {
            if (!window.end.equals(request.from())) {
                request.from(window.end);
                request.nextAfter(window.end);
            }
        } else {
            request.to(window.end);
            if (request.after() == null) {
                request.nextAfter(window.begin);
            }
        }
        return reverse;
    }

    private void payload(ActionListener<Payload> listener) {
        List<Sequence> completed = this.matcher.completed();
        this.log.trace("Sending payload for [{}] sequences", (Object)completed.size());
        if (completed.isEmpty()) {
            listener.onResponse((Object)new EmptyPayload(Payload.Type.SEQUENCE, this.timeTook()));
            this.close(listener);
            return;
        }
        this.client.fetchHits(this.hits(completed), (ActionListener<List<List<SearchHit>>>)ActionListeners.map(listener, listOfHits -> {
            SequencePayload payload = new SequencePayload(completed, (List<List<SearchHit>>)listOfHits, false, this.timeTook());
            this.close(listener);
            return payload;
        }));
    }

    private void close(ActionListener<Payload> listener) {
        this.matcher.clear();
        this.client.close((ActionListener<Boolean>)ActionListener.delegateFailure(listener, (l, r) -> {}));
    }

    private TimeValue timeTook() {
        return new TimeValue(System.currentTimeMillis() - this.startTime);
    }

    Iterable<List<HitReference>> hits(List<Sequence> sequences) {
        return () -> {
            final Iterator<Object> delegate = this.criteria.get(0).reverse() != this.criteria.get(1).reverse() ? new ReversedIterator(sequences) : sequences.iterator();
            return new Iterator<List<HitReference>>(){

                @Override
                public boolean hasNext() {
                    return delegate.hasNext();
                }

                @Override
                public List<HitReference> next() {
                    return ((Sequence)delegate.next()).hits();
                }
            };
        };
    }

    Iterable<Tuple<KeyAndOrdinal, HitReference>> wrapValues(final Criterion<?> criterion, List<SearchHit> hits) {
        return () -> {
            final Iterator<Object> delegate = criterion.reverse() ? new ReversedIterator(hits) : hits.iterator();
            return new Iterator<Tuple<KeyAndOrdinal, HitReference>>(){

                @Override
                public boolean hasNext() {
                    return delegate.hasNext();
                }

                @Override
                public Tuple<KeyAndOrdinal, HitReference> next() {
                    SearchHit hit = (SearchHit)delegate.next();
                    SequenceKey k = criterion.key(hit);
                    Ordinal o = criterion.ordinal(hit);
                    return new Tuple((Object)new KeyAndOrdinal(k, o), (Object)new HitReference(hit));
                }
            };
        };
    }

    <E> Iterable<KeyAndOrdinal> wrapUntilValues(Iterable<Tuple<KeyAndOrdinal, E>> iterable) {
        return () -> {
            final Iterator delegate = iterable.iterator();
            return new Iterator<KeyAndOrdinal>(){

                @Override
                public boolean hasNext() {
                    return delegate.hasNext();
                }

                @Override
                public KeyAndOrdinal next() {
                    return (KeyAndOrdinal)((Tuple)delegate.next()).v1();
                }
            };
        };
    }

    private static class WindowInfo {
        private final int baseStage;
        private final Ordinal begin;
        private final Ordinal end;

        WindowInfo(int baseStage, Ordinal begin, Ordinal end) {
            this.baseStage = baseStage;
            this.begin = begin;
            this.end = end;
        }
    }
}

