/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.sequence;

import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.eql.execution.search.Ordinal;
import org.elasticsearch.xpack.eql.execution.sequence.KeyAndOrdinal;
import org.elasticsearch.xpack.eql.execution.sequence.Sequence;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceGroup;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceKey;
import org.elasticsearch.xpack.eql.execution.sequence.UntilGroup;

class KeyToSequences {
    private final int listSize;
    private final Map<SequenceKey, SequenceGroup[]> keyToSequences;
    private final Map<SequenceKey, UntilGroup> keyToUntil;

    KeyToSequences(int listSize) {
        this.listSize = listSize;
        this.keyToSequences = new LinkedHashMap<SequenceKey, SequenceGroup[]>();
        this.keyToUntil = new LinkedHashMap<SequenceKey, UntilGroup>();
    }

    private SequenceGroup[] groups(SequenceKey key) {
        return this.keyToSequences.computeIfAbsent(key, k -> new SequenceGroup[this.listSize]);
    }

    SequenceGroup groupIfPresent(int stage, SequenceKey key) {
        SequenceGroup[] groups = this.keyToSequences.get(key);
        return groups == null ? null : groups[stage];
    }

    UntilGroup untilIfPresent(SequenceKey key) {
        return this.keyToUntil.get(key);
    }

    void add(int stage, Sequence sequence) {
        SequenceKey key = sequence.key();
        SequenceGroup[] groups = this.groups(key);
        if (groups[stage] == null) {
            groups[stage] = new SequenceGroup(key);
        }
        groups[stage].add(sequence);
    }

    void resetGroupInsertPosition() {
        for (SequenceGroup[] groups : this.keyToSequences.values()) {
            for (SequenceGroup group : groups) {
                if (group == null) continue;
                group.resetInsertPosition();
            }
        }
    }

    void resetUntilInsertPosition() {
        for (UntilGroup until : this.keyToUntil.values()) {
            if (until == null) continue;
            until.resetInsertPosition();
        }
    }

    void until(Iterable<KeyAndOrdinal> until) {
        for (KeyAndOrdinal keyAndOrdinal : until) {
            SequenceKey key = keyAndOrdinal.key();
            if (!this.keyToSequences.containsKey(key)) continue;
            UntilGroup group = this.keyToUntil.computeIfAbsent(key, UntilGroup::new);
            group.add(keyAndOrdinal);
        }
    }

    void remove(int stage, SequenceGroup group) {
        SequenceKey key = group.key();
        SequenceGroup[] groups = this.keyToSequences.get(key);
        groups[stage] = null;
        boolean shouldRemoveKey = true;
        for (SequenceGroup gp : groups) {
            if (gp == null || gp.isEmpty()) continue;
            shouldRemoveKey = false;
            break;
        }
        if (shouldRemoveKey) {
            this.keyToSequences.remove(key);
        }
    }

    void dropUntil() {
        for (Map.Entry<SequenceKey, UntilGroup> entry : this.keyToUntil.entrySet()) {
            SequenceGroup[] groups = this.keyToSequences.get(entry.getKey());
            if (groups == null) continue;
            for (Ordinal o : entry.getValue()) {
                for (SequenceGroup group : groups) {
                    if (group == null) continue;
                    group.trimBefore(o);
                }
            }
        }
        this.keyToUntil.clear();
    }

    public void clear() {
        this.keyToSequences.clear();
        this.keyToUntil.clear();
    }

    int numberOfKeys() {
        return this.keyToSequences.size();
    }

    public String toString() {
        return LoggerMessageFormat.format(null, (String)"Keys=[{}], Until=[{}]", (Object[])new Object[]{this.keyToSequences.size(), this.keyToUntil.size()});
    }
}

