/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.search;

import java.util.Objects;

public class Ordinal
implements Comparable<Ordinal> {
    private final long timestamp;
    private final Comparable<Object> tiebreaker;

    public Ordinal(long timestamp, Comparable<Object> tiebreaker) {
        this.timestamp = timestamp;
        this.tiebreaker = tiebreaker;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Comparable<Object> tiebreaker() {
        return this.tiebreaker;
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.tiebreaker);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Ordinal other = (Ordinal)obj;
        return Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.tiebreaker, other.tiebreaker);
    }

    public String toString() {
        return "[" + this.timestamp + "][" + (this.tiebreaker != null ? this.tiebreaker.toString() : "") + "]";
    }

    @Override
    public int compareTo(Ordinal o) {
        if (this.timestamp < o.timestamp) {
            return -1;
        }
        if (this.timestamp == o.timestamp) {
            if (this.tiebreaker != null) {
                if (o.tiebreaker != null) {
                    return this.tiebreaker.compareTo(o.tiebreaker);
                }
            } else {
                if (o.tiebreaker != null) {
                    return -1;
                }
                return 0;
            }
        }
        return 1;
    }

    public boolean between(Ordinal left, Ordinal right) {
        return this.compareTo(left) <= 0 && this.compareTo(right) >= 0 || this.compareTo(right) <= 0 && this.compareTo(left) >= 0;
    }

    public boolean before(Ordinal other) {
        return this.compareTo(other) < 0;
    }

    public boolean beforeOrAt(Ordinal other) {
        return this.compareTo(other) <= 0;
    }

    public boolean after(Ordinal other) {
        return this.compareTo(other) > 0;
    }

    public boolean afterOrAt(Ordinal other) {
        return this.compareTo(other) >= 0;
    }

    public Object[] toArray() {
        Object[] objectArray;
        if (this.tiebreaker != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = this.timestamp;
            objectArray = objectArray2;
            objectArray2[1] = this.tiebreaker;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = this.timestamp;
        }
        return objectArray;
    }
}

