/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.assembler;

import java.util.List;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.execution.search.Ordinal;
import org.elasticsearch.xpack.eql.execution.search.QueryRequest;
import org.elasticsearch.xpack.eql.execution.sequence.SequenceKey;
import org.elasticsearch.xpack.ql.execution.search.extractor.HitExtractor;

public class Criterion<Q extends QueryRequest> {
    private final int stage;
    private final Q queryRequest;
    private final List<HitExtractor> keys;
    private final HitExtractor timestamp;
    private final HitExtractor tiebreaker;
    private final boolean reverse;

    Criterion(int stage, Q queryRequest, List<HitExtractor> keys, HitExtractor timestamp, HitExtractor tiebreaker, boolean reverse) {
        this.stage = stage;
        this.queryRequest = queryRequest;
        this.keys = keys;
        this.timestamp = timestamp;
        this.tiebreaker = tiebreaker;
        this.reverse = reverse;
    }

    public int stage() {
        return this.stage;
    }

    public boolean reverse() {
        return this.reverse;
    }

    public Q queryRequest() {
        return this.queryRequest;
    }

    public SequenceKey key(SearchHit hit) {
        SequenceKey key;
        if (this.keys.isEmpty()) {
            key = SequenceKey.NONE;
        } else {
            Object[] docKeys = new Object[this.keys.size()];
            for (int i = 0; i < docKeys.length; ++i) {
                docKeys[i] = this.keys.get(i).extract(hit);
            }
            key = new SequenceKey(docKeys);
        }
        return key;
    }

    public Ordinal ordinal(SearchHit hit) {
        Object ts = this.timestamp.extract(hit);
        if (!(ts instanceof Number)) {
            throw new EqlIllegalArgumentException("Expected timestamp as long but got {}", ts);
        }
        long timestamp = ((Number)ts).longValue();
        Comparable tbreaker = null;
        if (this.tiebreaker != null) {
            Object tb = this.tiebreaker.extract(hit);
            if (!(tb instanceof Comparable)) {
                throw new EqlIllegalArgumentException("Expected tiebreaker to be Comparable but got {}", tb);
            }
            tbreaker = (Comparable)tb;
        }
        return new Ordinal(timestamp, tbreaker);
    }

    public String toString() {
        return "[" + this.stage + "][" + this.reverse + "]";
    }
}

