/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.analysis;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.eql.plan.logical.Head;
import org.elasticsearch.xpack.eql.plan.logical.Join;
import org.elasticsearch.xpack.eql.plan.logical.Sequence;
import org.elasticsearch.xpack.eql.plan.logical.Tail;
import org.elasticsearch.xpack.eql.stats.FeatureMetric;
import org.elasticsearch.xpack.eql.stats.Metrics;
import org.elasticsearch.xpack.ql.capabilities.Unresolvable;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.StringUtils;

public class Verifier {
    private final Metrics metrics;

    public Verifier(Metrics metrics) {
        this.metrics = metrics;
    }

    public Map<Node<?>, String> verifyFailures(LogicalPlan plan) {
        Collection<Failure> failures = this.verify(plan);
        return failures.stream().collect(Collectors.toMap(Failure::node, Failure::message));
    }

    Collection<Failure> verify(LogicalPlan plan) {
        LinkedHashSet<Failure> failures = new LinkedHashSet<Failure>();
        plan.forEachUp(p -> {
            if (p.analyzed()) {
                return;
            }
            if (!p.childrenResolved()) {
                return;
            }
            LinkedHashSet<Failure> localFailures = new LinkedHashSet<Failure>();
            if (p instanceof Unresolvable) {
                localFailures.add(Failure.fail((Node)p, (String)((Unresolvable)p).unresolvedMessage(), (Object[])new Object[0]));
            } else {
                p.forEachExpressions(e -> {
                    if (e.resolved()) {
                        return;
                    }
                    e.forEachUp(ae -> {
                        if (!ae.childrenResolved()) {
                            return;
                        }
                        if (ae instanceof Unresolvable) {
                            UnresolvedAttribute ua;
                            if (ae instanceof UnresolvedAttribute && !(ua = (UnresolvedAttribute)ae).customMessage()) {
                                boolean useQualifier = ua.qualifier() != null;
                                ArrayList<String> potentialMatches = new ArrayList<String>();
                                for (Attribute a : p.inputSet()) {
                                    String nameCandidate;
                                    String string = nameCandidate = useQualifier ? a.qualifiedName() : a.name();
                                    if (DataTypes.isUnsupported((DataType)a.dataType()) || !DataTypes.isPrimitive((DataType)a.dataType())) continue;
                                    potentialMatches.add(nameCandidate);
                                }
                                List matches = StringUtils.findSimilar((String)ua.qualifiedName(), potentialMatches);
                                if (!matches.isEmpty()) {
                                    ae = ua.withUnresolvedMessage(UnresolvedAttribute.errorMessage((String)ua.qualifiedName(), (List)matches));
                                }
                            }
                            localFailures.add(Failure.fail((Node)ae, (String)((Unresolvable)ae).unresolvedMessage(), (Object[])new Object[0]));
                            return;
                        }
                        if (ae.typeResolved().unresolved()) {
                            localFailures.add(Failure.fail((Node)ae, (String)ae.typeResolved().message(), (Object[])new Object[0]));
                        }
                    });
                });
            }
            failures.addAll(localFailures);
        });
        if (failures.isEmpty()) {
            plan.forEachDown(p -> {
                LinkedHashSet localFailures = new LinkedHashSet();
                failures.addAll(localFailures);
                if (failures.isEmpty()) {
                    p.setAnalyzed();
                }
            });
        }
        if (failures.isEmpty()) {
            BitSet b = new BitSet(FeatureMetric.values().length);
            plan.forEachDown(p -> {
                if (p instanceof Head) {
                    b.set(FeatureMetric.PIPE_HEAD.ordinal());
                } else if (p instanceof Tail) {
                    b.set(FeatureMetric.PIPE_TAIL.ordinal());
                } else if (p instanceof Join) {
                    Join j = (Join)((Object)p);
                    if (p instanceof Sequence) {
                        b.set(FeatureMetric.SEQUENCE.ordinal());
                        Sequence s = (Sequence)((Object)p);
                        if (s.maxSpan().duration() > 0L) {
                            b.set(FeatureMetric.SEQUENCE_MAXSPAN.ordinal());
                        }
                        int queriesCount = s.queries().size();
                        switch (queriesCount) {
                            case 2: {
                                b.set(FeatureMetric.SEQUENCE_QUERIES_TWO.ordinal());
                                break;
                            }
                            case 3: {
                                b.set(FeatureMetric.SEQUENCE_QUERIES_THREE.ordinal());
                                break;
                            }
                            case 4: {
                                b.set(FeatureMetric.SEQUENCE_QUERIES_FOUR.ordinal());
                                break;
                            }
                            default: {
                                b.set(FeatureMetric.SEQUENCE_QUERIES_FIVE_OR_MORE.ordinal());
                            }
                        }
                        if (!j.until().keys().isEmpty()) {
                            b.set(FeatureMetric.SEQUENCE_UNTIL.ordinal());
                        }
                    } else {
                        b.set(FeatureMetric.JOIN.ordinal());
                        int queriesCount = j.queries().size();
                        switch (queriesCount) {
                            case 2: {
                                b.set(FeatureMetric.JOIN_QUERIES_TWO.ordinal());
                                break;
                            }
                            case 3: {
                                b.set(FeatureMetric.JOIN_QUERIES_THREE.ordinal());
                                break;
                            }
                            case 4: {
                                b.set(FeatureMetric.JOIN_QUERIES_FOUR.ordinal());
                                break;
                            }
                            default: {
                                b.set(FeatureMetric.JOIN_QUERIES_FIVE_OR_MORE.ordinal());
                            }
                        }
                        if (!j.until().keys().isEmpty()) {
                            b.set(FeatureMetric.JOIN_UNTIL.ordinal());
                        }
                    }
                    int joinKeysCount = j.queries().get(0).keys().size();
                    switch (joinKeysCount) {
                        case 1: {
                            b.set(FeatureMetric.JOIN_KEYS_ONE.ordinal());
                            break;
                        }
                        case 2: {
                            b.set(FeatureMetric.JOIN_KEYS_TWO.ordinal());
                            break;
                        }
                        case 3: {
                            b.set(FeatureMetric.JOIN_KEYS_THREE.ordinal());
                            break;
                        }
                        case 4: {
                            b.set(FeatureMetric.JOIN_KEYS_FOUR.ordinal());
                            break;
                        }
                        default: {
                            if (joinKeysCount < 5) break;
                            b.set(FeatureMetric.JOIN_KEYS_FIVE_OR_MORE.ordinal());
                        }
                    }
                }
            });
            if (!b.get(FeatureMetric.SEQUENCE.ordinal()) && !b.get(FeatureMetric.JOIN.ordinal())) {
                b.set(FeatureMetric.EVENT.ordinal());
            }
            int i = b.nextSetBit(0);
            while (i >= 0) {
                this.metrics.inc(FeatureMetric.values()[i]);
                i = b.nextSetBit(i + 1);
            }
        }
        return failures;
    }
}

