/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.analysis;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.elasticsearch.xpack.eql.analysis.AnalysisUtils;
import org.elasticsearch.xpack.eql.analysis.AnalyzerRule;
import org.elasticsearch.xpack.eql.analysis.VerificationException;
import org.elasticsearch.xpack.eql.analysis.Verifier;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Node;

public class Analyzer
extends RuleExecutor<LogicalPlan> {
    private final Configuration configuration;
    private final FunctionRegistry functionRegistry;
    private final Verifier verifier;

    public Analyzer(Configuration configuration, FunctionRegistry functionRegistry, Verifier verifier) {
        this.configuration = configuration;
        this.functionRegistry = functionRegistry;
        this.verifier = verifier;
    }

    protected Iterable<RuleExecutor.Batch> batches() {
        RuleExecutor.Batch resolution = new RuleExecutor.Batch((RuleExecutor)this, "Resolution", new Rule[]{new ResolveRefs(), new ResolveFunctions()});
        return Collections.singletonList(resolution);
    }

    public LogicalPlan analyze(LogicalPlan plan) {
        return this.verify((LogicalPlan)this.execute((Node)plan));
    }

    private LogicalPlan verify(LogicalPlan plan) {
        Collection<Failure> failures = this.verifier.verify(plan);
        if (!failures.isEmpty()) {
            throw new VerificationException(failures);
        }
        return plan;
    }

    private static class ResolveRefs
    extends AnalyzerRule<LogicalPlan> {
        private ResolveRefs() {
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            if (!plan.childrenResolved()) {
                return plan;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Attempting to resolve {}", (Object)plan.nodeString());
            }
            return (LogicalPlan)plan.transformExpressionsUp(e -> {
                if (e instanceof UnresolvedAttribute) {
                    UnresolvedAttribute u = (UnresolvedAttribute)e;
                    LinkedHashSet<Attribute> childrenOutput = new LinkedHashSet<Attribute>();
                    for (LogicalPlan child : plan.children()) {
                        childrenOutput.addAll(child.output());
                    }
                    Attribute named = AnalysisUtils.resolveAgainstList(u, childrenOutput);
                    if (named != null) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Resolved {} to {}", (Object)u, (Object)named);
                        }
                        return named;
                    }
                }
                return e;
            });
        }
    }

    private class ResolveFunctions
    extends AnalyzerRule<LogicalPlan> {
        private ResolveFunctions() {
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            return (LogicalPlan)plan.transformExpressionsUp(e -> {
                if (e instanceof UnresolvedFunction) {
                    UnresolvedFunction uf = (UnresolvedFunction)e;
                    if (uf.analyzed()) {
                        return uf;
                    }
                    String name = uf.name();
                    if (!uf.childrenResolved()) {
                        return uf;
                    }
                    String functionName = Analyzer.this.functionRegistry.resolveAlias(name);
                    if (!Analyzer.this.functionRegistry.functionExists(functionName)) {
                        return uf.missing(functionName, (Iterable)Analyzer.this.functionRegistry.listFunctions());
                    }
                    FunctionDefinition def = Analyzer.this.functionRegistry.resolveFunction(functionName);
                    Function f = uf.buildResolved(Analyzer.this.configuration, def);
                    return f;
                }
                return e;
            });
        }
    }
}

