/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.eql.EqlFeatureSetUsage;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;
import org.elasticsearch.xpack.eql.plugin.EqlPlugin;
import org.elasticsearch.xpack.eql.plugin.EqlStatsAction;
import org.elasticsearch.xpack.eql.plugin.EqlStatsRequest;
import org.elasticsearch.xpack.eql.plugin.EqlStatsResponse;

public class EqlFeatureSet
implements XPackFeatureSet {
    private final boolean enabled = EqlPlugin.isEnabled();
    private final XPackLicenseState licenseState;
    private final Client client;

    @Inject
    public EqlFeatureSet(@Nullable XPackLicenseState licenseState, Client client) {
        this.licenseState = licenseState;
        this.client = client;
    }

    public String name() {
        return "eql";
    }

    public boolean available() {
        return this.licenseState.isAllowed(XPackLicenseState.Feature.EQL);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        if (this.enabled) {
            EqlStatsRequest request = new EqlStatsRequest();
            request.includeStats(true);
            this.client.execute((ActionType)EqlStatsAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> {
                List countersPerNode = r.getNodes().stream().map(EqlStatsResponse.NodeStatsResponse::getStats).filter(Objects::nonNull).collect(Collectors.toList());
                Counters mergedCounters = Counters.merge(countersPerNode);
                listener.onResponse((Object)new EqlFeatureSetUsage(this.available(), this.enabled(), mergedCounters.toNestedMap()));
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onResponse((Object)new EqlFeatureSetUsage(this.available(), this.enabled(), Collections.emptyMap()));
        }
    }
}

