/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.InternalGeoBounds;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.xpack.spatial.index.fielddata.MultiGeoShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSource;

public final class GeoShapeBoundsAggregator
extends MetricsAggregator {
    private final GeoShapeValuesSource valuesSource;
    private final boolean wrapLongitude;
    private DoubleArray tops;
    private DoubleArray bottoms;
    private DoubleArray posLefts;
    private DoubleArray posRights;
    private DoubleArray negLefts;
    private DoubleArray negRights;

    public GeoShapeBoundsAggregator(String name, SearchContext aggregationContext, Aggregator parent, ValuesSourceConfig valuesSourceConfig, boolean wrapLongitude, Map<String, Object> metadata) throws IOException {
        super(name, aggregationContext, parent, metadata);
        this.valuesSource = valuesSourceConfig.hasValues() ? (GeoShapeValuesSource)valuesSourceConfig.getValuesSource() : null;
        this.wrapLongitude = wrapLongitude;
        if (this.valuesSource != null) {
            BigArrays bigArrays = this.context.bigArrays();
            this.tops = bigArrays.newDoubleArray(1L, false);
            this.tops.fill(0L, this.tops.size(), Double.NEGATIVE_INFINITY);
            this.bottoms = bigArrays.newDoubleArray(1L, false);
            this.bottoms.fill(0L, this.bottoms.size(), Double.POSITIVE_INFINITY);
            this.posLefts = bigArrays.newDoubleArray(1L, false);
            this.posLefts.fill(0L, this.posLefts.size(), Double.POSITIVE_INFINITY);
            this.posRights = bigArrays.newDoubleArray(1L, false);
            this.posRights.fill(0L, this.posRights.size(), Double.NEGATIVE_INFINITY);
            this.negLefts = bigArrays.newDoubleArray(1L, false);
            this.negLefts.fill(0L, this.negLefts.size(), Double.POSITIVE_INFINITY);
            this.negRights = bigArrays.newDoubleArray(1L, false);
            this.negRights.fill(0L, this.negRights.size(), Double.NEGATIVE_INFINITY);
        }
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final MultiGeoShapeValues values = this.valuesSource.geoShapeValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= GeoShapeBoundsAggregator.this.tops.size()) {
                    long from = GeoShapeBoundsAggregator.this.tops.size();
                    GeoShapeBoundsAggregator.this.tops = bigArrays.grow(GeoShapeBoundsAggregator.this.tops, bucket + 1L);
                    GeoShapeBoundsAggregator.this.tops.fill(from, GeoShapeBoundsAggregator.this.tops.size(), Double.NEGATIVE_INFINITY);
                    GeoShapeBoundsAggregator.this.bottoms = bigArrays.resize(GeoShapeBoundsAggregator.this.bottoms, GeoShapeBoundsAggregator.this.tops.size());
                    GeoShapeBoundsAggregator.this.bottoms.fill(from, GeoShapeBoundsAggregator.this.bottoms.size(), Double.POSITIVE_INFINITY);
                    GeoShapeBoundsAggregator.this.posLefts = bigArrays.resize(GeoShapeBoundsAggregator.this.posLefts, GeoShapeBoundsAggregator.this.tops.size());
                    GeoShapeBoundsAggregator.this.posLefts.fill(from, GeoShapeBoundsAggregator.this.posLefts.size(), Double.POSITIVE_INFINITY);
                    GeoShapeBoundsAggregator.this.posRights = bigArrays.resize(GeoShapeBoundsAggregator.this.posRights, GeoShapeBoundsAggregator.this.tops.size());
                    GeoShapeBoundsAggregator.this.posRights.fill(from, GeoShapeBoundsAggregator.this.posRights.size(), Double.NEGATIVE_INFINITY);
                    GeoShapeBoundsAggregator.this.negLefts = bigArrays.resize(GeoShapeBoundsAggregator.this.negLefts, GeoShapeBoundsAggregator.this.tops.size());
                    GeoShapeBoundsAggregator.this.negLefts.fill(from, GeoShapeBoundsAggregator.this.negLefts.size(), Double.POSITIVE_INFINITY);
                    GeoShapeBoundsAggregator.this.negRights = bigArrays.resize(GeoShapeBoundsAggregator.this.negRights, GeoShapeBoundsAggregator.this.tops.size());
                    GeoShapeBoundsAggregator.this.negRights.fill(from, GeoShapeBoundsAggregator.this.negRights.size(), Double.NEGATIVE_INFINITY);
                }
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    for (int i = 0; i < valuesCount; ++i) {
                        MultiGeoShapeValues.GeoShapeValue value = values.nextValue();
                        MultiGeoShapeValues.BoundingBox bounds = value.boundingBox();
                        double top = Math.max(GeoShapeBoundsAggregator.this.tops.get(bucket), bounds.top);
                        double bottom = Math.min(GeoShapeBoundsAggregator.this.bottoms.get(bucket), bounds.bottom);
                        double posLeft = Math.min(GeoShapeBoundsAggregator.this.posLefts.get(bucket), bounds.posLeft);
                        double posRight = Math.max(GeoShapeBoundsAggregator.this.posRights.get(bucket), bounds.posRight);
                        double negLeft = Math.min(GeoShapeBoundsAggregator.this.negLefts.get(bucket), bounds.negLeft);
                        double negRight = Math.max(GeoShapeBoundsAggregator.this.negRights.get(bucket), bounds.negRight);
                        GeoShapeBoundsAggregator.this.tops.set(bucket, top);
                        GeoShapeBoundsAggregator.this.bottoms.set(bucket, bottom);
                        GeoShapeBoundsAggregator.this.posLefts.set(bucket, posLeft);
                        GeoShapeBoundsAggregator.this.posRights.set(bucket, posRight);
                        GeoShapeBoundsAggregator.this.negLefts.set(bucket, negLeft);
                        GeoShapeBoundsAggregator.this.negRights.set(bucket, negRight);
                    }
                }
            }
        };
    }

    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.valuesSource == null) {
            return this.buildEmptyAggregation();
        }
        double top = this.tops.get(owningBucketOrdinal);
        double bottom = this.bottoms.get(owningBucketOrdinal);
        double posLeft = this.posLefts.get(owningBucketOrdinal);
        double posRight = this.posRights.get(owningBucketOrdinal);
        double negLeft = this.negLefts.get(owningBucketOrdinal);
        double negRight = this.negRights.get(owningBucketOrdinal);
        return new InternalGeoBounds(this.name, top, bottom, posLeft, posRight, negLeft, negRight, this.wrapLongitude, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalGeoBounds(this.name, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, this.wrapLongitude, this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.tops, this.bottoms, this.posLefts, this.posRights, this.negLefts, this.negRights});
    }
}

