/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.mapper;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoShapeFieldMapper;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.index.mapper.GeoShapeParser;
import org.elasticsearch.index.mapper.LegacyGeoShapeFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xpack.spatial.index.fielddata.AbstractLatLonShapeIndexFieldData;
import org.elasticsearch.xpack.spatial.index.fielddata.CentroidCalculator;
import org.elasticsearch.xpack.spatial.index.mapper.BinaryGeoShapeDocValuesField;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSourceType;

public class GeoShapeWithDocValuesFieldMapper
extends GeoShapeFieldMapper {
    public static final String CONTENT_TYPE = "geo_shape";
    public static final FieldType FIELD_TYPE = new FieldType();
    private final boolean defaultDocValues;

    protected void addDocValuesFields(String name, Geometry shape, List fields, ParseContext context) {
        CentroidCalculator calculator = new CentroidCalculator(shape);
        byte[] scratch = new byte[28];
        ShapeField.DecodedTriangle[] triangles = new ShapeField.DecodedTriangle[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            BytesRef bytesRef = ((IndexableField)fields.get(i)).binaryValue();
            assert (bytesRef.length == 28);
            System.arraycopy(bytesRef.bytes, bytesRef.offset, scratch, 0, 28);
            triangles[i] = new ShapeField.DecodedTriangle();
            ShapeField.decodeTriangle((byte[])scratch, (ShapeField.DecodedTriangle)triangles[i]);
        }
        BinaryGeoShapeDocValuesField docValuesField = (BinaryGeoShapeDocValuesField)context.doc().getByKey((Object)name);
        if (docValuesField == null) {
            docValuesField = new BinaryGeoShapeDocValuesField(name, triangles, calculator);
            context.doc().addWithKey((Object)name, (IndexableField)docValuesField);
        } else {
            docValuesField.add(triangles, calculator);
        }
    }

    public GeoShapeWithDocValuesFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Explicit<ShapeBuilder.Orientation> orientation, boolean defaultDocValues, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, ignoreMalformed, coerce, ignoreZValue, orientation, multiFields, copyTo);
        this.defaultDocValues = defaultDocValues;
    }

    protected boolean docValuesByDefault() {
        return this.defaultDocValues;
    }

    public GeoShapeWithDocValuesFieldType fieldType() {
        return (GeoShapeWithDocValuesFieldType)super.fieldType();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    static {
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
    }

    public static final class GeoShapeWithDocValuesFieldType
    extends GeoShapeFieldMapper.GeoShapeFieldType {
        public GeoShapeWithDocValuesFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, meta);
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new AbstractLatLonShapeIndexFieldData.Builder(this.name(), GeoShapeValuesSourceType.instance());
        }
    }

    public static final class TypeParser
    extends AbstractShapeGeometryFieldMapper.TypeParser {
        protected AbstractShapeGeometryFieldMapper.Builder newBuilder(String name, Map<String, Object> params) {
            if (params.containsKey("deprecated_parameters")) {
                return new LegacyGeoShapeFieldMapper.Builder(name, (LegacyGeoShapeFieldMapper.DeprecatedParameters)params.get("deprecated_parameters"));
            }
            return new Builder(name);
        }

        public AbstractShapeGeometryFieldMapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            AbstractShapeGeometryFieldMapper.Builder builder = (AbstractShapeGeometryFieldMapper.Builder)super.parse(name, node, parserContext);
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (!"doc_values".equals(fieldName)) continue;
                params.put("doc_values", XContentMapValues.nodeBooleanValue((Object)fieldNode, (String)(name + "." + "doc_values")));
                iterator.remove();
            }
            if (params.containsKey("doc_values")) {
                builder.docValues(((Boolean)params.get("doc_values")).booleanValue());
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractShapeGeometryFieldMapper.Builder<Builder, GeoShapeWithDocValuesFieldType> {
        private boolean docValuesSet = false;

        public Builder(String name) {
            super(name, FIELD_TYPE);
            this.hasDocValues = true;
        }

        public Builder docValues(boolean docValues) {
            this.docValuesSet = true;
            return (Builder)super.docValues(docValues);
        }

        public GeoShapeWithDocValuesFieldMapper build(Mapper.BuilderContext context) {
            if (!this.docValuesSet) {
                this.hasDocValues = Version.V_7_8_0.onOrBefore(context.indexCreatedVersion());
            }
            GeoShapeWithDocValuesFieldType ft = new GeoShapeWithDocValuesFieldType(this.buildFullName(context), this.indexed, this.fieldType.stored(), this.hasDocValues, this.meta);
            GeometryParser geometryParser = new GeometryParser(ft.orientation().getAsBoolean(), ((Boolean)this.coerce().value()).booleanValue(), ((Boolean)this.ignoreZValue().value()).booleanValue());
            ft.setGeometryParser((AbstractGeometryFieldMapper.Parser)new GeoShapeParser(geometryParser));
            ft.setGeometryIndexer((AbstractGeometryFieldMapper.Indexer)new GeoShapeIndexer(((ShapeBuilder.Orientation)this.orientation().value()).getAsBoolean(), ft.name()));
            ft.setOrientation((ShapeBuilder.Orientation)this.orientation().value());
            return new GeoShapeWithDocValuesFieldMapper(this.name, this.fieldType, (MappedFieldType)ft, (Explicit<Boolean>)this.ignoreMalformed(context), (Explicit<Boolean>)this.coerce(context), (Explicit<Boolean>)this.ignoreZValue(), (Explicit<ShapeBuilder.Orientation>)this.orientation(), Version.V_7_8_0.onOrBefore(context.indexCreatedVersion()), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo);
        }
    }
}

