/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.vectors.VectorsFeatureSetUsage;

public class VectorsFeatureSet
implements XPackFeatureSet {
    private final XPackLicenseState licenseState;
    private final ClusterService clusterService;

    @Inject
    public VectorsFeatureSet(XPackLicenseState licenseState, ClusterService clusterService) {
        this.licenseState = licenseState;
        this.clusterService = clusterService;
    }

    public String name() {
        return "vectors";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isAllowed(XPackLicenseState.Feature.VECTORS);
    }

    public boolean enabled() {
        return true;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        boolean vectorsAvailable = this.available();
        boolean vectorsEnabled = this.enabled();
        int numDenseVectorFields = 0;
        int numSparseVectorFields = 0;
        int avgDenseVectorDims = 0;
        if (vectorsAvailable && this.clusterService.state() != null) {
            for (IndexMetadata indexMetadata : this.clusterService.state().metadata()) {
                Map mappings;
                MappingMetadata mappingMetadata = indexMetadata.mapping();
                if (mappingMetadata == null || !(mappings = mappingMetadata.getSourceAsMap()).containsKey("properties")) continue;
                Map fieldMappings = (Map)mappings.get("properties");
                for (Map typeDefinition : fieldMappings.values()) {
                    String fieldType = (String)typeDefinition.get("type");
                    if (fieldType == null) continue;
                    if (fieldType.equals("dense_vector")) {
                        ++numDenseVectorFields;
                        int dims = (Integer)typeDefinition.get("dims");
                        avgDenseVectorDims += dims;
                        continue;
                    }
                    if (!fieldType.equals("sparse_vector")) continue;
                    ++numSparseVectorFields;
                }
            }
            if (numDenseVectorFields > 0) {
                avgDenseVectorDims /= numDenseVectorFields;
            }
        }
        listener.onResponse((Object)new VectorsFeatureSetUsage(vectorsAvailable, vectorsEnabled, numDenseVectorFields, numSparseVectorFields, avgDenseVectorDims));
    }
}

