/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action.bulk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.action.bulk.BulkShardOperationsRequest;
import org.elasticsearch.xpack.ccr.action.bulk.BulkShardOperationsResponse;
import org.elasticsearch.xpack.ccr.index.engine.AlreadyProcessedFollowingEngineException;

public class TransportBulkShardOperationsAction
extends TransportWriteAction<BulkShardOperationsRequest, BulkShardOperationsRequest, BulkShardOperationsResponse> {
    private static final Function<IndexShard, String> EXECUTOR_NAME_FUNCTION = shard -> {
        if (shard.indexSettings().getIndexMetadata().isSystem()) {
            return "system_write";
        }
        return "write";
    };

    @Inject
    public TransportBulkShardOperationsAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexingPressure indexingPressure, SystemIndices systemIndices) {
        super(settings, "indices:data/write/bulk_shard_operations[s]", transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, BulkShardOperationsRequest::new, BulkShardOperationsRequest::new, EXECUTOR_NAME_FUNCTION, false, indexingPressure, systemIndices);
    }

    protected void doExecute(Task task, BulkShardOperationsRequest request, ActionListener<BulkShardOperationsResponse> listener) {
        Releasable releasable = this.indexingPressure.markCoordinatingOperationStarted(this.primaryOperationSize(request), false);
        ActionListener releasingListener = ActionListener.runBefore(listener, () -> ((Releasable)releasable).close());
        try {
            super.doExecute(task, (ReplicationRequest)request, releasingListener);
        }
        catch (Exception e) {
            releasingListener.onFailure(e);
        }
    }

    protected void dispatchedShardOperationOnPrimary(BulkShardOperationsRequest request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<BulkShardOperationsRequest, BulkShardOperationsResponse>> listener) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("index [{}] on the following primary shard {}", request.getOperations(), (Object)primary.routingEntry());
        }
        ActionListener.completeWith(listener, () -> TransportBulkShardOperationsAction.shardOperationOnPrimary(request.shardId(), request.getHistoryUUID(), request.getOperations(), request.getMaxSeqNoOfUpdatesOrDeletes(), primary, this.logger));
    }

    protected long primaryOperationSize(BulkShardOperationsRequest request) {
        return request.getOperations().stream().mapToLong(Translog.Operation::estimateSize).sum();
    }

    public static Translog.Operation rewriteOperationWithPrimaryTerm(Translog.Operation operation, long primaryTerm) {
        Translog.NoOp operationWithPrimaryTerm;
        switch (operation.opType()) {
            case INDEX: {
                Translog.Index index = (Translog.Index)operation;
                operationWithPrimaryTerm = new Translog.Index(index.type(), index.id(), index.seqNo(), primaryTerm, index.version(), BytesReference.toBytes((BytesReference)index.source()), index.routing(), index.getAutoGeneratedIdTimestamp());
                break;
            }
            case DELETE: {
                Translog.Delete delete = (Translog.Delete)operation;
                operationWithPrimaryTerm = new Translog.Delete(delete.type(), delete.id(), delete.uid(), delete.seqNo(), primaryTerm, delete.version());
                break;
            }
            case NO_OP: {
                Translog.NoOp noOp = (Translog.NoOp)operation;
                operationWithPrimaryTerm = new Translog.NoOp(noOp.seqNo(), primaryTerm, noOp.reason());
                break;
            }
            default: {
                throw new IllegalStateException("unexpected operation type [" + operation.opType() + "]");
            }
        }
        return operationWithPrimaryTerm;
    }

    public static TransportWriteAction.WritePrimaryResult<BulkShardOperationsRequest, BulkShardOperationsResponse> shardOperationOnPrimary(ShardId shardId, String historyUUID, List<Translog.Operation> sourceOperations, long maxSeqNoOfUpdatesOrDeletes, IndexShard primary, Logger logger) throws IOException {
        if (!historyUUID.equalsIgnoreCase(primary.getHistoryUUID())) {
            throw new IllegalStateException("unexpected history uuid, expected [" + historyUUID + "], actual [" + primary.getHistoryUUID() + "], shard is likely restored from snapshot or force allocated");
        }
        assert (maxSeqNoOfUpdatesOrDeletes >= -1L) : "invalid msu [" + maxSeqNoOfUpdatesOrDeletes + "]";
        primary.advanceMaxSeqNoOfUpdatesOrDeletes(maxSeqNoOfUpdatesOrDeletes);
        ArrayList<Translog.Operation> appliedOperations = new ArrayList<Translog.Operation>(sourceOperations.size());
        Translog.Location location = null;
        for (Translog.Operation sourceOp : sourceOperations) {
            Translog.Operation targetOp = TransportBulkShardOperationsAction.rewriteOperationWithPrimaryTerm(sourceOp, primary.getOperationPrimaryTerm());
            Engine.Result result = primary.applyTranslogOperation(targetOp, Engine.Operation.Origin.PRIMARY);
            if (result.getResultType() == Engine.Result.Type.SUCCESS) {
                assert (result.getSeqNo() == targetOp.seqNo());
                appliedOperations.add(targetOp);
                location = TransportBulkShardOperationsAction.locationToSync(location, (Translog.Location)result.getTranslogLocation());
                continue;
            }
            if (result.getFailure() instanceof AlreadyProcessedFollowingEngineException) {
                AlreadyProcessedFollowingEngineException failure = (AlreadyProcessedFollowingEngineException)((Object)result.getFailure());
                if (logger.isTraceEnabled()) {
                    logger.trace("operation [{}] was processed before on following primary shard {} with existing term {}", (Object)targetOp, (Object)primary.routingEntry(), (Object)failure.getExistingPrimaryTerm());
                }
                assert (failure.getSeqNo() == targetOp.seqNo()) : targetOp.seqNo() + " != " + failure.getSeqNo();
                if (failure.getExistingPrimaryTerm().isPresent()) {
                    appliedOperations.add(TransportBulkShardOperationsAction.rewriteOperationWithPrimaryTerm(sourceOp, failure.getExistingPrimaryTerm().getAsLong()));
                    continue;
                }
                if (targetOp.seqNo() <= primary.getLastKnownGlobalCheckpoint()) continue;
                assert (false) : "can't find primary_term for existing op=" + targetOp + " gcp=" + primary.getLastKnownGlobalCheckpoint();
                throw new IllegalStateException("can't find primary_term for existing op=" + targetOp + " global_checkpoint=" + primary.getLastKnownGlobalCheckpoint(), (Throwable)((Object)failure));
            }
            assert (false) : "Only already-processed error should happen; op=[" + targetOp + "] error=[" + result.getFailure() + "]";
            throw ExceptionsHelper.convertToElastic((Exception)result.getFailure());
        }
        BulkShardOperationsRequest replicaRequest = new BulkShardOperationsRequest(shardId, historyUUID, appliedOperations, maxSeqNoOfUpdatesOrDeletes);
        return new TransportWriteAction.WritePrimaryResult((ReplicatedWriteRequest)replicaRequest, (ReplicationResponse)new BulkShardOperationsResponse(), location, null, primary, logger);
    }

    protected void dispatchedShardOperationOnReplica(BulkShardOperationsRequest request, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListener.completeWith(listener, () -> {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("index [{}] on the following replica shard {}", request.getOperations(), (Object)replica.routingEntry());
            }
            return TransportBulkShardOperationsAction.shardOperationOnReplica(request, replica, this.logger);
        });
    }

    protected long replicaOperationSize(BulkShardOperationsRequest request) {
        return request.getOperations().stream().mapToLong(Translog.Operation::estimateSize).sum();
    }

    public static TransportWriteAction.WriteReplicaResult<BulkShardOperationsRequest> shardOperationOnReplica(BulkShardOperationsRequest request, IndexShard replica, Logger logger) throws IOException {
        assert (replica.getMaxSeqNoOfUpdatesOrDeletes() >= request.getMaxSeqNoOfUpdatesOrDeletes()) : "mus on replica [" + replica + "] < mus of request [" + request.getMaxSeqNoOfUpdatesOrDeletes() + "]";
        Translog.Location location = null;
        for (Translog.Operation operation : request.getOperations()) {
            Engine.Result result = replica.applyTranslogOperation(operation, Engine.Operation.Origin.REPLICA);
            if (result.getResultType() != Engine.Result.Type.SUCCESS) {
                assert (false) : "doc-level failure must not happen on replicas; op[" + operation + "] error[" + result.getFailure() + "]";
                throw ExceptionsHelper.convertToElastic((Exception)result.getFailure());
            }
            assert (result.getSeqNo() == operation.seqNo());
            location = TransportBulkShardOperationsAction.locationToSync(location, (Translog.Location)result.getTranslogLocation());
        }
        assert (request.getOperations().size() == 0 || location != null);
        return new TransportWriteAction.WriteReplicaResult((ReplicatedWriteRequest)request, location, null, replica, logger);
    }

    protected BulkShardOperationsResponse newResponseInstance(StreamInput in) throws IOException {
        return new BulkShardOperationsResponse(in);
    }

    protected void adaptResponse(BulkShardOperationsResponse response, IndexShard indexShard) {
        TransportBulkShardOperationsAction.adaptBulkShardOperationsResponse(response, indexShard);
    }

    public static void adaptBulkShardOperationsResponse(BulkShardOperationsResponse response, IndexShard indexShard) {
        SeqNoStats seqNoStats = indexShard.seqNoStats();
        response.setGlobalCheckpoint(seqNoStats.getGlobalCheckpoint());
        response.setMaxSeqNo(seqNoStats.getMaxSeqNo());
    }
}

