/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.planner;

import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.planner.TranslatorHandler;
import org.elasticsearch.xpack.ql.querydsl.query.NestedQuery;
import org.elasticsearch.xpack.ql.querydsl.query.Query;
import org.elasticsearch.xpack.ql.util.ReflectionUtils;

public abstract class ExpressionTranslator<E extends Expression> {
    private final Class<E> typeToken = ReflectionUtils.detectSuperTypeForRuleLike(this.getClass());

    public Query translate(Expression exp, TranslatorHandler handler) {
        return this.typeToken.isInstance(exp) ? this.asQuery(exp, handler) : null;
    }

    protected abstract Query asQuery(E var1, TranslatorHandler var2);

    public static Query wrapIfNested(Query query, Expression exp) {
        FieldAttribute fa;
        if (query != null && exp instanceof FieldAttribute && (fa = (FieldAttribute)exp).isNested()) {
            return new NestedQuery(fa.source(), fa.nestedParent().name(), query);
        }
        return query;
    }
}

