/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.optimizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.scalar.SurrogateFunction;
import org.elasticsearch.xpack.ql.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.ql.expression.predicate.BinaryPredicate;
import org.elasticsearch.xpack.ql.expression.predicate.Negatable;
import org.elasticsearch.xpack.ql.expression.predicate.Predicates;
import org.elasticsearch.xpack.ql.expression.predicate.Range;
import org.elasticsearch.xpack.ql.expression.predicate.logical.And;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.NullEquals;
import org.elasticsearch.xpack.ql.expression.predicate.regex.RegexMatch;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public final class OptimizerRules {

    public static enum TransformDirection {
        UP,
        DOWN;

    }

    public static abstract class OptimizerExpressionRule
    extends Rule<LogicalPlan, LogicalPlan> {
        private final TransformDirection direction;

        public OptimizerExpressionRule(TransformDirection direction) {
            this.direction = direction;
        }

        @Override
        public final LogicalPlan apply(LogicalPlan plan) {
            return this.direction == TransformDirection.DOWN ? (LogicalPlan)plan.transformExpressionsDown(this::rule) : (LogicalPlan)plan.transformExpressionsUp(this::rule);
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            return plan;
        }

        @Override
        protected abstract Expression rule(Expression var1);
    }

    public static abstract class OptimizerRule<SubPlan extends LogicalPlan>
    extends Rule<SubPlan, LogicalPlan> {
        private final TransformDirection direction;

        public OptimizerRule() {
            this(TransformDirection.DOWN);
        }

        protected OptimizerRule(TransformDirection direction) {
            this.direction = direction;
        }

        @Override
        public final LogicalPlan apply(LogicalPlan plan) {
            return this.direction == TransformDirection.DOWN ? plan.transformDown(this::rule, this.typeToken()) : plan.transformUp(this::rule, this.typeToken());
        }

        @Override
        protected abstract LogicalPlan rule(SubPlan var1);
    }

    public static final class SetAsOptimized
    extends Rule<LogicalPlan, LogicalPlan> {
        @Override
        public LogicalPlan apply(LogicalPlan plan) {
            plan.forEachUp(this::rule);
            return plan;
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            if (!plan.optimized()) {
                plan.setOptimized();
            }
            return plan;
        }
    }

    public static class ReplaceRegexMatch
    extends OptimizerExpressionRule {
        public ReplaceRegexMatch() {
            super(TransformDirection.DOWN);
        }

        @Override
        protected Expression rule(Expression e) {
            if (e instanceof RegexMatch) {
                RegexMatch regexMatch = (RegexMatch)e;
                Object pattern = regexMatch.pattern();
                if (pattern.matchesAll()) {
                    e = new IsNotNull(e.source(), regexMatch.field());
                } else if (pattern.isExactMatch()) {
                    Literal literal = new Literal(regexMatch.source(), regexMatch.pattern().asString(), DataTypes.KEYWORD);
                    e = new Equals(e.source(), regexMatch.field(), literal);
                }
            }
            return e;
        }
    }

    public static abstract class SkipQueryOnLimitZero
    extends OptimizerRule<Limit> {
        @Override
        protected LogicalPlan rule(Limit limit) {
            if (limit.limit().foldable() && Integer.valueOf(0).equals(limit.limit().fold())) {
                return this.skipPlan(limit);
            }
            return limit;
        }

        protected abstract LogicalPlan skipPlan(Limit var1);
    }

    public static final class PruneLiteralsInOrderBy
    extends OptimizerRule<OrderBy> {
        @Override
        protected LogicalPlan rule(OrderBy ob) {
            ArrayList<Order> prunedOrders = new ArrayList<Order>();
            for (Order o : ob.order()) {
                if (!o.child().foldable()) continue;
                prunedOrders.add(o);
            }
            if (prunedOrders.size() == ob.order().size()) {
                return ob.child();
            }
            if (prunedOrders.size() > 0) {
                ArrayList<Order> newOrders = new ArrayList<Order>(ob.order());
                newOrders.removeAll(prunedOrders);
                return new OrderBy(ob.source(), ob.child(), newOrders);
            }
            return ob;
        }
    }

    public static abstract class PruneFilters
    extends OptimizerRule<Filter> {
        @Override
        protected LogicalPlan rule(Filter filter) {
            Expression condition = filter.condition().transformUp(PruneFilters::foldBinaryLogic);
            if (condition instanceof Literal) {
                if (Literal.TRUE.equals(condition)) {
                    return filter.child();
                }
                if (Literal.FALSE.equals(condition) || Expressions.isNull(condition)) {
                    return this.skipPlan(filter);
                }
            }
            if (!condition.equals(filter.condition())) {
                return new Filter(filter.source(), filter.child(), condition);
            }
            return filter;
        }

        protected abstract LogicalPlan skipPlan(Filter var1);

        private static Expression foldBinaryLogic(Expression expression) {
            And and;
            if (expression instanceof Or) {
                Or or = (Or)expression;
                boolean nullLeft = Expressions.isNull(or.left());
                boolean nullRight = Expressions.isNull(or.right());
                if (nullLeft && nullRight) {
                    return new Literal(expression.source(), null, DataTypes.NULL);
                }
                if (nullLeft) {
                    return or.right();
                }
                if (nullRight) {
                    return or.left();
                }
            }
            if (expression instanceof And && (Expressions.isNull((and = (And)expression).left()) || Expressions.isNull(and.right()))) {
                return new Literal(expression.source(), null, DataTypes.NULL);
            }
            return expression;
        }
    }

    public static class ReplaceSurrogateFunction
    extends OptimizerExpressionRule {
        public ReplaceSurrogateFunction() {
            super(TransformDirection.DOWN);
        }

        @Override
        protected Expression rule(Expression e) {
            if (e instanceof SurrogateFunction) {
                e = ((SurrogateFunction)((Object)e)).substitute();
            }
            return e;
        }
    }

    public static final class CombineBinaryComparisons
    extends OptimizerExpressionRule {
        public CombineBinaryComparisons() {
            super(TransformDirection.DOWN);
        }

        @Override
        public Expression rule(Expression e) {
            if (e instanceof And) {
                return this.combine((And)e);
            }
            if (e instanceof Or) {
                return this.combine((Or)e);
            }
            return e;
        }

        private Expression combine(And and) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            ArrayList<BinaryComparison> bcs = new ArrayList<BinaryComparison>();
            ArrayList<Expression> exps = new ArrayList<Expression>();
            boolean changed = false;
            List<Expression> andExps = Predicates.splitAnd(and);
            andExps.sort((o1, o2) -> {
                if (o1 instanceof Range && o2 instanceof Range) {
                    return 0;
                }
                if (o1 instanceof Range || o2 instanceof Range) {
                    return o2 instanceof Range ? 1 : -1;
                }
                if (o1 instanceof NotEquals && o2 instanceof NotEquals) {
                    return 0;
                }
                if (o1 instanceof NotEquals || o2 instanceof NotEquals) {
                    return o1 instanceof NotEquals ? 1 : -1;
                }
                return 0;
            });
            for (Expression ex : andExps) {
                if (ex instanceof Range) {
                    Range r = (Range)ex;
                    if (CombineBinaryComparisons.findExistingRange(r, ranges, true)) {
                        changed = true;
                        continue;
                    }
                    ranges.add(r);
                    continue;
                }
                if (ex instanceof BinaryComparison && !(ex instanceof Equals) && !(ex instanceof NotEquals)) {
                    BinaryComparison bc = (BinaryComparison)ex;
                    if (bc.right().foldable() && (this.findConjunctiveComparisonInRange(bc, ranges) || CombineBinaryComparisons.findExistingComparison(bc, bcs, true))) {
                        changed = true;
                        continue;
                    }
                    bcs.add(bc);
                    continue;
                }
                if (ex instanceof NotEquals) {
                    NotEquals neq = (NotEquals)ex;
                    if (neq.right().foldable() && CombineBinaryComparisons.notEqualsIsRemovableFromConjunction(neq, ranges, bcs)) {
                        changed = true;
                        continue;
                    }
                    exps.add(ex);
                    continue;
                }
                exps.add(ex);
            }
            int step = 1;
            for (int i = 0; i < bcs.size() - 1; i += step) {
                BinaryComparison main = (BinaryComparison)bcs.get(i);
                for (int j = i + 1; j < bcs.size(); ++j) {
                    BinaryComparison other = (BinaryComparison)bcs.get(j);
                    if (!main.left().semanticEquals(other.left())) continue;
                    if ((main instanceof GreaterThan || main instanceof GreaterThanOrEqual) && (other instanceof LessThan || other instanceof LessThanOrEqual)) {
                        bcs.remove(j);
                        bcs.remove(i);
                        ranges.add(new Range(and.source(), main.left(), main.right(), main instanceof GreaterThanOrEqual, other.right(), other instanceof LessThanOrEqual, main.zoneId()));
                        changed = true;
                        step = 0;
                        break;
                    }
                    if (!(other instanceof GreaterThan) && !(other instanceof GreaterThanOrEqual) || !(main instanceof LessThan) && !(main instanceof LessThanOrEqual)) continue;
                    bcs.remove(j);
                    bcs.remove(i);
                    ranges.add(new Range(and.source(), main.left(), other.right(), other instanceof GreaterThanOrEqual, main.right(), main instanceof LessThanOrEqual, main.zoneId()));
                    changed = true;
                    step = 0;
                    break;
                }
                step = 1;
            }
            return changed ? Predicates.combineAnd(CollectionUtils.combine(new Collection[]{exps, bcs, ranges})) : and;
        }

        private Expression combine(Or or) {
            ArrayList<BinaryComparison> bcs = new ArrayList<BinaryComparison>();
            ArrayList<Range> ranges = new ArrayList<Range>();
            ArrayList<Expression> exps = new ArrayList<Expression>();
            boolean changed = false;
            for (Expression ex : Predicates.splitOr(or)) {
                if (ex instanceof Range) {
                    Range r = (Range)ex;
                    if (CombineBinaryComparisons.findExistingRange(r, ranges, false)) {
                        changed = true;
                        continue;
                    }
                    ranges.add(r);
                    continue;
                }
                if (ex instanceof BinaryComparison) {
                    BinaryComparison bc = (BinaryComparison)ex;
                    if (bc.right().foldable() && CombineBinaryComparisons.findExistingComparison(bc, bcs, false)) {
                        changed = true;
                        continue;
                    }
                    bcs.add(bc);
                    continue;
                }
                exps.add(ex);
            }
            return changed ? Predicates.combineOr(CollectionUtils.combine(new Collection[]{exps, bcs, ranges})) : or;
        }

        private static boolean findExistingRange(Range main, List<Range> ranges, boolean conjunctive) {
            if (!main.lower().foldable() && !main.upper().foldable()) {
                return false;
            }
            for (int i = 0; i < ranges.size(); ++i) {
                Integer comp;
                Range other = ranges.get(i);
                if (!main.value().semanticEquals(other.value())) continue;
                boolean compared = false;
                boolean lower = false;
                boolean upper = false;
                boolean lowerEq = false;
                boolean upperEq = false;
                if (main.lower().foldable() && other.lower().foldable()) {
                    compared = true;
                    comp = BinaryComparison.compare(main.lower().fold(), other.lower().fold());
                    if (comp != null) {
                        boolean bl = lowerEq = comp == 0 && main.includeLower() == other.includeLower();
                        if (conjunctive) {
                            lower = comp > 0 || comp == 0 && !main.includeLower() && other.includeLower();
                        } else {
                            boolean bl2 = lower = comp < 0 || comp == 0 && main.includeLower() && !other.includeLower() || lowerEq;
                        }
                    }
                }
                if (main.upper().foldable() && other.upper().foldable()) {
                    compared = true;
                    comp = BinaryComparison.compare(main.upper().fold(), other.upper().fold());
                    if (comp != null) {
                        boolean bl = upperEq = comp == 0 && main.includeUpper() == other.includeUpper();
                        if (conjunctive) {
                            upper = comp < 0 || comp == 0 && !main.includeUpper() && other.includeUpper();
                        } else {
                            boolean bl3 = upper = comp > 0 || comp == 0 && main.includeUpper() && !other.includeUpper() || upperEq;
                        }
                    }
                }
                if (conjunctive) {
                    if (lower || upper) {
                        ranges.remove(i);
                        ranges.add(i, new Range(main.source(), main.value(), lower ? main.lower() : other.lower(), lower ? main.includeLower() : other.includeLower(), upper ? main.upper() : other.upper(), upper ? main.includeUpper() : other.includeUpper(), main.zoneId()));
                    }
                    return compared;
                }
                if (lower && upper) {
                    ranges.remove(i);
                    ranges.add(i, new Range(main.source(), main.value(), lower ? main.lower() : other.lower(), lower ? main.includeLower() : other.includeLower(), upper ? main.upper() : other.upper(), upper ? main.includeUpper() : other.includeUpper(), main.zoneId()));
                    return true;
                }
                return !(!compared || lower && !lowerEq || upper && !upperEq);
            }
            return false;
        }

        private boolean findConjunctiveComparisonInRange(BinaryComparison main, List<Range> ranges) {
            Object value = main.right().fold();
            for (int i = 0; i < ranges.size(); ++i) {
                Integer comp;
                Range other = ranges.get(i);
                if (!main.left().semanticEquals(other.value())) continue;
                if (main instanceof GreaterThan || main instanceof GreaterThanOrEqual) {
                    Integer comp2;
                    if (other.lower().foldable() && (comp2 = BinaryComparison.compare(value, other.lower().fold())) != null) {
                        boolean lower;
                        boolean lowerEq = comp2 == 0 && other.includeLower() && main instanceof GreaterThan;
                        boolean bl = lower = comp2 > 0 || lowerEq;
                        if (lower) {
                            ranges.remove(i);
                            ranges.add(i, new Range(other.source(), other.value(), main.right(), lowerEq ? false : main instanceof GreaterThanOrEqual, other.upper(), other.includeUpper(), other.zoneId()));
                        }
                        return true;
                    }
                } else if ((main instanceof LessThan || main instanceof LessThanOrEqual) && other.upper().foldable() && (comp = BinaryComparison.compare(value, other.upper().fold())) != null) {
                    boolean upper;
                    boolean upperEq = comp == 0 && other.includeUpper() && main instanceof LessThan;
                    boolean bl = upper = comp < 0 || upperEq;
                    if (upper) {
                        ranges.remove(i);
                        ranges.add(i, new Range(other.source(), other.value(), other.lower(), other.includeLower(), main.right(), upperEq ? false : main instanceof LessThanOrEqual, other.zoneId()));
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        private static boolean findExistingComparison(BinaryComparison main, List<BinaryComparison> bcs, boolean conjunctive) {
            Object value = main.right().fold();
            for (int i = 0; i < bcs.size(); ++i) {
                BinaryComparison other = bcs.get(i);
                if (!other.right().foldable()) continue;
                if ((other instanceof GreaterThan || other instanceof GreaterThanOrEqual) && (main instanceof GreaterThan || main instanceof GreaterThanOrEqual)) {
                    if (!main.left().semanticEquals(other.left())) continue;
                    Integer compare = BinaryComparison.compare(value, other.right().fold());
                    if (compare != null) {
                        if (conjunctive && (compare > 0 || compare == 0 && main instanceof GreaterThan && other instanceof GreaterThanOrEqual) || !conjunctive && (compare < 0 || compare == 0 && main instanceof GreaterThanOrEqual && other instanceof GreaterThan)) {
                            bcs.remove(i);
                            bcs.add(i, main);
                        }
                        return true;
                    }
                    return false;
                }
                if (!(other instanceof LessThan) && !(other instanceof LessThanOrEqual) || !(main instanceof LessThan) && !(main instanceof LessThanOrEqual) || !main.left().semanticEquals(other.left())) continue;
                Integer compare = BinaryComparison.compare(value, other.right().fold());
                if (compare != null) {
                    if (conjunctive && (compare < 0 || compare == 0 && main instanceof LessThan && other instanceof LessThanOrEqual) || !conjunctive && (compare > 0 || compare == 0 && main instanceof LessThanOrEqual && other instanceof LessThan)) {
                        bcs.remove(i);
                        bcs.add(i, main);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        private static boolean notEqualsIsRemovableFromConjunction(NotEquals notEquals, List<Range> ranges, List<BinaryComparison> bcs) {
            Integer comp;
            int i;
            Object neqVal = notEquals.right().fold();
            for (i = 0; i < ranges.size(); ++i) {
                Range range = ranges.get(i);
                if (!notEquals.left().semanticEquals(range.value())) continue;
                Integer n = comp = range.lower().foldable() ? BinaryComparison.compare(neqVal, range.lower().fold()) : null;
                if (comp != null) {
                    if (comp <= 0) {
                        if (comp == 0 && range.includeLower()) {
                            ranges.set(i, new Range(range.source(), range.value(), range.lower(), false, range.upper(), range.includeUpper(), range.zoneId()));
                        }
                        return true;
                    }
                    Integer n2 = comp = range.upper().foldable() ? BinaryComparison.compare(neqVal, range.upper().fold()) : null;
                    if (comp != null && comp >= 0) {
                        if (comp == 0 && range.includeUpper()) {
                            ranges.set(i, new Range(range.source(), range.value(), range.lower(), range.includeLower(), range.upper(), false, range.zoneId()));
                        }
                        return true;
                    }
                }
                Integer n3 = comp = range.upper().foldable() ? BinaryComparison.compare(neqVal, range.upper().fold()) : null;
                if (comp == null || comp < 0) continue;
                if (comp == 0 && range.includeUpper()) {
                    ranges.set(i, new Range(range.source(), range.value(), range.lower(), range.includeLower(), range.upper(), false, range.zoneId()));
                }
                return true;
            }
            for (i = 0; i < bcs.size(); ++i) {
                BinaryComparison bc = bcs.get(i);
                if (bc instanceof LessThan || bc instanceof LessThanOrEqual) {
                    Integer n = comp = bc.right().foldable() ? BinaryComparison.compare(neqVal, bc.right().fold()) : null;
                    if (comp == null || comp < 0) continue;
                    if (comp == 0 && bc instanceof LessThanOrEqual) {
                        bcs.set(i, new LessThan(bc.source(), bc.left(), bc.right(), bc.zoneId()));
                    }
                    return true;
                }
                if (!(bc instanceof GreaterThan) && !(bc instanceof GreaterThanOrEqual)) continue;
                Integer n = comp = bc.right().foldable() ? BinaryComparison.compare(neqVal, bc.right().fold()) : null;
                if (comp == null || comp > 0) continue;
                if (comp == 0 && bc instanceof GreaterThanOrEqual) {
                    bcs.set(i, new GreaterThan(bc.source(), bc.left(), bc.right(), bc.zoneId()));
                }
                return true;
            }
            return false;
        }
    }

    public static final class PropagateEquals
    extends OptimizerExpressionRule {
        public PropagateEquals() {
            super(TransformDirection.DOWN);
        }

        @Override
        public Expression rule(Expression e) {
            if (e instanceof And) {
                return this.propagate((And)e);
            }
            if (e instanceof Or) {
                return this.propagate((Or)e);
            }
            return e;
        }

        private Expression propagate(And and) {
            Integer comp;
            ArrayList<Range> ranges = new ArrayList<Range>();
            ArrayList<BinaryComparison> equals = new ArrayList<BinaryComparison>();
            ArrayList<NotEquals> notEquals = new ArrayList<NotEquals>();
            ArrayList<BinaryComparison> inequalities = new ArrayList<BinaryComparison>();
            ArrayList<Expression> exps = new ArrayList<Expression>();
            boolean changed = false;
            for (Expression ex : Predicates.splitAnd(and)) {
                if (ex instanceof Range) {
                    ranges.add((Range)ex);
                    continue;
                }
                if (ex instanceof Equals || ex instanceof NullEquals) {
                    BinaryComparison otherEq = (BinaryComparison)ex;
                    if (otherEq.right().foldable()) {
                        for (BinaryComparison eq : equals) {
                            if (!otherEq.left().semanticEquals(eq.left()) || (comp = BinaryComparison.compare(eq.right().fold(), otherEq.right().fold())) == null || comp == 0) continue;
                            return new Literal(and.source(), Boolean.FALSE, DataTypes.BOOLEAN);
                        }
                        equals.add(otherEq);
                        continue;
                    }
                    exps.add(otherEq);
                    continue;
                }
                if (ex instanceof GreaterThan || ex instanceof GreaterThanOrEqual || ex instanceof LessThan || ex instanceof LessThanOrEqual) {
                    BinaryComparison bc = (BinaryComparison)ex;
                    if (bc.right().foldable()) {
                        inequalities.add(bc);
                        continue;
                    }
                    exps.add(ex);
                    continue;
                }
                if (ex instanceof NotEquals) {
                    NotEquals otherNotEq = (NotEquals)ex;
                    if (otherNotEq.right().foldable()) {
                        notEquals.add(otherNotEq);
                        continue;
                    }
                    exps.add(ex);
                    continue;
                }
                exps.add(ex);
            }
            for (BinaryComparison eq : equals) {
                Integer compare;
                Object eqValue = eq.right().fold();
                for (int i = 0; i < ranges.size(); ++i) {
                    Range range = (Range)ranges.get(i);
                    if (!range.value().semanticEquals(eq.left())) continue;
                    if (range.lower().foldable() && (compare = BinaryComparison.compare(range.lower().fold(), eqValue)) != null && (compare > 0 || compare == 0 && !range.includeLower())) {
                        return new Literal(and.source(), Boolean.FALSE, DataTypes.BOOLEAN);
                    }
                    if (range.upper().foldable() && (compare = BinaryComparison.compare(range.upper().fold(), eqValue)) != null && (compare < 0 || compare == 0 && !range.includeUpper())) {
                        return new Literal(and.source(), Boolean.FALSE, DataTypes.BOOLEAN);
                    }
                    ranges.remove(i);
                    changed = true;
                }
                Iterator iter = notEquals.iterator();
                while (iter.hasNext()) {
                    NotEquals neq = (NotEquals)iter.next();
                    if (!eq.left().semanticEquals(neq.left()) || (comp = BinaryComparison.compare(eqValue, neq.right().fold())) == null) continue;
                    if (comp == 0) {
                        return new Literal(and.source(), Boolean.FALSE, DataTypes.BOOLEAN);
                    }
                    iter.remove();
                    changed = true;
                }
                iter = inequalities.iterator();
                while (iter.hasNext()) {
                    BinaryComparison bc = (BinaryComparison)iter.next();
                    if (!eq.left().semanticEquals(bc.left()) || (compare = BinaryComparison.compare(eqValue, bc.right().fold())) == null) continue;
                    if (bc instanceof LessThan || bc instanceof LessThanOrEqual ? compare == 0 && bc instanceof LessThan || 0 < compare : (bc instanceof GreaterThan || bc instanceof GreaterThanOrEqual) && (compare == 0 && bc instanceof GreaterThan || compare < 0)) {
                        return new Literal(and.source(), Boolean.FALSE, DataTypes.BOOLEAN);
                    }
                    iter.remove();
                    changed = true;
                }
            }
            return changed ? Predicates.combineAnd(CollectionUtils.combine(new Collection[]{exps, equals, notEquals, inequalities, ranges})) : and;
        }

        private Expression propagate(Or or) {
            Equals eq;
            ArrayList<Expression> exps = new ArrayList<Expression>();
            ArrayList<Equals> equals = new ArrayList<Equals>();
            ArrayList<NotEquals> notEquals = new ArrayList<NotEquals>();
            ArrayList<Range> ranges = new ArrayList<Range>();
            ArrayList<BinaryComparison> inequalities = new ArrayList<BinaryComparison>();
            for (Expression ex : Predicates.splitOr(or)) {
                if (ex instanceof Equals) {
                    eq = (Equals)ex;
                    if (eq.right().foldable()) {
                        equals.add(eq);
                        continue;
                    }
                    exps.add(ex);
                    continue;
                }
                if (ex instanceof NotEquals) {
                    NotEquals neq = (NotEquals)ex;
                    if (neq.right().foldable()) {
                        notEquals.add(neq);
                        continue;
                    }
                    exps.add(ex);
                    continue;
                }
                if (ex instanceof Range) {
                    ranges.add((Range)ex);
                    continue;
                }
                if (ex instanceof BinaryComparison) {
                    BinaryComparison bc = (BinaryComparison)ex;
                    if (bc.right().foldable()) {
                        inequalities.add(bc);
                        continue;
                    }
                    exps.add(ex);
                    continue;
                }
                exps.add(ex);
            }
            boolean updated = false;
            Iterator iterEq = equals.iterator();
            while (iterEq.hasNext()) {
                int i;
                Integer comp;
                eq = (Equals)iterEq.next();
                Object eqValue = eq.right().fold();
                boolean removeEquals = false;
                for (NotEquals neq : notEquals) {
                    if (!eq.left().semanticEquals(neq.left()) || (comp = BinaryComparison.compare(eqValue, neq.right().fold())) == null) continue;
                    if (comp == 0) {
                        return Literal.TRUE;
                    }
                    removeEquals = true;
                    break;
                }
                if (removeEquals) {
                    iterEq.remove();
                    updated = true;
                    continue;
                }
                for (i = 0; i < ranges.size(); ++i) {
                    Integer upperComp;
                    Range range = (Range)ranges.get(i);
                    if (!eq.left().semanticEquals(range.value())) continue;
                    Integer lowerComp = range.lower().foldable() ? BinaryComparison.compare(eqValue, range.lower().fold()) : null;
                    Integer n = upperComp = range.upper().foldable() ? BinaryComparison.compare(eqValue, range.upper().fold()) : null;
                    if (lowerComp != null && lowerComp == 0) {
                        if (!range.includeLower()) {
                            ranges.set(i, new Range(range.source(), range.value(), range.lower(), true, range.upper(), range.includeUpper(), range.zoneId()));
                        }
                        removeEquals = true;
                        break;
                    }
                    if (upperComp != null && upperComp == 0) {
                        if (!range.includeUpper()) {
                            ranges.set(i, new Range(range.source(), range.value(), range.lower(), range.includeLower(), range.upper(), true, range.zoneId()));
                        }
                        removeEquals = true;
                        break;
                    }
                    if (lowerComp == null || upperComp == null || 0 >= lowerComp || upperComp >= 0) continue;
                    removeEquals = true;
                    break;
                }
                if (removeEquals) {
                    iterEq.remove();
                    updated = true;
                    continue;
                }
                for (i = 0; i < inequalities.size(); ++i) {
                    BinaryComparison bc = (BinaryComparison)inequalities.get(i);
                    if (!eq.left().semanticEquals(bc.left()) || (comp = BinaryComparison.compare(eqValue, bc.right().fold())) == null) continue;
                    if (bc instanceof GreaterThan || bc instanceof GreaterThanOrEqual) {
                        if (comp < 0) continue;
                        if (comp == 0 && bc instanceof GreaterThan) {
                            inequalities.set(i, new GreaterThanOrEqual(bc.source(), bc.left(), bc.right(), bc.zoneId()));
                        }
                        removeEquals = true;
                        break;
                    }
                    if (!(bc instanceof LessThan) && !(bc instanceof LessThanOrEqual) || comp > 0) continue;
                    if (comp == 0 && bc instanceof LessThan) {
                        inequalities.set(i, new LessThanOrEqual(bc.source(), bc.left(), bc.right(), bc.zoneId()));
                    }
                    removeEquals = true;
                    break;
                }
                if (!removeEquals) continue;
                iterEq.remove();
                updated = true;
            }
            return updated ? Predicates.combineOr(CollectionUtils.combine(new Collection[]{exps, equals, notEquals, inequalities, ranges})) : or;
        }
    }

    public static final class BooleanLiteralsOnTheRight
    extends OptimizerExpressionRule {
        public BooleanLiteralsOnTheRight() {
            super(TransformDirection.UP);
        }

        @Override
        public Expression rule(Expression e) {
            return e instanceof BinaryOperator ? this.literalToTheRight((BinaryOperator)e) : e;
        }

        private Expression literalToTheRight(BinaryOperator<?, ?, ?, ?> be) {
            return be.left() instanceof Literal && !(be.right() instanceof Literal) ? be.swapLeftAndRight() : be;
        }
    }

    public static final class BooleanSimplification
    extends OptimizerExpressionRule {
        public BooleanSimplification() {
            super(TransformDirection.UP);
        }

        @Override
        public Expression rule(Expression e) {
            if (e instanceof And || e instanceof Or) {
                return this.simplifyAndOr((BinaryPredicate)e);
            }
            if (e instanceof Not) {
                return this.simplifyNot((Not)e);
            }
            return e;
        }

        private Expression simplifyAndOr(BinaryPredicate<?, ?, ?, ?> bc) {
            Expression l = bc.left();
            Expression r = bc.right();
            if (bc instanceof And) {
                List<Expression> rightSplit;
                if (Literal.TRUE.equals(l)) {
                    return r;
                }
                if (Literal.TRUE.equals(r)) {
                    return l;
                }
                if (Literal.FALSE.equals(l) || Literal.FALSE.equals(r)) {
                    return new Literal(bc.source(), Boolean.FALSE, DataTypes.BOOLEAN);
                }
                if (l.semanticEquals(r)) {
                    return l;
                }
                List<Expression> leftSplit = Predicates.splitOr(l);
                List<Expression> common = Predicates.inCommon(leftSplit, rightSplit = Predicates.splitOr(r));
                if (common.isEmpty()) {
                    return bc;
                }
                List<Expression> lDiff = Predicates.subtract(leftSplit, common);
                List<Expression> rDiff = Predicates.subtract(rightSplit, common);
                if (lDiff.isEmpty() || rDiff.isEmpty()) {
                    return Predicates.combineOr(common);
                }
                Expression combineLeft = Predicates.combineOr(lDiff);
                Expression combineRight = Predicates.combineOr(rDiff);
                return Predicates.combineOr(CollectionUtils.combine(common, new And(combineLeft.source(), combineLeft, combineRight)));
            }
            if (bc instanceof Or) {
                List<Expression> rightSplit;
                if (Literal.TRUE.equals(l) || Literal.TRUE.equals(r)) {
                    return new Literal(bc.source(), Boolean.TRUE, DataTypes.BOOLEAN);
                }
                if (Literal.FALSE.equals(l)) {
                    return r;
                }
                if (Literal.FALSE.equals(r)) {
                    return l;
                }
                if (l.semanticEquals(r)) {
                    return l;
                }
                List<Expression> leftSplit = Predicates.splitAnd(l);
                List<Expression> common = Predicates.inCommon(leftSplit, rightSplit = Predicates.splitAnd(r));
                if (common.isEmpty()) {
                    return bc;
                }
                List<Expression> lDiff = Predicates.subtract(leftSplit, common);
                List<Expression> rDiff = Predicates.subtract(rightSplit, common);
                if (lDiff.isEmpty() || rDiff.isEmpty()) {
                    return Predicates.combineAnd(common);
                }
                Expression combineLeft = Predicates.combineAnd(lDiff);
                Expression combineRight = Predicates.combineAnd(rDiff);
                return Predicates.combineAnd(CollectionUtils.combine(common, new Or(combineLeft.source(), combineLeft, combineRight)));
            }
            return bc;
        }

        private Expression simplifyNot(Not n) {
            Expression c = n.field();
            if (Literal.TRUE.semanticEquals(c)) {
                return new Literal(n.source(), Boolean.FALSE, DataTypes.BOOLEAN);
            }
            if (Literal.FALSE.semanticEquals(c)) {
                return new Literal(n.source(), Boolean.TRUE, DataTypes.BOOLEAN);
            }
            if (c instanceof Negatable) {
                return ((Negatable)((Object)c)).negate();
            }
            if (c instanceof Not) {
                return ((Not)c).field();
            }
            return n;
        }
    }

    public static final class BooleanFunctionEqualsElimination
    extends OptimizerExpressionRule {
        public BooleanFunctionEqualsElimination() {
            super(TransformDirection.UP);
        }

        @Override
        protected Expression rule(Expression e) {
            if ((e instanceof Equals || e instanceof NotEquals) && ((BinaryComparison)e).left() instanceof Function) {
                BinaryComparison bc = (BinaryComparison)e;
                if (Literal.TRUE.equals(bc.right())) {
                    return e instanceof Equals ? bc.left() : new Not(bc.left().source(), bc.left());
                }
                if (Literal.FALSE.equals(bc.right())) {
                    return e instanceof Equals ? new Not(bc.left().source(), bc.left()) : bc.left();
                }
            }
            return e;
        }
    }

    public static final class ConstantFolding
    extends OptimizerExpressionRule {
        public ConstantFolding() {
            super(TransformDirection.DOWN);
        }

        @Override
        public Expression rule(Expression e) {
            return e.foldable() ? Literal.of(e) : e;
        }
    }
}

