/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.regex;

import java.util.Objects;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.expression.predicate.regex.RegexProcessor;
import org.elasticsearch.xpack.ql.expression.predicate.regex.StringPattern;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public abstract class RegexMatch<T extends StringPattern>
extends UnaryScalarFunction {
    private final T pattern;

    protected RegexMatch(Source source, Expression value, T pattern) {
        super(source, value);
        this.pattern = pattern;
    }

    public T pattern() {
        return this.pattern;
    }

    @Override
    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    @Override
    public Nullability nullable() {
        if (this.pattern() == null) {
            return Nullability.TRUE;
        }
        return this.field().nullable();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isStringAndExact(this.field(), this.sourceText(), Expressions.ParamOrdinal.DEFAULT);
    }

    @Override
    public boolean foldable() {
        return this.field().foldable();
    }

    @Override
    public Boolean fold() {
        Object val = this.field().fold();
        return RegexProcessor.RegexOperation.match(val, this.pattern().asJavaRegex());
    }

    @Override
    protected Processor makeProcessor() {
        return new RegexProcessor(this.pattern().asJavaRegex());
    }

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate fieldAsScript = this.asScript(this.field());
        return new ScriptTemplate(this.formatTemplate(LoggerMessageFormat.format((String)"{sql}.", (String)"regex({},{})", (Object[])new Object[]{fieldAsScript.template()})), ParamsBuilder.paramsBuilder().script(fieldAsScript.params()).variable(this.pattern.asJavaRegex()).build(), this.dataType());
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(((RegexMatch)obj).pattern(), this.pattern());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pattern());
    }
}

