/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.fulltext;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.predicate.fulltext.FullTextPredicate;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class MatchQueryPredicate
extends FullTextPredicate {
    private final Expression field;

    public MatchQueryPredicate(Source source, Expression field, String query, String options) {
        super(source, query, options, Collections.singletonList(field));
        this.field = field;
    }

    @Override
    protected NodeInfo<MatchQueryPredicate> info() {
        return NodeInfo.create(this, MatchQueryPredicate::new, this.field, this.query(), this.options());
    }

    @Override
    public MatchQueryPredicate replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 1) {
            throw new IllegalArgumentException("expected [1] child but received [" + newChildren.size() + "]");
        }
        return new MatchQueryPredicate(this.source(), newChildren.get(0), this.query(), this.options());
    }

    public Expression field() {
        return this.field;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            MatchQueryPredicate other = (MatchQueryPredicate)obj;
            return Objects.equals(this.field, other.field);
        }
        return false;
    }
}

