/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.gen.pipeline;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.execution.search.QlSourceBuilder;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.tree.Source;

public abstract class BinaryPipe
extends Pipe {
    private final Pipe left;
    private final Pipe right;

    public BinaryPipe(Source source, Expression expression, Pipe left, Pipe right) {
        super(source, expression, Arrays.asList(left, right));
        this.left = left;
        this.right = right;
    }

    @Override
    public final Pipe replaceChildren(List<Pipe> newChildren) {
        if (newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        return this.replaceChildren(newChildren.get(0), newChildren.get(1));
    }

    public Pipe left() {
        return this.left;
    }

    public Pipe right() {
        return this.right;
    }

    @Override
    public boolean supportedByAggsOnlyQuery() {
        return this.left.supportedByAggsOnlyQuery() || this.right.supportedByAggsOnlyQuery();
    }

    @Override
    public final Pipe resolveAttributes(Pipe.AttributeResolver resolver) {
        Pipe newLeft = this.left.resolveAttributes(resolver);
        Pipe newRight = this.right.resolveAttributes(resolver);
        if (newLeft == this.left && newRight == this.right) {
            return this;
        }
        return this.replaceChildren(newLeft, newRight);
    }

    protected abstract BinaryPipe replaceChildren(Pipe var1, Pipe var2);

    @Override
    public boolean resolved() {
        return this.left().resolved() && this.right().resolved();
    }

    @Override
    public final void collectFields(QlSourceBuilder sourceBuilder) {
        this.left.collectFields(sourceBuilder);
        this.right.collectFields(sourceBuilder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left(), this.right());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryPipe other = (BinaryPipe)obj;
        return Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right());
    }
}

