/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.function.scalar;

import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.ql.expression.function.scalar.IntervalScripting;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.expression.gen.script.Scripts;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.DateUtils;

public abstract class ScalarFunction
extends Function {
    protected ScalarFunction(Source source) {
        super(source, Collections.emptyList());
    }

    protected ScalarFunction(Source source, List<Expression> fields) {
        super(source, fields);
    }

    public ScriptTemplate asScript(Expression exp) {
        if (exp.foldable()) {
            return this.scriptWithFoldable(exp);
        }
        if (exp instanceof FieldAttribute) {
            return this.scriptWithField((FieldAttribute)exp);
        }
        if (exp instanceof ScalarFunction) {
            return this.scriptWithScalar((ScalarFunction)exp);
        }
        if (exp instanceof AggregateFunction) {
            return this.scriptWithAggregate((AggregateFunction)exp);
        }
        if (exp instanceof GroupingFunction) {
            return this.scriptWithGrouping((GroupingFunction)exp);
        }
        throw new QlIllegalArgumentException("Cannot evaluate script for expression {}", exp);
    }

    protected ScriptTemplate scriptWithFoldable(Expression foldable) {
        Object fold = foldable.fold();
        if (fold instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)fold;
            return new ScriptTemplate(this.processScript("{sql}.asDateTime({})"), ParamsBuilder.paramsBuilder().variable(DateUtils.toString(zdt)).build(), this.dataType());
        }
        if (fold instanceof IntervalScripting) {
            IntervalScripting is = (IntervalScripting)fold;
            return new ScriptTemplate(this.processScript(is.script()), ParamsBuilder.paramsBuilder().variable(is.value()).variable(is.typeName()).build(), this.dataType());
        }
        if (fold instanceof OffsetTime) {
            OffsetTime ot = (OffsetTime)fold;
            return new ScriptTemplate(this.processScript("{sql}.asTime({})"), ParamsBuilder.paramsBuilder().variable(ot.toString()).build(), this.dataType());
        }
        if (fold != null && fold.getClass().getSimpleName().equals("GeoShape")) {
            return new ScriptTemplate(this.processScript("{sql}.stWktToSql({})"), ParamsBuilder.paramsBuilder().variable(fold.toString()).build(), this.dataType());
        }
        return new ScriptTemplate(this.processScript("{}"), ParamsBuilder.paramsBuilder().variable(fold).build(), this.dataType());
    }

    protected ScriptTemplate scriptWithScalar(ScalarFunction scalar) {
        ScriptTemplate nested = scalar.asScript();
        return new ScriptTemplate(this.processScript(nested.template()), ParamsBuilder.paramsBuilder().script(nested.params()).build(), this.dataType());
    }

    protected ScriptTemplate scriptWithAggregate(AggregateFunction aggregate) {
        String template = this.basicTemplate(aggregate);
        return new ScriptTemplate(this.processScript(template), ParamsBuilder.paramsBuilder().agg(aggregate).build(), this.dataType());
    }

    protected ScriptTemplate scriptWithGrouping(GroupingFunction grouping) {
        String template = this.basicTemplate(grouping);
        return new ScriptTemplate(this.processScript(template), ParamsBuilder.paramsBuilder().grouping(grouping).build(), this.dataType());
    }

    private String basicTemplate(Function function) {
        if (function.dataType().name().equals("DATE") || function.dataType() == DataTypes.DATETIME) {
            return "{sql}.asDateTime({})";
        }
        return "{}";
    }

    protected ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable(field.name()).build(), this.dataType());
    }

    protected String processScript(String script) {
        return this.formatTemplate(script);
    }

    protected String formatTemplate(String template) {
        return Scripts.formatTemplate(template);
    }
}

