/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.AttributeSet;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.NameId;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;

public abstract class Attribute
extends NamedExpression {
    private final String qualifier;
    private final Nullability nullability;

    public Attribute(Source source, String name, String qualifier, NameId id) {
        this(source, name, qualifier, Nullability.TRUE, id);
    }

    public Attribute(Source source, String name, String qualifier, Nullability nullability, NameId id) {
        this(source, name, qualifier, nullability, id, false);
    }

    public Attribute(Source source, String name, String qualifier, Nullability nullability, NameId id, boolean synthetic) {
        super(source, name, Collections.emptyList(), id, synthetic);
        this.qualifier = qualifier;
        this.nullability = nullability;
    }

    @Override
    public final Expression replaceChildren(List<Expression> newChildren) {
        throw new UnsupportedOperationException("this type of node doesn't have any children to replace");
    }

    public String qualifier() {
        return this.qualifier;
    }

    public String qualifiedName() {
        return this.qualifier == null ? this.name() : this.qualifier + "." + this.name();
    }

    @Override
    public Nullability nullable() {
        return this.nullability;
    }

    @Override
    public AttributeSet references() {
        return new AttributeSet(this);
    }

    public Attribute withLocation(Source source) {
        return Objects.equals(this.source(), source) ? this : this.clone(source, this.name(), this.dataType(), this.qualifier(), this.nullable(), this.id(), this.synthetic());
    }

    public Attribute withQualifier(String qualifier) {
        return Objects.equals(this.qualifier(), qualifier) ? this : this.clone(this.source(), this.name(), this.dataType(), qualifier, this.nullable(), this.id(), this.synthetic());
    }

    public Attribute withName(String name) {
        return Objects.equals(this.name(), name) ? this : this.clone(this.source(), name, this.dataType(), this.qualifier(), this.nullable(), this.id(), this.synthetic());
    }

    public Attribute withNullability(Nullability nullability) {
        return Objects.equals((Object)this.nullable(), (Object)nullability) ? this : this.clone(this.source(), this.name(), this.dataType(), this.qualifier(), nullability, this.id(), this.synthetic());
    }

    public Attribute withId(NameId id) {
        return this.clone(this.source(), this.name(), this.dataType(), this.qualifier(), this.nullable(), id, this.synthetic());
    }

    public Attribute withDataType(DataType type) {
        return Objects.equals(this.dataType(), type) ? this : this.clone(this.source(), this.name(), type, this.qualifier(), this.nullable(), this.id(), this.synthetic());
    }

    protected abstract Attribute clone(Source var1, String var2, DataType var3, String var4, Nullability var5, NameId var6, boolean var7);

    @Override
    public Attribute toAttribute() {
        return this;
    }

    @Override
    public int semanticHash() {
        return this.id().hashCode();
    }

    @Override
    public boolean semanticEquals(Expression other) {
        return other instanceof Attribute ? this.id().equals(((Attribute)other).id()) : false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.qualifier, this.nullability});
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            Attribute other = (Attribute)obj;
            return Objects.equals(this.qualifier, other.qualifier) && Objects.equals((Object)this.nullability, (Object)other.nullability);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.qualifiedName() + "{" + this.label() + "}#" + this.id();
    }

    @Override
    public String nodeString() {
        return this.toString();
    }

    protected abstract String label();
}

