/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.job;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.rollup.action.StartRollupJobAction;
import org.elasticsearch.xpack.core.rollup.action.StopRollupJobAction;
import org.elasticsearch.xpack.core.rollup.job.RollupIndexerJobStats;
import org.elasticsearch.xpack.core.rollup.job.RollupJob;
import org.elasticsearch.xpack.core.rollup.job.RollupJobConfig;
import org.elasticsearch.xpack.core.rollup.job.RollupJobStatus;
import org.elasticsearch.xpack.core.scheduler.CronSchedule;
import org.elasticsearch.xpack.core.scheduler.SchedulerEngine;
import org.elasticsearch.xpack.rollup.job.RollupIndexer;

public class RollupJobTask
extends AllocatedPersistentTask
implements SchedulerEngine.Listener {
    private static final Logger logger = LogManager.getLogger((String)RollupJobTask.class.getName());
    static final String SCHEDULE_NAME = "xpack/rollup/job/schedule";
    private final RollupJob job;
    private final SchedulerEngine schedulerEngine;
    private final ThreadPool threadPool;
    private final Client client;
    private final IndexerState initialIndexerState;
    private final Map<String, Object> initialPosition;
    private RollupIndexer indexer;
    private final AtomicBoolean upgradedDocumentID = new AtomicBoolean(false);

    RollupJobTask(long id, String type, String action, TaskId parentTask, RollupJob job, RollupJobStatus state, Client client, SchedulerEngine schedulerEngine, ThreadPool threadPool, Map<String, String> headers) {
        super(id, type, action, "rollup_" + job.getConfig().getId(), parentTask, headers);
        this.job = job;
        this.schedulerEngine = schedulerEngine;
        this.threadPool = threadPool;
        this.client = client;
        if (state == null) {
            this.initialIndexerState = null;
            this.initialPosition = null;
            this.upgradedDocumentID.set(true);
        } else {
            this.initialIndexerState = state.getIndexerState();
            this.initialPosition = state.getPosition();
            this.upgradedDocumentID.set(state.isUpgradedDocumentID());
        }
    }

    protected void init(PersistentTasksService persistentTasksService, TaskManager taskManager, String persistentTaskId, long allocationId) {
        super.init(persistentTasksService, taskManager, persistentTaskId, allocationId);
        IndexerState initialState = IndexerState.STOPPED;
        if (this.initialIndexerState != null) {
            logger.debug("We have existing state, setting state to [" + this.initialIndexerState + "] and current position to [" + this.initialIndexerState + "] for job [" + this.job.getConfig().getId() + "]");
            initialState = this.initialIndexerState.equals((Object)IndexerState.INDEXING) ? IndexerState.STARTED : (this.initialIndexerState.equals((Object)IndexerState.ABORTING) || this.initialIndexerState.equals((Object)IndexerState.STOPPING) ? IndexerState.STOPPED : this.initialIndexerState);
        }
        this.indexer = new ClientRollupPageManager(this.job, initialState, this.initialPosition, (Client)new ParentTaskAssigningClient(this.client, this.getParentTaskId()), this.upgradedDocumentID);
    }

    public Task.Status getStatus() {
        return new RollupJobStatus(this.indexer.getState(), (Map)this.indexer.getPosition(), Boolean.valueOf(this.upgradedDocumentID.get()));
    }

    public RollupIndexerJobStats getStats() {
        return (RollupIndexerJobStats)this.indexer.getStats();
    }

    public RollupJobConfig getConfig() {
        return this.job.getConfig();
    }

    public synchronized void start(ActionListener<StartRollupJobAction.Response> listener) {
        IndexerState prevState = this.indexer.getState();
        if (prevState != IndexerState.STOPPED) {
            listener.onFailure((Exception)new ElasticsearchException("Cannot start task for Rollup Job [" + this.job.getConfig().getId() + "] because state was [" + prevState + "]", new Object[0]));
            return;
        }
        IndexerState newState = this.indexer.start();
        if (newState != IndexerState.STARTED) {
            listener.onFailure((Exception)new ElasticsearchException("Cannot start task for Rollup Job [" + this.job.getConfig().getId() + "] because state was [" + newState + "]", new Object[0]));
            return;
        }
        RollupJobStatus state = new RollupJobStatus(IndexerState.STARTED, (Map)this.indexer.getPosition(), Boolean.valueOf(this.upgradedDocumentID.get()));
        logger.debug("Updating state for rollup job [" + this.job.getConfig().getId() + "] to [" + state.getIndexerState() + "][" + state.getPosition() + "]");
        this.updatePersistentTaskState((PersistentTaskState)state, ActionListener.wrap(task -> {
            logger.debug("Successfully updated state for rollup job [" + this.job.getConfig().getId() + "] to [" + state.getIndexerState() + "][" + state.getPosition() + "]");
            listener.onResponse((Object)new StartRollupJobAction.Response(true));
        }, exc -> {
            this.indexer.stop();
            listener.onFailure((Exception)new ElasticsearchException("Error while updating state for rollup job [" + this.job.getConfig().getId() + "] to [" + state.getIndexerState() + "].", (Throwable)exc, new Object[0]));
        }));
    }

    public synchronized void stop(ActionListener<StopRollupJobAction.Response> listener) {
        IndexerState newState = this.indexer.stop();
        switch (newState) {
            case STOPPED: {
                listener.onResponse((Object)new StopRollupJobAction.Response(true));
                break;
            }
            case STOPPING: {
                RollupJobStatus state = new RollupJobStatus(IndexerState.STOPPED, (Map)this.indexer.getPosition(), Boolean.valueOf(this.upgradedDocumentID.get()));
                this.updatePersistentTaskState((PersistentTaskState)state, ActionListener.wrap(task -> {
                    logger.debug("Successfully updated state for rollup job [" + this.job.getConfig().getId() + "] to [" + state.getIndexerState() + "]");
                    listener.onResponse((Object)new StopRollupJobAction.Response(true));
                }, exc -> listener.onFailure((Exception)new ElasticsearchException("Error while updating state for rollup job [" + this.job.getConfig().getId() + "] to [" + state.getIndexerState() + "].", (Throwable)exc, new Object[0]))));
                break;
            }
            default: {
                listener.onFailure((Exception)new ElasticsearchException("Cannot stop task for Rollup Job [" + this.job.getConfig().getId() + "] because state was [" + newState + "]", new Object[0]));
            }
        }
    }

    synchronized void shutdown() {
        try {
            logger.info("Rollup indexer [" + this.job.getConfig().getId() + "] received abort request, stopping indexer.");
            this.schedulerEngine.remove("xpack/rollup/job/schedule_" + this.job.getConfig().getId());
            this.schedulerEngine.unregister((SchedulerEngine.Listener)this);
        }
        catch (Exception e) {
            this.markAsFailed(e);
            return;
        }
        this.markAsCompleted();
    }

    public synchronized void onCancelled() {
        logger.info("Received cancellation request for Rollup job [" + this.job.getConfig().getId() + "], state: [" + this.indexer.getState() + "]");
        if (this.indexer.abort()) {
            this.shutdown();
        }
    }

    public synchronized void triggered(SchedulerEngine.Event event) {
        if (event.getJobName().equals("xpack/rollup/job/schedule_" + this.job.getConfig().getId())) {
            logger.debug("Rollup indexer [" + event.getJobName() + "] schedule has triggered, state: [" + this.indexer.getState() + "]");
            this.indexer.maybeTriggerAsyncJob(System.currentTimeMillis());
        }
    }

    protected class ClientRollupPageManager
    extends RollupIndexer {
        private final Client client;
        private final RollupJob job;

        ClientRollupPageManager(RollupJob job, IndexerState initialState, Map<String, Object> initialPosition, Client client, AtomicBoolean upgradedDocumentID) {
            super(RollupJobTask.this.threadPool, "generic", job, new AtomicReference<IndexerState>(initialState), initialPosition, upgradedDocumentID);
            this.client = client;
            this.job = job;
        }

        protected void doNextSearch(long waitTimeInNanos, ActionListener<SearchResponse> nextPhase) {
            ClientHelper.executeWithHeadersAsync((Map)this.job.getHeaders(), (String)"rollup", (Client)this.client, (ActionType)SearchAction.INSTANCE, (ActionRequest)this.buildSearchRequest(), nextPhase);
        }

        protected void doNextBulk(BulkRequest request, ActionListener<BulkResponse> nextPhase) {
            ClientHelper.executeWithHeadersAsync((Map)this.job.getHeaders(), (String)"rollup", (Client)this.client, (ActionType)BulkAction.INSTANCE, (ActionRequest)request, nextPhase);
        }

        protected void doSaveState(IndexerState indexerState, Map<String, Object> position, Runnable next) {
            if (indexerState.equals((Object)IndexerState.ABORTING)) {
                next.run();
            } else {
                boolean oldState = this.upgradedDocumentID.getAndSet(true);
                RollupJobStatus state = new RollupJobStatus(indexerState, (Map)this.getPosition(), Boolean.valueOf(this.upgradedDocumentID.get()));
                logger.debug("Updating persistent state of job [" + this.job.getConfig().getId() + "] to [" + indexerState.toString() + "]");
                RollupJobTask.this.updatePersistentTaskState((PersistentTaskState)state, ActionListener.wrap(task -> next.run(), exc -> {
                    this.upgradedDocumentID.set(oldState);
                    next.run();
                }));
            }
        }

        protected void onFinish(ActionListener<Void> listener) {
            logger.debug("Finished indexing for job [" + this.job.getConfig().getId() + "]");
            listener.onResponse(null);
        }

        protected void onFailure(Exception exc) {
            logger.warn("Rollup job [" + this.job.getConfig().getId() + "] failed with an exception: ", (Throwable)exc);
        }

        protected void onAbort() {
            RollupJobTask.this.shutdown();
        }
    }

    public static class RollupJobPersistentTasksExecutor
    extends PersistentTasksExecutor<RollupJob> {
        private final Client client;
        private final SchedulerEngine schedulerEngine;
        private final ThreadPool threadPool;

        public RollupJobPersistentTasksExecutor(Client client, SchedulerEngine schedulerEngine, ThreadPool threadPool) {
            super("xpack/rollup/job", "rollup_indexing");
            this.client = client;
            this.schedulerEngine = schedulerEngine;
            this.threadPool = threadPool;
        }

        protected void nodeOperation(AllocatedPersistentTask task, @Nullable RollupJob params, PersistentTaskState state) {
            RollupJobTask rollupJobTask = (RollupJobTask)task;
            SchedulerEngine.Job schedulerJob = new SchedulerEngine.Job("xpack/rollup/job/schedule_" + params.getConfig().getId(), (SchedulerEngine.Schedule)new CronSchedule(params.getConfig().getCron()));
            this.schedulerEngine.register((SchedulerEngine.Listener)rollupJobTask);
            this.schedulerEngine.add(schedulerJob);
            logger.info("Rollup job [" + params.getConfig().getId() + "] created.");
        }

        protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<RollupJob> persistentTask, Map<String, String> headers) {
            return new RollupJobTask(id, type, action, parentTaskId, (RollupJob)persistentTask.getParams(), (RollupJobStatus)persistentTask.getState(), this.client, this.schedulerEngine, this.threadPool, headers);
        }
    }
}

