/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.sp;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xpack.core.security.support.MustacheTemplateEvaluator;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProviderDocument;

class WildcardServiceProvider {
    private static final ConstructingObjectParser<WildcardServiceProvider, Void> PARSER = new ConstructingObjectParser("wildcard_service", args -> {
        String entityId = (String)args[0];
        String acs = (String)args[1];
        Collection tokens = (Collection)args[2];
        Map definition = (Map)args[3];
        return new WildcardServiceProvider(entityId, acs, tokens, definition);
    });
    private final Pattern matchEntityId;
    private final Pattern matchAcs;
    private final Set<String> tokens;
    private final BytesReference serviceTemplate;

    private WildcardServiceProvider(Pattern matchEntityId, Pattern matchAcs, Set<String> tokens, BytesReference serviceTemplate) {
        this.matchEntityId = Objects.requireNonNull(matchEntityId);
        this.matchAcs = Objects.requireNonNull(matchAcs);
        this.tokens = Objects.requireNonNull(tokens);
        this.serviceTemplate = Objects.requireNonNull(serviceTemplate);
    }

    WildcardServiceProvider(String matchEntityId, String matchAcs, Collection<String> tokens, Map<String, Object> serviceTemplate) {
        this(Pattern.compile(Objects.requireNonNull(matchEntityId, "EntityID to match cannot be null")), Pattern.compile(Objects.requireNonNull(matchAcs, "ACS to match cannot be null")), Collections.unmodifiableSet(new HashSet<String>(Objects.requireNonNull(tokens, "Tokens collection may not be null"))), WildcardServiceProvider.toMustacheScript(Objects.requireNonNull(serviceTemplate, "Service definition may not be null")));
    }

    public static WildcardServiceProvider parse(XContentParser parser) throws IOException {
        return (WildcardServiceProvider)PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WildcardServiceProvider that = (WildcardServiceProvider)o;
        return this.matchEntityId.pattern().equals(that.matchEntityId.pattern()) && this.matchAcs.pattern().equals(that.matchAcs.pattern()) && this.tokens.equals(that.tokens) && this.serviceTemplate.equals(that.serviceTemplate);
    }

    public int hashCode() {
        return Objects.hash(this.matchEntityId.pattern(), this.matchAcs.pattern(), this.tokens, this.serviceTemplate);
    }

    private static BytesReference toMustacheScript(Map<String, Object> serviceDefinition) {
        try {
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.startObject();
            builder.field("source");
            builder.map(serviceDefinition);
            builder.endObject();
            return BytesReference.bytes((XContentBuilder)builder);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    public SamlServiceProviderDocument apply(ScriptService scriptService, String entityId, String acs) {
        Map<String, Object> parameters = this.extractTokens(entityId, acs);
        if (parameters == null) {
            return null;
        }
        try {
            String serviceJson = this.evaluateTemplate(scriptService, parameters);
            SamlServiceProviderDocument doc = this.toServiceProviderDocument(serviceJson);
            Instant now = Instant.now();
            doc.setEntityId(entityId);
            doc.setAcs(acs);
            doc.setCreated(now);
            doc.setLastModified(now);
            return doc;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    Map<String, Object> extractTokens(String entityId, String acs) {
        Matcher entityIdMatcher = this.matchEntityId.matcher(entityId);
        if (!entityIdMatcher.matches()) {
            return null;
        }
        Matcher acsMatcher = this.matchAcs.matcher(acs);
        if (!acsMatcher.matches()) {
            return null;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (String token : this.tokens) {
            String entityIdToken = this.extractGroup(entityIdMatcher, token);
            String acsToken = this.extractGroup(acsMatcher, token);
            if (entityIdToken != null) {
                if (acsToken != null && !entityIdToken.equals(acsToken)) {
                    throw new IllegalArgumentException("Extracted token [" + token + "] values from EntityID ([" + entityIdToken + "] from [" + entityId + "]) and ACS ([" + acsToken + "] from [" + acs + "]) do not match");
                }
                parameters.put(token, entityIdToken);
                continue;
            }
            if (acsToken == null) continue;
            parameters.put(token, acsToken);
        }
        parameters.putIfAbsent("entity_id", entityId);
        parameters.putIfAbsent("acs", acs);
        return parameters;
    }

    private String evaluateTemplate(ScriptService scriptService, Map<String, Object> parameters) throws IOException {
        try (XContentParser templateParser = WildcardServiceProvider.parser(this.serviceTemplate);){
            String string = MustacheTemplateEvaluator.evaluate((ScriptService)scriptService, (XContentParser)templateParser, parameters);
            return string;
        }
    }

    private SamlServiceProviderDocument toServiceProviderDocument(String serviceJson) throws IOException {
        try (XContentParser docParser = WildcardServiceProvider.parser((BytesReference)new BytesArray(serviceJson));){
            SamlServiceProviderDocument samlServiceProviderDocument = SamlServiceProviderDocument.fromXContent(null, docParser);
            return samlServiceProviderDocument;
        }
    }

    private static XContentParser parser(BytesReference body) throws IOException {
        return XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)body, (XContentType)XContentType.JSON);
    }

    private String extractGroup(Matcher matcher, String name) {
        try {
            return matcher.group(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Fields.ENTITY_ID);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Fields.ACS);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), Fields.TOKENS);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, ignore) -> p.map(), Fields.TEMPLATE);
    }

    public static interface Fields {
        public static final ParseField ENTITY_ID = new ParseField("entity_id", new String[0]);
        public static final ParseField ACS = new ParseField("acs", new String[0]);
        public static final ParseField TOKENS = new ParseField("tokens", new String[0]);
        public static final ParseField TEMPLATE = new ParseField("template", new String[0]);
    }
}

